/*
 * Decompiled with CFR 0.152.
 */
package com.shopgun.android.sdk.network;

import com.shopgun.android.sdk.SgnLocation;
import com.shopgun.android.sdk.network.Request;
import java.util.Map;

public class NetworkUtils {
    private NetworkUtils() {
    }

    public static void appendLocationParams(Map<String, String> map, SgnLocation l) {
        if (!l.isSet()) {
            return;
        }
        if (!map.containsKey("r_lat")) {
            map.put("r_lat", String.valueOf(l.getLatitude()));
        }
        if (!map.containsKey("r_lng")) {
            map.put("r_lng", String.valueOf(l.getLongitude()));
        }
        if (!map.containsKey("r_sensor")) {
            map.put("r_sensor", String.valueOf(l.isSensor()));
        }
        if (!map.containsKey("r_radius")) {
            map.put("r_radius", String.valueOf(l.getRadius()));
        }
        if (l.isBoundsSet()) {
            if (!map.containsKey("b_east")) {
                map.put("b_east", String.valueOf(l.getBoundEast()));
            }
            if (!map.containsKey("b_north")) {
                map.put("b_north", String.valueOf(l.getBoundNorth()));
            }
            if (!map.containsKey("b_south")) {
                map.put("b_south", String.valueOf(l.getBoundSouth()));
            }
            if (!map.containsKey("b_west")) {
                map.put("b_west", String.valueOf(l.getBoundWest()));
            }
        }
    }

    public static SgnLocation getLocationParams(Request<?> request) {
        SgnLocation l = new SgnLocation();
        Map<String, String> map = request.getParameters();
        if (map.containsKey("r_lat")) {
            l.setLatitude(Double.valueOf(map.get("r_lat")));
        }
        if (map.containsKey("r_lng")) {
            l.setLongitude(Double.valueOf(map.get("r_lng")));
        }
        if (map.containsKey("r_sensor")) {
            l.setSensor(Boolean.valueOf(map.get("r_sensor")));
        }
        if (map.containsKey("r_radius")) {
            l.setRadius(Integer.valueOf(map.get("r_radius")));
        }
        if (map.containsKey("b_east") && map.containsKey("b_north") && map.containsKey("b_south") && map.containsKey("b_west")) {
            l.setBounds(Double.valueOf(map.get("b_north")), Double.valueOf(map.get("b_east")), Double.valueOf(map.get("b_south")), Double.valueOf(map.get("b_west")));
        }
        return l;
    }
}

