/*
 * Decompiled with CFR 0.152.
 */
package com.shopgun.android.sdk.model;

import android.os.Parcel;
import android.os.Parcelable;
import com.shopgun.android.sdk.model.Permission;
import com.shopgun.android.sdk.model.interfaces.IErn;
import com.shopgun.android.sdk.model.interfaces.IJson;
import com.shopgun.android.sdk.utils.Constants;
import com.shopgun.android.sdk.utils.SgnJson;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import org.json.JSONArray;
import org.json.JSONObject;

public class User
implements IErn<User>,
IJson<JSONObject>,
Parcelable {
    public static final String TAG = Constants.getTag(User.class);
    public static final int NO_USER = -1;
    public static Parcelable.Creator<User> CREATOR = new Parcelable.Creator<User>(){

        public User createFromParcel(Parcel source) {
            return new User(source);
        }

        public User[] newArray(int size) {
            return new User[size];
        }
    };
    private String mErn;
    private String mGender;
    private int mBirthYear = 0;
    private String mName;
    private String mEmail;
    private Permission mPermissions;

    public User() {
        this.setUserId(-1);
    }

    private User(Parcel in) {
        this.mErn = in.readString();
        this.mGender = in.readString();
        this.mBirthYear = in.readInt();
        this.mName = in.readString();
        this.mEmail = in.readString();
        this.mPermissions = (Permission)in.readParcelable(Permission.class.getClassLoader());
    }

    public static List<User> fromJSON(JSONArray array) {
        ArrayList<User> list = new ArrayList<User>();
        for (int i = 0; i < array.length(); ++i) {
            JSONObject o = array.optJSONObject(i);
            if (o == null) continue;
            list.add(User.fromJSON(o));
        }
        return list;
    }

    public static User fromJSON(JSONObject object) {
        if (object == null) {
            return null;
        }
        SgnJson o = new SgnJson(object);
        User user = new User().setId(o.getId()).setErn(o.getErn()).setGender(o.getGender()).setBirthYear(o.getBirthYear()).setName(o.getName()).setEmail(o.getEmail()).setPermissions(o.getPermissions());
        o.getStats().log(TAG);
        return user;
    }

    @Override
    public JSONObject toJSON() {
        return new SgnJson().setId(this.getId()).setErn(this.getErn()).setGender(this.getGender()).setBirthYear(this.getBirthYear()).setName(this.getName()).setEmail(this.getEmail()).setPermissions(this.getPermissions()).toJSON();
    }

    public boolean isLoggedIn() {
        return this.mEmail != null && this.getUserId() > -1;
    }

    @Override
    @Deprecated
    public String getId() {
        return String.valueOf(this.getUserId());
    }

    @Override
    @Deprecated
    public User setId(String id) {
        this.setUserId(id == null ? -1 : Integer.valueOf(id));
        return this;
    }

    @Override
    public String getErn() {
        return this.mErn;
    }

    @Override
    public User setErn(String ern) {
        if (ern == null) {
            this.setUserId(-1);
        } else if (ern.startsWith("ern:") && ern.split(":").length == 3 && ern.contains(this.getErnType())) {
            this.mErn = ern;
        }
        return this;
    }

    @Override
    public String getErnType() {
        return "user";
    }

    public int getUserId() {
        if (this.mErn == null) {
            this.setUserId(-1);
        }
        String[] parts = this.mErn.split(":");
        return Integer.valueOf(parts[parts.length - 1]);
    }

    public User setUserId(int id) {
        this.setErn(String.format("ern:%s:%s", this.getErnType(), id));
        return this;
    }

    public String getGender() {
        return this.mGender;
    }

    public User setGender(String gender) {
        if (gender != null && ((gender = gender.toLowerCase(Locale.ENGLISH)).equals("male") || gender.equals("female"))) {
            this.mGender = gender;
        }
        return this;
    }

    public int getBirthYear() {
        return this.mBirthYear;
    }

    public User setBirthYear(int birthYear) {
        this.mBirthYear = birthYear;
        return this;
    }

    public String getName() {
        return this.mName;
    }

    public User setName(String name) {
        if (name != null) {
            this.mName = name;
        }
        return this;
    }

    public String getEmail() {
        return this.mEmail;
    }

    public User setEmail(String email) {
        this.mEmail = email;
        return this;
    }

    public Permission getPermissions() {
        return this.mPermissions;
    }

    public User setPermissions(Permission permissions) {
        this.mPermissions = permissions;
        return this;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.mBirthYear;
        result = 31 * result + (this.mEmail == null ? 0 : this.mEmail.hashCode());
        result = 31 * result + (this.mErn == null ? 0 : this.mErn.hashCode());
        result = 31 * result + (this.mGender == null ? 0 : this.mGender.hashCode());
        result = 31 * result + (this.mName == null ? 0 : this.mName.hashCode());
        result = 31 * result + (this.mPermissions == null ? 0 : this.mPermissions.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        User other = (User)obj;
        if (this.mBirthYear != other.mBirthYear) {
            return false;
        }
        if (this.mEmail == null ? other.mEmail != null : !this.mEmail.equals(other.mEmail)) {
            return false;
        }
        if (this.mErn == null ? other.mErn != null : !this.mErn.equals(other.mErn)) {
            return false;
        }
        if (this.mGender == null ? other.mGender != null : !this.mGender.equals(other.mGender)) {
            return false;
        }
        if (this.mName == null ? other.mName != null : !this.mName.equals(other.mName)) {
            return false;
        }
        return !(this.mPermissions == null ? other.mPermissions != null : !this.mPermissions.equals(other.mPermissions));
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        dest.writeString(this.mErn);
        dest.writeString(this.mGender);
        dest.writeInt(this.mBirthYear);
        dest.writeString(this.mName);
        dest.writeString(this.mEmail);
        dest.writeParcelable((Parcelable)this.mPermissions, flags);
    }
}

