/*
 * Decompiled with CFR 0.152.
 */
package com.shopgun.android.sdk.model;

import android.os.Parcel;
import android.os.Parcelable;
import com.shopgun.android.sdk.model.Si;
import com.shopgun.android.sdk.model.interfaces.IJson;
import com.shopgun.android.sdk.utils.Constants;
import com.shopgun.android.sdk.utils.SgnJson;
import java.util.ArrayList;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONObject;

public class Unit
implements IJson<JSONObject>,
Parcelable {
    public static final String TAG = Constants.getTag(Unit.class);
    public static Parcelable.Creator<Unit> CREATOR = new Parcelable.Creator<Unit>(){

        public Unit createFromParcel(Parcel source) {
            return new Unit(source);
        }

        public Unit[] newArray(int size) {
            return new Unit[size];
        }
    };
    private String mSymbol;
    private Si mSi;

    public Unit() {
    }

    private Unit(Parcel in) {
        this.mSymbol = in.readString();
        this.mSi = (Si)in.readParcelable(Si.class.getClassLoader());
    }

    public static List<Unit> fromJSON(JSONArray array) {
        ArrayList<Unit> list = new ArrayList<Unit>();
        for (int i = 0; i < array.length(); ++i) {
            JSONObject o = array.optJSONObject(i);
            if (o == null) continue;
            list.add(Unit.fromJSON(o));
        }
        return list;
    }

    public static Unit fromJSON(JSONObject object) {
        if (object == null) {
            return null;
        }
        SgnJson o = new SgnJson(object);
        Unit u = new Unit().setSymbol(o.getSymbol()).setSi(o.getSi());
        o.getStats().log(TAG);
        return u;
    }

    @Override
    public JSONObject toJSON() {
        return new SgnJson().setSymbol(this.getSymbol()).setSi(this.getSi()).toJSON();
    }

    public String getSymbol() {
        return this.mSymbol;
    }

    public Unit setSymbol(String symbol) {
        this.mSymbol = symbol;
        return this;
    }

    public Si getSi() {
        return this.mSi;
    }

    public Unit setSi(Si si) {
        this.mSi = si;
        return this;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.mSi == null ? 0 : this.mSi.hashCode());
        result = 31 * result + (this.mSymbol == null ? 0 : this.mSymbol.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Unit other = (Unit)obj;
        if (this.mSi == null ? other.mSi != null : !this.mSi.equals(other.mSi)) {
            return false;
        }
        return !(this.mSymbol == null ? other.mSymbol != null : !this.mSymbol.equals(other.mSymbol));
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        dest.writeString(this.mSymbol);
        dest.writeParcelable((Parcelable)this.mSi, flags);
    }
}

