/*
 * Decompiled with CFR 0.152.
 */
package com.shopgun.android.sdk.model;

import android.os.Parcel;
import android.os.Parcelable;
import android.text.Html;
import android.text.Spanned;
import com.shopgun.android.sdk.log.SgnLog;
import com.shopgun.android.sdk.model.interfaces.IJson;
import com.shopgun.android.sdk.utils.Constants;
import com.shopgun.android.sdk.utils.SgnJson;
import java.util.ArrayList;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONObject;

public class Typeahead
implements IJson<JSONObject>,
Parcelable {
    public static final String TAG = Constants.getTag(Typeahead.class);
    public static Parcelable.Creator<Typeahead> CREATOR = new Parcelable.Creator<Typeahead>(){

        public Typeahead createFromParcel(Parcel source) {
            return new Typeahead(source);
        }

        public Typeahead[] newArray(int size) {
            return new Typeahead[size];
        }
    };
    private int mLength = 0;
    private int mOffset = 0;
    private String mSubject;

    public Typeahead() {
    }

    public Typeahead(String typeahead) {
        this.mSubject = typeahead;
    }

    private Typeahead(Parcel in) {
        this.mLength = in.readInt();
        this.mOffset = in.readInt();
        this.mSubject = in.readString();
    }

    public static List<Typeahead> fromJSON(JSONArray array) {
        ArrayList<Typeahead> list = new ArrayList<Typeahead>();
        for (int i = 0; i < array.length(); ++i) {
            JSONObject o = array.optJSONObject(i);
            if (o == null) continue;
            list.add(Typeahead.fromJSON(o));
        }
        return list;
    }

    public static Typeahead fromJSON(JSONObject object) {
        if (object == null) {
            return null;
        }
        SgnJson o = new SgnJson(object);
        Typeahead typeahead = new Typeahead().setSubject(o.getSubject()).setOffset(o.getOffset()).setLength(o.getLength());
        o.getStats().log(TAG);
        return typeahead;
    }

    @Override
    public JSONObject toJSON() {
        return new SgnJson().setSubject(this.getSubject()).setOffset(this.getOffset()).setLength(this.getLength()).toJSON();
    }

    public int getLength() {
        return this.mLength;
    }

    public Typeahead setLength(int length) {
        this.mLength = length;
        return this;
    }

    public int getOffset() {
        return this.mOffset;
    }

    public Typeahead setOffset(int offset) {
        this.mOffset = offset;
        return this;
    }

    public String getSubject() {
        return this.mSubject;
    }

    public Typeahead setSubject(String subject) {
        this.mSubject = subject;
        return this;
    }

    public Spanned getHtml() {
        return this.getHtml("<b>", "</b>");
    }

    public Spanned getHtml(String startTag, String endTag) {
        if (this.mSubject == null) {
            return null;
        }
        if (this.mOffset == 0 && this.mLength == 0 || this.mOffset > this.mSubject.length() || this.mOffset + this.mLength > this.mSubject.length()) {
            return Html.fromHtml((String)this.mSubject);
        }
        try {
            StringBuilder sb = new StringBuilder();
            int start = this.mOffset;
            int end = this.mOffset + this.mLength;
            if (this.mOffset > 0) {
                sb.append(this.mSubject.substring(0, start));
            }
            sb.append(startTag);
            sb.append(this.mSubject.substring(start, end));
            sb.append(endTag);
            if (end < this.mSubject.length()) {
                sb.append(this.mSubject.substring(end));
            }
            String html = sb.toString();
            return Html.fromHtml((String)html);
        }
        catch (StringIndexOutOfBoundsException e) {
            SgnLog.e(TAG, "", e);
            return Html.fromHtml((String)this.mSubject);
        }
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.mLength;
        result = 31 * result + this.mOffset;
        result = 31 * result + (this.mSubject == null ? 0 : this.mSubject.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Typeahead other = (Typeahead)obj;
        if (this.mLength != other.mLength) {
            return false;
        }
        if (this.mOffset != other.mOffset) {
            return false;
        }
        return !(this.mSubject == null ? other.mSubject != null : !this.mSubject.equals(other.mSubject));
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        dest.writeInt(this.mLength);
        dest.writeInt(this.mOffset);
        dest.writeString(this.mSubject);
    }
}

