/*
 * Decompiled with CFR 0.152.
 */
package com.shopgun.android.sdk.model;

import android.os.Parcel;
import android.os.Parcelable;
import com.shopgun.android.sdk.model.Offer;
import com.shopgun.android.sdk.model.Shoppinglist;
import com.shopgun.android.sdk.model.interfaces.IJson;
import com.shopgun.android.sdk.model.interfaces.SyncState;
import com.shopgun.android.sdk.utils.Constants;
import com.shopgun.android.sdk.utils.SgnJson;
import com.shopgun.android.sdk.utils.SgnUtils;
import com.shopgun.android.utils.DateUtils;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

@Deprecated
public class ShoppinglistItem
implements Comparable<ShoppinglistItem>,
SyncState<ShoppinglistItem>,
IJson<JSONObject>,
Parcelable {
    public static final String TAG = Constants.getTag(ShoppinglistItem.class);
    private static final String ERN_CLASS = "shoppinglist:item";
    public static Parcelable.Creator<ShoppinglistItem> CREATOR = new Parcelable.Creator<ShoppinglistItem>(){

        public ShoppinglistItem createFromParcel(Parcel source) {
            return new ShoppinglistItem(source);
        }

        public ShoppinglistItem[] newArray(int size) {
            return new ShoppinglistItem[size];
        }
    };
    private String mId;
    private String mErn;
    private boolean mTick = false;
    private String mOfferId = null;
    private int mCount = 1;
    private String mDescription = null;
    public static Comparator<ShoppinglistItem> TITLE_ASCENDING = new Comparator<ShoppinglistItem>(){

        @Override
        public int compare(ShoppinglistItem item1, ShoppinglistItem item2) {
            if (item1 == null || item2 == null) {
                return item1 == null ? (item2 == null ? 0 : 1) : -1;
            }
            String t1 = item1.getDescription();
            String t2 = item2.getDescription();
            if (t1 == null || t2 == null) {
                return t1 == null ? (t2 == null ? 0 : 1) : -1;
            }
            return t1.compareToIgnoreCase(t2);
        }
    };
    private String mCreator;
    private Date mModified;
    public static Comparator<ShoppinglistItem> MODIFIED_DESCENDING = new Comparator<ShoppinglistItem>(){

        @Override
        public int compare(ShoppinglistItem item1, ShoppinglistItem item2) {
            if (item1 == null || item2 == null) {
                return item1 == null ? (item2 == null ? 0 : 1) : -1;
            }
            Date d1 = item1.getModified();
            Date d2 = item2.getModified();
            if (d1 == null || d2 == null) {
                return d1 == null ? (d2 == null ? 0 : 1) : -1;
            }
            return d2.compareTo(d1);
        }
    };
    private Offer mOffer = null;
    private String mShoppinglistId;
    private String mPrevId;
    private JSONObject mMeta;
    private int mUserId = -1;
    private int mSyncState = 0;

    public ShoppinglistItem() {
        this.setId(SgnUtils.createUUID());
        this.setModified(new Date());
    }

    public ShoppinglistItem(Shoppinglist shoppinglist, String description) {
        this();
        this.setShoppinglistId(shoppinglist.getId());
        this.setDescription(description);
    }

    public ShoppinglistItem(Shoppinglist shoppinglist, Offer offer) {
        this();
        this.setShoppinglistId(shoppinglist.getId());
        this.setOffer(offer);
    }

    private ShoppinglistItem(Parcel in) {
        this.mId = in.readString();
        this.mErn = in.readString();
        this.mTick = in.readByte() != 0;
        this.mOfferId = in.readString();
        this.mCount = in.readInt();
        this.mDescription = in.readString();
        this.mCreator = in.readString();
        long tmpMModified = in.readLong();
        this.mModified = tmpMModified == -1L ? null : new Date(tmpMModified);
        this.mOffer = (Offer)in.readParcelable(Offer.class.getClassLoader());
        this.mShoppinglistId = in.readString();
        this.mPrevId = in.readString();
        String json = in.readString();
        try {
            this.mMeta = new JSONObject(json);
        }
        catch (JSONException e) {
            this.mMeta = new JSONObject();
        }
        this.mUserId = in.readInt();
        this.mSyncState = in.readInt();
    }

    public static List<ShoppinglistItem> fromJSON(JSONArray array) {
        ArrayList<ShoppinglistItem> list = new ArrayList<ShoppinglistItem>();
        for (int i = 0; i < array.length(); ++i) {
            JSONObject o = array.optJSONObject(i);
            if (o == null) continue;
            list.add(ShoppinglistItem.fromJSON(o));
        }
        return list;
    }

    public static ShoppinglistItem fromJSON(JSONObject object) {
        if (object == null) {
            return null;
        }
        SgnJson o = new SgnJson(object);
        ShoppinglistItem sli = new ShoppinglistItem().setId(o.getId()).setErn(o.getErn()).setTick(o.getTick()).setOfferId(o.getOfferId()).setCount(o.getCount()).setDescription(o.getDescription()).setShoppinglistId(o.getShoppingListId()).setCreator(o.getCreator()).setModified(o.getModified()).setPreviousId(o.getPreviousId()).setMeta(o.getMeta());
        o.getStats().log(TAG);
        return sli;
    }

    @Override
    public JSONObject toJSON() {
        return new SgnJson().setId(this.getId()).setErn(this.getErn()).setTick(this.isTicked()).setOfferId(this.getOfferId()).setCount(this.getCount()).setDescription(this.getDescription()).setShoppingListId(this.getShoppinglistId()).setCreator(this.getCreator()).setModified(this.getModified()).setPreviousId(this.getPreviousId()).setMeta(this.getMeta()).toJSON();
    }

    public String getId() {
        return this.mId;
    }

    public ShoppinglistItem setId(String id) {
        this.mId = id;
        this.mErn = String.format("ern:%s:%s", ERN_CLASS, id);
        return this;
    }

    public String getErn() {
        return this.mErn;
    }

    public ShoppinglistItem setErn(String ern) {
        if (ern != null) {
            this.mErn = ern;
            String[] parts = this.mErn.split(":");
            this.mId = parts[parts.length - 1];
        }
        return this;
    }

    public String getDescription() {
        return this.mDescription == null ? "" : this.mDescription;
    }

    public ShoppinglistItem setDescription(String description) {
        this.mDescription = description;
        return this;
    }

    public int getCount() {
        return this.mCount;
    }

    public ShoppinglistItem setCount(int count) {
        this.mCount = count;
        return this;
    }

    public boolean isTicked() {
        return this.mTick;
    }

    public ShoppinglistItem setTick(boolean tick) {
        this.mTick = tick;
        return this;
    }

    public Offer getOffer() {
        return this.mOffer;
    }

    public ShoppinglistItem setOffer(Offer offer) {
        this.mOffer = offer;
        if (this.mOffer != null) {
            if (this.mDescription == null || !this.mOffer.getId().equals(this.mOfferId)) {
                this.setDescription(this.mOffer.getHeading());
            }
            this.setOfferId(offer.getId());
        } else {
            this.setOfferId(null);
        }
        return this;
    }

    public String getCreator() {
        return this.mCreator;
    }

    public ShoppinglistItem setCreator(String creator) {
        this.mCreator = creator;
        return this;
    }

    public String getShoppinglistId() {
        return this.mShoppinglistId;
    }

    public ShoppinglistItem setShoppinglistId(String id) {
        this.mShoppinglistId = id;
        return this;
    }

    public String getPreviousId() {
        return this.mPrevId;
    }

    public ShoppinglistItem setPreviousId(String id) {
        this.mPrevId = id;
        return this;
    }

    public String getOfferId() {
        return this.mOfferId;
    }

    public ShoppinglistItem setOfferId(String offerId) {
        this.mOfferId = offerId;
        return this;
    }

    public Date getModified() {
        return this.mModified;
    }

    public ShoppinglistItem setModified(Date time) {
        this.mModified = DateUtils.roundTime((Date)time);
        return this;
    }

    public JSONObject getMeta() {
        if (this.mMeta == null) {
            this.mMeta = new JSONObject();
        }
        return this.mMeta;
    }

    public ShoppinglistItem setMeta(JSONObject meta) {
        this.mMeta = meta == null ? new JSONObject() : meta;
        return this;
    }

    public int getUserId() {
        return this.mUserId;
    }

    public ShoppinglistItem setUserId(int userId) {
        this.mUserId = userId;
        return this;
    }

    public String getComment() {
        String comment = this.mMeta.optString("eta_comment");
        return comment.length() == 0 ? null : comment;
    }

    public ShoppinglistItem setComment(String comment) {
        try {
            this.getMeta().put("eta_comment", (Object)comment);
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        return this;
    }

    @Override
    public int getState() {
        return this.mSyncState;
    }

    @Override
    public ShoppinglistItem setState(int state) {
        this.mSyncState = state;
        return this;
    }

    public String toString() {
        return this.toJSON().toString();
    }

    @Override
    public int compareTo(ShoppinglistItem another) {
        return TITLE_ASCENDING.compare(this, another);
    }

    private boolean compare(Object obj, boolean modified, boolean offer, boolean user, boolean syncState) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ShoppinglistItem other = (ShoppinglistItem)obj;
        if (this.mCount != other.mCount) {
            return false;
        }
        if (this.mCreator == null ? other.mCreator != null : !this.mCreator.equals(other.mCreator)) {
            return false;
        }
        if (this.mDescription == null ? other.mDescription != null : !this.mDescription.equals(other.mDescription)) {
            return false;
        }
        if (this.mErn == null ? other.mErn != null : !this.mErn.equals(other.mErn)) {
            return false;
        }
        if (this.mId == null ? other.mId != null : !this.mId.equals(other.mId)) {
            return false;
        }
        if (this.mMeta == null ? other.mMeta != null : !SgnJson.jsonObjectEquals(this.mMeta, other.mMeta)) {
            return false;
        }
        if (modified && (this.mModified == null ? other.mModified != null : !this.mModified.equals(other.mModified))) {
            return false;
        }
        if (offer && (this.mOffer == null ? other.mOffer != null : !this.mOffer.equals(other.mOffer))) {
            return false;
        }
        if (this.mOfferId == null ? other.mOfferId != null : !this.mOfferId.equals(other.mOfferId)) {
            return false;
        }
        if (this.mPrevId == null ? other.mPrevId != null : !this.mPrevId.equals(other.mPrevId)) {
            return false;
        }
        if (this.mShoppinglistId == null ? other.mShoppinglistId != null : !this.mShoppinglistId.equals(other.mShoppinglistId)) {
            return false;
        }
        if (syncState && this.mSyncState != other.mSyncState) {
            return false;
        }
        if (this.mTick != other.mTick) {
            return false;
        }
        return !user || this.mUserId == other.mUserId;
    }

    public boolean same(Object obj) {
        return this.compare(obj, false, false, false, false);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.mCount;
        result = 31 * result + (this.mCreator == null ? 0 : this.mCreator.hashCode());
        result = 31 * result + (this.mDescription == null ? 0 : this.mDescription.hashCode());
        result = 31 * result + (this.mErn == null ? 0 : this.mErn.hashCode());
        result = 31 * result + (this.mId == null ? 0 : this.mId.hashCode());
        result = 31 * result + SgnJson.jsonObjectHashCode(this.mMeta);
        result = 31 * result + (this.mModified == null ? 0 : this.mModified.hashCode());
        result = 31 * result + (this.mOffer == null ? 0 : this.mOffer.hashCode());
        result = 31 * result + (this.mOfferId == null ? 0 : this.mOfferId.hashCode());
        result = 31 * result + (this.mPrevId == null ? 0 : this.mPrevId.hashCode());
        result = 31 * result + (this.mShoppinglistId == null ? 0 : this.mShoppinglistId.hashCode());
        result = 31 * result + this.mSyncState;
        result = 31 * result + (this.mTick ? 1231 : 1237);
        result = 31 * result + this.mUserId;
        return result;
    }

    public boolean equals(Object obj) {
        return this.compare(obj, true, true, true, true);
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        dest.writeString(this.mId);
        dest.writeString(this.mErn);
        dest.writeByte(this.mTick ? (byte)1 : 0);
        dest.writeString(this.mOfferId);
        dest.writeInt(this.mCount);
        dest.writeString(this.mDescription);
        dest.writeString(this.mCreator);
        dest.writeLong(this.mModified != null ? this.mModified.getTime() : -1L);
        dest.writeParcelable((Parcelable)this.mOffer, flags);
        dest.writeString(this.mShoppinglistId);
        dest.writeString(this.mPrevId);
        dest.writeString(this.mMeta.toString());
        dest.writeInt(this.mUserId);
        dest.writeInt(this.mSyncState);
    }
}

