/*
 * Decompiled with CFR 0.152.
 */
package com.shopgun.android.sdk.model;

import android.os.Parcel;
import android.os.Parcelable;
import com.shopgun.android.sdk.model.Permission;
import com.shopgun.android.sdk.model.User;
import com.shopgun.android.sdk.model.interfaces.IJson;
import com.shopgun.android.sdk.utils.Constants;
import com.shopgun.android.sdk.utils.SgnJson;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONObject;

public class Session
implements IJson<JSONObject>,
Parcelable {
    public static final String TAG = Constants.getTag(Session.class);
    public static Parcelable.Creator<Session> CREATOR = new Parcelable.Creator<Session>(){

        public Session createFromParcel(Parcel source) {
            return new Session(source);
        }

        public Session[] newArray(int size) {
            return new Session[size];
        }
    };
    private String mToken;
    private Date mExpires = new Date(1000L);
    private User mUser = new User();
    private Permission mPermission;
    private String mProvider;
    private String mClientId;
    private String mReference;

    public Session() {
    }

    private Session(Parcel in) {
        this.mToken = in.readString();
        long tmpMExpires = in.readLong();
        this.mExpires = tmpMExpires == -1L ? null : new Date(tmpMExpires);
        this.mUser = (User)in.readParcelable(User.class.getClassLoader());
        this.mPermission = (Permission)in.readParcelable(Permission.class.getClassLoader());
        this.mProvider = in.readString();
        this.mClientId = in.readString();
        this.mReference = in.readString();
    }

    public static List<Session> fromJSON(JSONArray array) {
        ArrayList<Session> list = new ArrayList<Session>();
        for (int i = 0; i < array.length(); ++i) {
            JSONObject o = array.optJSONObject(i);
            if (o == null) continue;
            list.add(Session.fromJSON(o));
        }
        return list;
    }

    public static Session fromJSON(JSONObject object) {
        if (object == null) {
            return null;
        }
        SgnJson o = new SgnJson(object);
        Session s = new Session().setToken(o.getToken()).setExpires(o.getExpires()).setClientId(o.getClientId()).setReference(o.getReference()).setUser(o.getUser()).setPermission(o.getPermissions()).setProvider(o.getProvider());
        o.getStats().log(TAG);
        return s;
    }

    @Override
    public JSONObject toJSON() {
        return new SgnJson().setToken(this.getToken()).setExpires(this.getExpire()).setClientId(this.getClientId()).setReference(this.getReference()).setUser(this.getUser()).setPermissions(this.getPermission()).setProvider(this.getProvider()).toJSON();
    }

    public String getToken() {
        return this.mToken;
    }

    public Session setToken(String token) {
        this.mToken = token;
        return this;
    }

    public String getClientId() {
        return this.mClientId;
    }

    public Session setClientId(String clientId) {
        this.mClientId = clientId;
        return this;
    }

    public String getReference() {
        return this.mReference;
    }

    public Session setReference(String reference) {
        this.mReference = reference;
        return this;
    }

    public User getUser() {
        return this.mUser;
    }

    public Session setUser(User user) {
        this.mUser = user == null ? new User() : user;
        return this;
    }

    public Permission getPermission() {
        return this.mPermission;
    }

    public Session setPermission(Permission permission2) {
        this.mPermission = permission2;
        return this;
    }

    public String getProvider() {
        return this.mProvider;
    }

    public Session setProvider(String provider) {
        this.mProvider = provider;
        return this;
    }

    public Session setExpires(Date time) {
        this.mExpires = time;
        return this;
    }

    public Date getExpire() {
        return this.mExpires;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Session session = (Session)o;
        if (this.mToken != null ? !this.mToken.equals(session.mToken) : session.mToken != null) {
            return false;
        }
        if (this.mExpires != null ? !this.mExpires.equals(session.mExpires) : session.mExpires != null) {
            return false;
        }
        if (this.mUser != null ? !this.mUser.equals(session.mUser) : session.mUser != null) {
            return false;
        }
        if (this.mPermission != null ? !this.mPermission.equals(session.mPermission) : session.mPermission != null) {
            return false;
        }
        if (this.mProvider != null ? !this.mProvider.equals(session.mProvider) : session.mProvider != null) {
            return false;
        }
        if (this.mClientId != null ? !this.mClientId.equals(session.mClientId) : session.mClientId != null) {
            return false;
        }
        return this.mReference != null ? this.mReference.equals(session.mReference) : session.mReference == null;
    }

    public int hashCode() {
        int result = this.mToken != null ? this.mToken.hashCode() : 0;
        result = 31 * result + (this.mExpires != null ? this.mExpires.hashCode() : 0);
        result = 31 * result + (this.mUser != null ? this.mUser.hashCode() : 0);
        result = 31 * result + (this.mPermission != null ? this.mPermission.hashCode() : 0);
        result = 31 * result + (this.mProvider != null ? this.mProvider.hashCode() : 0);
        result = 31 * result + (this.mClientId != null ? this.mClientId.hashCode() : 0);
        result = 31 * result + (this.mReference != null ? this.mReference.hashCode() : 0);
        return result;
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        dest.writeString(this.mToken);
        dest.writeLong(this.mExpires != null ? this.mExpires.getTime() : -1L);
        dest.writeParcelable((Parcelable)this.mUser, flags);
        dest.writeParcelable((Parcelable)this.mPermission, flags);
        dest.writeString(this.mProvider);
        dest.writeString(this.mClientId);
        dest.writeString(this.mReference);
    }
}

