/*
 * Decompiled with CFR 0.152.
 */
package com.shopgun.android.sdk.model;

import android.os.Parcel;
import android.os.Parcelable;
import com.shopgun.android.sdk.model.Pieces;
import com.shopgun.android.sdk.model.Size;
import com.shopgun.android.sdk.model.Unit;
import com.shopgun.android.sdk.model.interfaces.IJson;
import com.shopgun.android.sdk.utils.Constants;
import com.shopgun.android.sdk.utils.SgnJson;
import java.util.ArrayList;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONObject;

public class Quantity
implements IJson<JSONObject>,
Parcelable {
    public static final String TAG = Constants.getTag(Quantity.class);
    public static Parcelable.Creator<Quantity> CREATOR = new Parcelable.Creator<Quantity>(){

        public Quantity createFromParcel(Parcel source) {
            return new Quantity(source);
        }

        public Quantity[] newArray(int size) {
            return new Quantity[size];
        }
    };
    private Unit mUnit;
    private Size mSize;
    private Pieces mPieces;

    public Quantity() {
    }

    private Quantity(Parcel in) {
        this.mUnit = (Unit)in.readParcelable(Unit.class.getClassLoader());
        this.mSize = (Size)in.readParcelable(Size.class.getClassLoader());
        this.mPieces = (Pieces)in.readParcelable(Pieces.class.getClassLoader());
    }

    public static List<Quantity> fromJSON(JSONArray array) {
        ArrayList<Quantity> list = new ArrayList<Quantity>();
        for (int i = 0; i < array.length(); ++i) {
            JSONObject o = array.optJSONObject(i);
            if (o == null) continue;
            list.add(Quantity.fromJSON(o));
        }
        return list;
    }

    public static Quantity fromJSON(JSONObject object) {
        if (object == null) {
            return null;
        }
        SgnJson o = new SgnJson(object);
        Quantity q = new Quantity().setUnit(o.getUnit()).setSize(o.getSize()).setPieces(o.getPieces());
        o.getStats().log(TAG);
        return q;
    }

    @Override
    public JSONObject toJSON() {
        return new SgnJson().setUnit(this.getUnit()).setSize(this.getSize()).setPieces(this.getPieces()).toJSON();
    }

    public Unit getUnit() {
        return this.mUnit;
    }

    public Quantity setUnit(Unit unit) {
        this.mUnit = unit;
        return this;
    }

    public Size getSize() {
        return this.mSize;
    }

    public Quantity setSize(Size size) {
        this.mSize = size;
        return this;
    }

    public Pieces getPieces() {
        return this.mPieces;
    }

    public Quantity setPieces(Pieces pieces) {
        this.mPieces = pieces;
        return this;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.mPieces == null ? 0 : this.mPieces.hashCode());
        result = 31 * result + (this.mSize == null ? 0 : this.mSize.hashCode());
        result = 31 * result + (this.mUnit == null ? 0 : this.mUnit.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Quantity other = (Quantity)obj;
        if (this.mPieces == null ? other.mPieces != null : !this.mPieces.equals(other.mPieces)) {
            return false;
        }
        if (this.mSize == null ? other.mSize != null : !this.mSize.equals(other.mSize)) {
            return false;
        }
        return !(this.mUnit == null ? other.mUnit != null : !this.mUnit.equals(other.mUnit));
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        dest.writeParcelable((Parcelable)this.mUnit, flags);
        dest.writeParcelable((Parcelable)this.mSize, flags);
        dest.writeParcelable((Parcelable)this.mPieces, flags);
    }
}

