/*
 * Decompiled with CFR 0.152.
 */
package com.shopgun.android.sdk.model;

import android.os.Parcel;
import android.os.Parcelable;
import com.shopgun.android.sdk.model.interfaces.IJson;
import com.shopgun.android.sdk.utils.Constants;
import com.shopgun.android.sdk.utils.SgnJson;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Currency;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONObject;

public class Pricing
implements IJson<JSONObject>,
Parcelable {
    public static final String TAG = Constants.getTag(Pricing.class);
    private double mPrice = 1.0;
    private Double mPrePrice;
    private Currency mCurrency;
    public static final Parcelable.Creator<Pricing> CREATOR = new Parcelable.Creator<Pricing>(){

        public Pricing createFromParcel(Parcel source) {
            return new Pricing(source);
        }

        public Pricing[] newArray(int size) {
            return new Pricing[size];
        }
    };

    public Pricing() {
    }

    public static List<Pricing> fromJSON(JSONArray array) {
        ArrayList<Pricing> list = new ArrayList<Pricing>();
        for (int i = 0; i < array.length(); ++i) {
            JSONObject o = array.optJSONObject(i);
            if (o == null) continue;
            list.add(Pricing.fromJSON(o));
        }
        return list;
    }

    public static Pricing fromJSON(JSONObject object) {
        if (object == null) {
            return null;
        }
        SgnJson o = new SgnJson(object);
        Pricing p = new Pricing().setPrice(o.getPrice()).setPrePrice(o.getPrePrice()).setCurrency(o.getCurrency());
        o.getStats().log(TAG);
        return p;
    }

    @Override
    public JSONObject toJSON() {
        return new SgnJson().setPrice(this.getPrice()).setPrePrice(this.getPrePrice()).setCurrency(this.getCurrency().getCurrencyCode()).toJSON();
    }

    public double getPrice() {
        return this.mPrice;
    }

    public Pricing setPrice(double price) {
        this.mPrice = price;
        return this;
    }

    public Double getPrePrice() {
        return this.mPrePrice;
    }

    public Pricing setPrePrice(Double prePrice) {
        this.mPrePrice = prePrice;
        return this;
    }

    public Currency getCurrency() {
        if (this.mCurrency == null) {
            return Currency.getInstance("DKK");
        }
        return this.mCurrency;
    }

    public Pricing setCurrency(String isoCurrencyCode) {
        this.mCurrency = Currency.getInstance(isoCurrencyCode == null ? "DKK" : isoCurrencyCode);
        return this;
    }

    public Pricing setCurrency(Currency currency) {
        this.mCurrency = currency == null ? Currency.getInstance("DKK") : currency;
        return this;
    }

    public boolean hasPrePrice() {
        return this.mPrePrice != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Pricing pricing = (Pricing)o;
        if (Double.compare(pricing.mPrice, this.mPrice) != 0) {
            return false;
        }
        if (this.mPrePrice != null ? !this.mPrePrice.equals(pricing.mPrePrice) : pricing.mPrePrice != null) {
            return false;
        }
        return !(this.mCurrency == null ? pricing.mCurrency != null : !this.mCurrency.equals(pricing.mCurrency));
    }

    public int hashCode() {
        long temp = Double.doubleToLongBits(this.mPrice);
        int result = (int)(temp ^ temp >>> 32);
        result = 31 * result + (this.mPrePrice != null ? this.mPrePrice.hashCode() : 0);
        result = 31 * result + (this.mCurrency != null ? this.mCurrency.hashCode() : 0);
        return result;
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        dest.writeDouble(this.mPrice);
        dest.writeValue((Object)this.mPrePrice);
        dest.writeSerializable((Serializable)this.mCurrency);
    }

    protected Pricing(Parcel in) {
        this.mPrice = in.readDouble();
        this.mPrePrice = (Double)in.readValue(Double.class.getClassLoader());
        this.mCurrency = (Currency)in.readSerializable();
    }
}

