/*
 * Decompiled with CFR 0.152.
 */
package com.shopgun.android.sdk.model;

import android.os.Parcel;
import android.os.Parcelable;
import com.shopgun.android.sdk.model.interfaces.IJson;
import com.shopgun.android.sdk.utils.Constants;
import com.shopgun.android.sdk.utils.SgnJson;
import java.util.ArrayList;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONObject;

public class Images
implements IJson<JSONObject>,
Parcelable {
    public static final String TAG = Constants.getTag(Images.class);
    private String mView;
    private String mZoom;
    private String mThumb;
    public static final Parcelable.Creator<Images> CREATOR = new Parcelable.Creator<Images>(){

        public Images createFromParcel(Parcel source) {
            return new Images(source);
        }

        public Images[] newArray(int size) {
            return new Images[size];
        }
    };

    public Images() {
    }

    public static List<Images> fromJSON(JSONArray array) {
        ArrayList<Images> list = new ArrayList<Images>();
        for (int i = 0; i < array.length(); ++i) {
            JSONObject o = array.optJSONObject(i);
            if (o == null) continue;
            list.add(Images.fromJSON(o));
        }
        return list;
    }

    public static Images fromJSON(JSONObject object) {
        if (object == null) {
            return null;
        }
        SgnJson o = new SgnJson(object);
        Images i = new Images().setView(o.getView()).setZoom(o.getZoom()).setThumb(o.getThumb());
        o.getStats().ignoreForgottenKeys("@note.1").log(TAG);
        return i;
    }

    @Override
    public JSONObject toJSON() {
        return new SgnJson().setView(this.getView()).setZoom(this.getZoom()).setThumb(this.getThumb()).toJSON();
    }

    public String getView() {
        return this.mView;
    }

    public Images setView(String viewUrl) {
        this.mView = viewUrl;
        return this;
    }

    public String getZoom() {
        return this.mZoom;
    }

    public Images setZoom(String zoomUrl) {
        this.mZoom = zoomUrl;
        return this;
    }

    public String getThumb() {
        return this.mThumb;
    }

    public Images setThumb(String thumbUrl) {
        this.mThumb = thumbUrl;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Images images = (Images)o;
        if (this.mView != null ? !this.mView.equals(images.mView) : images.mView != null) {
            return false;
        }
        if (this.mZoom != null ? !this.mZoom.equals(images.mZoom) : images.mZoom != null) {
            return false;
        }
        return !(this.mThumb == null ? images.mThumb != null : !this.mThumb.equals(images.mThumb));
    }

    public int hashCode() {
        int result = this.mView != null ? this.mView.hashCode() : 0;
        result = 31 * result + (this.mZoom != null ? this.mZoom.hashCode() : 0);
        result = 31 * result + (this.mThumb != null ? this.mThumb.hashCode() : 0);
        return result;
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        dest.writeString(this.mView);
        dest.writeString(this.mZoom);
        dest.writeString(this.mThumb);
    }

    protected Images(Parcel in) {
        this.mView = in.readString();
        this.mZoom = in.readString();
        this.mThumb = in.readString();
    }
}

