/*
 * Decompiled with CFR 0.152.
 */
package com.shopgun.android.sdk.model;

import android.graphics.RectF;
import android.os.Parcel;
import android.os.Parcelable;
import android.util.SparseArray;
import com.shopgun.android.sdk.log.SgnLog;
import com.shopgun.android.sdk.model.Offer;
import com.shopgun.android.sdk.model.interfaces.IJson;
import com.shopgun.android.sdk.pagedpublicationkit.PagedPublicationHotspot;
import com.shopgun.android.sdk.utils.Constants;
import com.shopgun.android.utils.PolygonF;
import com.shopgun.android.utils.TextUtils;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class Hotspot
implements IJson<JSONObject>,
PagedPublicationHotspot,
Parcelable {
    public static final String TAG = Constants.getTag(Hotspot.class);
    public static final double SIGNIFICANT_AREA = 0.02;
    public static final String TYPE = "offer";
    SparseArray<PolygonF> mLocations = new SparseArray();
    private String mType;
    private Offer mOffer;
    public static final Parcelable.Creator<Hotspot> CREATOR = new Parcelable.Creator<Hotspot>(){

        public Hotspot createFromParcel(Parcel source) {
            return new Hotspot(source);
        }

        public Hotspot[] newArray(int size) {
            return new Hotspot[size];
        }
    };

    public static Hotspot fromJSON(JSONObject hotspot) {
        Hotspot h = new Hotspot();
        if (hotspot == null) {
            return h;
        }
        try {
            String type = hotspot.optString("type", null);
            h.setType(type);
            JSONObject offer = hotspot.getJSONObject(TYPE);
            Offer o = Offer.fromJSON(offer);
            h.setOffer(o);
            JSONObject locations = hotspot.getJSONObject("locations");
            Iterator it = locations.keys();
            while (it.hasNext()) {
                String page = (String)it.next();
                int intPage = Integer.valueOf(page) - 1;
                JSONArray location = locations.getJSONArray(page);
                PolygonF poly = new PolygonF(location.length());
                for (int i = 0; i < location.length(); ++i) {
                    JSONArray point = location.getJSONArray(i);
                    float x = Float.valueOf(point.getString(0)).floatValue();
                    float y = Float.valueOf(point.getString(1)).floatValue();
                    poly.addPoint(x, y);
                }
                h.mLocations.append(intPage, (Object)poly);
            }
        }
        catch (JSONException e) {
            SgnLog.e(TAG, e.getMessage(), e);
        }
        return h;
    }

    public Hotspot() {
    }

    public void normalize(double width, double height) {
        ArrayList<Object> polygons = new ArrayList<Object>();
        for (int p : this.getPages()) {
            polygons.add(this.mLocations.get(p));
        }
        Object object = polygons.iterator();
        while (object.hasNext()) {
            PolygonF p = (PolygonF)object.next();
            for (int i = 0; i < p.npoints; ++i) {
                p.ypoints[i] = p.ypoints[i] / (float)height;
                p.xpoints[i] = p.xpoints[i] / (float)width;
            }
        }
    }

    @Override
    public boolean hasPolygonAt(int[] visiblePages, int clickedPage, float x, float y) {
        return this.hasLocationAt(visiblePages, clickedPage, x, y);
    }

    @Override
    public List<PolygonF> getPolygons() {
        return this.getLocations();
    }

    @Override
    public List<PolygonF> getPolygons(int[] pages) {
        return this.getLocationsForPages(pages);
    }

    @Override
    public int[] getPages() {
        int[] pages = new int[this.mLocations.size()];
        for (int i = 0; i < this.mLocations.size(); ++i) {
            pages[i] = this.mLocations.keyAt(i);
        }
        return pages;
    }

    public List<PolygonF> getLocations() {
        return this.getLocationsForPages(this.getPages());
    }

    public List<PolygonF> getLocationsForPages(int[] pages) {
        ArrayList<PolygonF> locs = new ArrayList<PolygonF>(this.mLocations.size());
        for (int p : pages) {
            PolygonF poly = (PolygonF)this.mLocations.get(p);
            if (poly == null) continue;
            locs.add(poly);
        }
        return locs;
    }

    @Override
    public RectF getBoundsForPages(int[] pages) {
        RectF rect = null;
        float pagesLength = pages.length;
        float pageOffset = 1.0f / pagesLength;
        for (int i = 0; i < pages.length; ++i) {
            int page = pages[i];
            PolygonF p = (PolygonF)this.mLocations.get(page);
            if (p == null) continue;
            RectF r = new RectF(p.getBounds());
            r.right /= pagesLength;
            r.left /= pagesLength;
            r.offset(pageOffset * (float)i, 0.0f);
            if (rect == null) {
                rect = r;
                continue;
            }
            rect.union(r);
        }
        return rect;
    }

    public boolean hasLocationAt(int[] visiblePages, int clickedPage, float x, float y) {
        PolygonF p = (PolygonF)this.mLocations.get(clickedPage);
        return p != null && p.contains(x, y) && this.isAreaSignificant(visiblePages, clickedPage);
    }

    private boolean isAreaSignificant(int[] visiblePages, int clickedPage) {
        return this.isAreaSignificant(visiblePages, clickedPage, 0.02);
    }

    private boolean isAreaSignificant(int[] visiblePages, int clickedPage, double minArea) {
        return visiblePages.length != 1 || this.mLocations.size() <= 1 || this.getArea(clickedPage) > minArea;
    }

    private double getArea(int page) {
        PolygonF p = (PolygonF)this.mLocations.get(page);
        return p == null ? 0.0 : (double)(Math.abs(p.getBounds().height()) * Math.abs(p.getBounds().width()));
    }

    @Override
    public Offer getOffer() {
        return this.mOffer;
    }

    public void setOffer(Offer offer) {
        this.mOffer = offer;
    }

    @Override
    public String getType() {
        return this.mType;
    }

    public void setType(String type) {
        this.mType = type;
    }

    @Override
    public JSONObject toJSON() {
        return null;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (PolygonF poly : this.getLocations()) {
            if (sb.length() > 0) {
                sb.append(", ");
            }
            sb.append(poly.toString());
        }
        String offer = this.mOffer == null ? "null" : this.mOffer.getHeading();
        return "Hotspot[ offer:" + offer + ", type:" + this.mType + ", pages:" + TextUtils.join((CharSequence)",", (int[])this.getPages()) + ", locations:" + sb.toString() + " ]";
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        dest.writeSparseArray(this.mLocations);
        dest.writeString(this.mType);
        dest.writeParcelable((Parcelable)this.mOffer, flags);
    }

    protected Hotspot(Parcel in) {
        this.mLocations = in.readSparseArray(PolygonF.class.getClassLoader());
        this.mType = in.readString();
        this.mOffer = (Offer)in.readParcelable(Offer.class.getClassLoader());
    }
}

