/*
 * Decompiled with CFR 0.152.
 */
package com.shopgun.android.sdk.model;

import android.os.Parcel;
import android.os.Parcelable;
import com.shopgun.android.materialcolorcreator.MaterialColor;
import com.shopgun.android.materialcolorcreator.MaterialColorImpl;
import com.shopgun.android.sdk.model.Pageflip;
import com.shopgun.android.sdk.model.interfaces.IJson;
import com.shopgun.android.sdk.utils.Constants;
import com.shopgun.android.sdk.utils.SgnJson;
import java.util.ArrayList;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONObject;

public class Branding
implements IJson<JSONObject>,
Parcelable {
    public static final String TAG = Constants.getTag(Branding.class);
    private String mName;
    private String mWebsite;
    private String mDescription;
    private String mLogo;
    private MaterialColor mColor;
    private Pageflip mPageflip;
    public static final Parcelable.Creator<Branding> CREATOR = new Parcelable.Creator<Branding>(){

        public Branding createFromParcel(Parcel source) {
            return new Branding(source);
        }

        public Branding[] newArray(int size) {
            return new Branding[size];
        }
    };

    public Branding() {
    }

    public static List<Branding> fromJSON(JSONArray array) {
        ArrayList<Branding> list = new ArrayList<Branding>();
        for (int i = 0; i < array.length(); ++i) {
            JSONObject o = array.optJSONObject(i);
            if (o == null) continue;
            list.add(Branding.fromJSON(o));
        }
        return list;
    }

    public static Branding fromJSON(JSONObject object) {
        if (object == null) {
            return null;
        }
        SgnJson o = new SgnJson(object);
        Branding branding = new Branding();
        branding.setName(o.getName()).setDescription(o.getDescription()).setWebsite(o.getWebsite()).setLogo(o.getLogo()).setColor(o.getMaterialColor()).setPageflip(o.getPageflip());
        o.getStats().log(TAG);
        return branding;
    }

    @Override
    public JSONObject toJSON() {
        return new SgnJson().setName(this.getName()).setWebsite(this.getWebsite()).setDescription(this.getDescription()).setLogo(this.getLogo()).setColor(this.getColor()).setPageflip(this.getPageflip()).toJSON();
    }

    public String getName() {
        return this.mName;
    }

    public Branding setName(String name) {
        this.mName = name;
        return this;
    }

    public String getDescription() {
        return this.mDescription;
    }

    public Branding setDescription(String description) {
        this.mDescription = description;
        return this;
    }

    public String getWebsite() {
        return this.mWebsite;
    }

    public Branding setWebsite(String website) {
        this.mWebsite = website;
        return this;
    }

    public String getLogo() {
        return this.mLogo;
    }

    public Branding setLogo(String logo) {
        this.mLogo = logo;
        return this;
    }

    public int getColor() {
        return this.getMaterialColor().getValue();
    }

    public MaterialColor getMaterialColor() {
        if (this.mColor == null) {
            this.mColor = new MaterialColorImpl();
        }
        return this.mColor;
    }

    public Branding setColor(int color) {
        this.setColor((MaterialColor)new MaterialColorImpl(color));
        return this;
    }

    public Branding setColor(MaterialColor color) {
        this.mColor = color;
        return this;
    }

    public Pageflip getPageflip() {
        return this.mPageflip;
    }

    public Branding setPageflip(Pageflip pageflip) {
        this.mPageflip = pageflip;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Branding branding = (Branding)o;
        if (this.mName != null ? !this.mName.equals(branding.mName) : branding.mName != null) {
            return false;
        }
        if (this.mWebsite != null ? !this.mWebsite.equals(branding.mWebsite) : branding.mWebsite != null) {
            return false;
        }
        if (this.mDescription != null ? !this.mDescription.equals(branding.mDescription) : branding.mDescription != null) {
            return false;
        }
        if (this.mLogo != null ? !this.mLogo.equals(branding.mLogo) : branding.mLogo != null) {
            return false;
        }
        if (this.mColor != null ? !this.mColor.equals(branding.mColor) : branding.mColor != null) {
            return false;
        }
        return this.mPageflip != null ? this.mPageflip.equals(branding.mPageflip) : branding.mPageflip == null;
    }

    public int hashCode() {
        int result = this.mName != null ? this.mName.hashCode() : 0;
        result = 31 * result + (this.mWebsite != null ? this.mWebsite.hashCode() : 0);
        result = 31 * result + (this.mDescription != null ? this.mDescription.hashCode() : 0);
        result = 31 * result + (this.mLogo != null ? this.mLogo.hashCode() : 0);
        result = 31 * result + (this.mColor != null ? this.mColor.hashCode() : 0);
        result = 31 * result + (this.mPageflip != null ? this.mPageflip.hashCode() : 0);
        return result;
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        dest.writeString(this.mName);
        dest.writeString(this.mWebsite);
        dest.writeString(this.mDescription);
        dest.writeString(this.mLogo);
        dest.writeParcelable((Parcelable)this.mColor, 0);
        dest.writeParcelable((Parcelable)this.mPageflip, 0);
    }

    protected Branding(Parcel in) {
        this.mName = in.readString();
        this.mWebsite = in.readString();
        this.mDescription = in.readString();
        this.mLogo = in.readString();
        this.mColor = (MaterialColor)in.readParcelable(MaterialColor.class.getClassLoader());
        this.mPageflip = (Pageflip)in.readParcelable(Pageflip.class.getClassLoader());
    }
}

