/*
 * Decompiled with CFR 0.152.
 */
package com.shopgun.android.sdk.log;

import android.annotation.SuppressLint;
import com.shopgun.android.sdk.log.Event;
import com.shopgun.android.sdk.log.SgnLog;
import com.shopgun.android.sdk.utils.Constants;
import com.shopgun.android.sdk.utils.FixedArrayList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONObject;

public class EventLog {
    public static final String TAG = Constants.getTag(EventLog.class);
    private List<Event> mEvents;

    public EventLog() {
        this.mEvents = Collections.synchronizedList(new ArrayList());
    }

    public EventLog(int logSize) {
        this.mEvents = Collections.synchronizedList(new FixedArrayList(logSize));
    }

    public void add(String name) {
        this.mEvents.add(new Event(name));
    }

    public void add(String type, JSONObject data) {
        this.mEvents.add(new Event(type, type).setData(data));
    }

    public void add(Event e) {
        this.mEvents.add(e);
    }

    public List<Event> getEvents() {
        return this.mEvents;
    }

    public void clear() {
        this.mEvents.clear();
    }

    public List<Event> getType(String type) {
        ArrayList<Event> tmp = new ArrayList<Event>();
        for (Event e : this.mEvents) {
            if (!e.getType().equals(type)) continue;
            tmp.add(e);
        }
        return tmp;
    }

    @SuppressLint(value={"DefaultLocale"})
    public String getString(String name) {
        if (this.mEvents.isEmpty()) {
            SgnLog.d(TAG, String.format("[%+6d ms] %s", 0, name));
        }
        StringBuilder sb = new StringBuilder();
        long prevTime = this.mEvents.get(0).getTime();
        sb.append(String.format("     [%+6d ms] %s", this.getTotalDuration(), name)).append("\n");
        for (int i = 0; i < this.mEvents.size(); ++i) {
            Event e = this.mEvents.get(i);
            sb.append(String.format("[%2d] [%+6d ms] %s", i, e.getTime() - prevTime, e.getName())).append("\n");
            prevTime = e.getTime();
        }
        return sb.toString();
    }

    public JSONArray toJSON(boolean rawTime) {
        return Event.toJSON(this.mEvents, rawTime);
    }

    public long getTotalDuration() {
        if (this.mEvents.isEmpty()) {
            return 0L;
        }
        long first = this.mEvents.get(0).getTime();
        long last = this.mEvents.get(this.mEvents.size() - 1).getTime();
        return last - first;
    }
}

