/*
 * Decompiled with CFR 0.152.
 */
package com.shopgun.android.sdk.log;

import com.shopgun.android.sdk.ShopGun;
import com.shopgun.android.sdk.utils.Constants;
import com.shopgun.android.sdk.utils.SgnJson;
import java.sql.Date;
import java.util.Comparator;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONObject;

public class Event {
    public static final String TAG = Constants.getTag(Event.class);
    public static final String TYPE_REQUEST = "request";
    public static final String TYPE_EXCEPTION = "exception";
    public static final String TYPE_VIEW = "view";
    public static final String TYPE_LOG = "log";
    private long mTime;
    private String mType;
    private String mSessionToken;
    private String mUserErn;
    private String mName;
    private JSONObject mData;
    public static Comparator<Event> timestamp = new Comparator<Event>(){

        @Override
        public int compare(Event e1, Event e2) {
            if (e1 == null || e2 == null) {
                return e1 == null ? (e2 == null ? 0 : 1) : -1;
            }
            return e1.getTime() < e2.getTime() ? -1 : 1;
        }
    };

    public Event(ShopGun sgn, String name) {
        this(sgn, name, TYPE_LOG);
    }

    @Deprecated
    public Event(String name) {
        this(name, TYPE_LOG);
    }

    @Deprecated
    public Event(String name, String type) {
        this(ShopGun.isInstantiated() ? ShopGun.getInstance() : null, name, type);
    }

    public Event(ShopGun sgn, String name, String type) {
        if (sgn != null) {
            this.mUserErn = sgn.getSessionManager().getSession().getUser().getErn();
            this.mSessionToken = sgn.getSessionManager().getSession().getToken();
        }
        this.setName(name);
        this.setType(type);
        this.mTime = System.currentTimeMillis();
    }

    public long getTime() {
        return this.mTime;
    }

    public Event setTime(long time) {
        this.mTime = time;
        return this;
    }

    public String getType() {
        return this.mType;
    }

    public Event setType(String type) {
        this.mType = type == null ? TYPE_LOG : type;
        return this;
    }

    public String getToken() {
        return this.mSessionToken;
    }

    public Event setToken(String token) {
        this.mSessionToken = token;
        return this;
    }

    public String getUser() {
        return this.mUserErn;
    }

    public Event setUser(String userErn) {
        this.mUserErn = userErn;
        return this;
    }

    public String getName() {
        return this.mName;
    }

    public Event setName(String name) {
        this.mName = name == null ? "unknown" : name;
        return this;
    }

    public JSONObject getData() {
        return this.mData;
    }

    public Event setData(JSONObject data) {
        this.mData = data;
        return this;
    }

    public JSONObject toJSON(boolean rawTime) {
        SgnJson o = new SgnJson();
        if (rawTime) {
            o.put("timestamp", this.mTime);
        } else {
            o.putDate("timestamp", new Date(this.mTime));
        }
        o.put("type", this.mType);
        o.put("token", this.mSessionToken);
        o.put("userid", this.mUserErn);
        o.put("name", this.mName);
        o.put("data", this.mData);
        return o.toJSON();
    }

    public static JSONArray toJSON(List<Event> events, boolean rawTime) {
        JSONArray jArray = new JSONArray();
        if (events != null && !events.isEmpty()) {
            for (Event e : events) {
                jArray.put((Object)e.toJSON(rawTime));
            }
        }
        return jArray;
    }
}

