/*
 * Decompiled with CFR 0.152.
 */
package com.shopgun.android.sdk.graphkit;

import com.shopgun.android.sdk.ShopGun;
import com.shopgun.android.utils.TextUtils;
import java.util.HashMap;
import okhttp3.Call;
import okhttp3.Headers;
import okhttp3.HttpUrl;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import org.json.JSONObject;

public class GraphRequest {
    private static final String URL = "https://graph-staging.shopgun.com";
    private static final HttpUrl URL_PARSED = HttpUrl.parse((String)"https://graph-staging.shopgun.com");
    private static final MediaType MEDIA_TYPE_JSON = MediaType.parse((String)"application/json; charset=utf-8");
    private static final Headers HEADERS = new Headers.Builder().add("Content-Type", "application/json").add("Accept", "application/json").build();

    public static Call newCall(String query) {
        return GraphRequest.newCall(ShopGun.getInstance().getClient(), query);
    }

    public static Call newCall(OkHttpClient client, String query) {
        return GraphRequest.newCall(client, query, null, null);
    }

    public static Call newCall(OkHttpClient client, String query, String operationName, String[] variables) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("query", query);
        map.put("operationName", operationName);
        map.put("variables", variables == null ? null : TextUtils.join((CharSequence)",", (Object[])variables));
        RequestBody requestBody = RequestBody.create((MediaType)MEDIA_TYPE_JSON, (String)new JSONObject(map).toString());
        Request request = new Request.Builder().url(URL_PARSED).headers(HEADERS).post(requestBody).build();
        return client.newCall(request);
    }
}

