/*
 * Decompiled with CFR 0.152.
 */
package com.shopgun.android.sdk.eventskit;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import com.google.gson.internal.bind.util.ISO8601Utils;
import com.shopgun.android.sdk.eventskit.Event;
import java.lang.reflect.Type;
import java.util.Date;

public class LegacyEventSerializer
implements JsonSerializer<Event> {
    public static final String TAG = LegacyEventSerializer.class.getSimpleName();

    public JsonElement serialize(Event src, Type typeOfSrc, JsonSerializationContext context) {
        JsonObject jsonObject = new JsonObject();
        jsonObject.addProperty("version", src.getVersion());
        jsonObject.addProperty("id", src.getId());
        jsonObject.addProperty("type", src.getType());
        if (src.getRecordedAt() != null) {
            jsonObject.addProperty("recordedAt", ISO8601Utils.format((Date)src.getRecordedAt()));
        }
        if (src.getSentAt() != null) {
            jsonObject.addProperty("sentAt", ISO8601Utils.format((Date)src.getSentAt()));
        }
        if (src.getReceivedAt() != null) {
            jsonObject.addProperty("receivedAt", ISO8601Utils.format((Date)src.getReceivedAt()));
        }
        jsonObject.add("client", (JsonElement)src.getClient());
        jsonObject.add("context", (JsonElement)src.getContext());
        jsonObject.add("properties", (JsonElement)src.getProperties());
        return jsonObject;
    }
}

