/*
 * Decompiled with CFR 0.152.
 */
package com.shopgun.android.sdk.eventskit;

import android.os.Process;
import com.google.gson.ExclusionStrategy;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.shopgun.android.sdk.ShopGun;
import com.shopgun.android.sdk.corekit.gson.JsonNullExclusionStrategy;
import com.shopgun.android.sdk.corekit.gson.RealmObjectExclusionStrategy;
import com.shopgun.android.sdk.eventskit.Event;
import com.shopgun.android.sdk.eventskit.EventResponse;
import com.shopgun.android.sdk.eventskit.LegacyEventSerializer;
import com.shopgun.android.sdk.log.SgnLog;
import com.shopgun.android.sdk.utils.Constants;
import io.realm.Realm;
import io.realm.RealmConfiguration;
import io.realm.RealmQuery;
import io.realm.RealmResults;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import okhttp3.Call;
import okhttp3.Headers;
import okhttp3.HttpUrl;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;

public class LegacyEventDispatcher
extends Thread {
    public static final String TAG = Constants.getTag(LegacyEventDispatcher.class);
    private static final int DEF_EVENT_BATCH_SIZE = 100;
    private static final int DEF_MAX_RETRY_COUNT = 5;
    private final OkHttpClient mClient;
    private volatile boolean mQuit = true;
    private final int mEventBatchSize;
    private final int mMaxRetryCount;
    private Realm mRealm;
    private final HttpUrl mUrl;
    private final MediaType mMediatype;
    private final Headers mHeaders;
    private final Gson mGson;

    public LegacyEventDispatcher(OkHttpClient client, String url) {
        this(client, url, 100, 5);
    }

    private LegacyEventDispatcher(OkHttpClient client, String url, int eventBatchSize, int maxRetryCount) {
        this.mClient = client;
        this.mEventBatchSize = eventBatchSize;
        this.mMaxRetryCount = maxRetryCount;
        this.mUrl = HttpUrl.parse((String)url);
        this.mMediatype = MediaType.parse((String)"application/json");
        this.mHeaders = new Headers.Builder().add("Content-Type", "application/json").add("Accept", "application/json").build();
        this.mGson = this.getGson();
    }

    private Gson getGson() {
        try {
            Class<?> clazz = Class.forName("io.realm.com_shopgun_android_sdk_eventskit_EventRealmProxy");
            return new GsonBuilder().setExclusionStrategies(new ExclusionStrategy[]{new RealmObjectExclusionStrategy(), new JsonNullExclusionStrategy()}).registerTypeAdapter(clazz, (Object)new LegacyEventSerializer()).create();
        }
        catch (ClassNotFoundException e) {
            throw new IllegalStateException("Gson not instantiated due to missing RealmProxy class", e);
        }
    }

    public void quit() {
        this.mQuit = true;
    }

    @Override
    public synchronized void start() {
        if (this.mQuit) {
            this.mQuit = false;
            if (!this.isAlive()) {
                try {
                    super.start();
                }
                catch (IllegalThreadStateException illegalThreadStateException) {
                    // empty catch block
                }
            }
        }
    }

    @Override
    public void run() {
        Process.setThreadPriority((int)10);
        this.mRealm = ShopGun.getInstance().getLegacyRealmInstance();
        if (this.mRealm == null) {
            return;
        }
        int events_count = 1;
        while (!this.mQuit) {
            events_count = this.dispatchEventQueue();
        }
        this.mRealm.close();
        if (events_count == 0) {
            try {
                Realm.deleteRealm((RealmConfiguration)this.mRealm.getConfiguration());
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
        }
        this.interrupt();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int dispatchEventQueue() {
        int count = (int)this.mRealm.where(Event.class).count();
        if (count == 0) {
            this.quit();
        } else {
            Response response = null;
            try {
                List<Event> events = this.getEvents(this.mEventBatchSize);
                if (events.isEmpty()) {
                    this.quit();
                    count = 0;
                } else {
                    Call call = this.buildCallFromEvents(events);
                    response = call.execute();
                    if (response.isSuccessful()) {
                        String responseBody = response.body().string();
                        Gson gson = new GsonBuilder().create();
                        EventResponse resp = (EventResponse)gson.fromJson(responseBody, EventResponse.class);
                        this.mRealm.beginTransaction();
                        Set<String> removeIds = resp.getRemovableItems();
                        this.getEvents(removeIds).deleteAllFromRealm();
                        Set<String> nackIds = resp.getNackItems();
                        RealmResults<Event> nack = this.getEvents(nackIds);
                        for (Event e : nack) {
                            e.incrementRetryCount();
                        }
                        this.mRealm.where(Event.class).greaterThan("mRetryCount", this.mMaxRetryCount).findAll().deleteAllFromRealm();
                        this.mRealm.commitTransaction();
                        count = (int)this.mRealm.where(Event.class).count();
                        List<EventResponse.Item> errors = resp.getErrors();
                        SgnLog.v(TAG, events.size() + " events successfully shipped. " + resp.getAckItems().size() + " ack, " + nackIds.size() + " nack, " + errors.size() + " error.");
                        if (!errors.isEmpty()) {
                            for (EventResponse.Item i : resp.getErrors()) {
                                SgnLog.d(TAG, " - " + i.getErrors().toString());
                            }
                        }
                    } else {
                        SgnLog.d(TAG, response.toString() + ", " + response.body().string());
                    }
                }
            }
            catch (Exception e) {
                SgnLog.e(TAG, "Network failed", e);
            }
            finally {
                if (this.mRealm.isInTransaction()) {
                    this.mRealm.cancelTransaction();
                }
                if (response != null) {
                    response.close();
                }
            }
        }
        return count;
    }

    private List<Event> getEvents(int limit) {
        RealmResults events = this.mRealm.where(Event.class).findAll();
        ArrayList<Event> dispatchEvents = new ArrayList<Event>(100);
        for (int i = 0; i < Math.min(limit, events.size()); ++i) {
            dispatchEvents.add((Event)events.get(i));
        }
        return dispatchEvents;
    }

    private RealmResults<Event> getEvents(Set<String> ids) {
        RealmQuery query = this.mRealm.where(Event.class);
        boolean first = true;
        for (String id : ids) {
            if (!first) {
                query.or();
            }
            first = false;
            query = query.equalTo("mId", id);
        }
        return query.findAll();
    }

    private Call buildCallFromEvents(List<Event> events) {
        JsonElement eventArray = this.mGson.toJsonTree(events);
        JsonObject eventWrapper = new JsonObject();
        eventWrapper.add("events", eventArray);
        RequestBody body = RequestBody.create((MediaType)this.mMediatype, (String)eventWrapper.toString());
        Request request = new Request.Builder().url(this.mUrl).post(body).headers(this.mHeaders).build();
        return this.mClient.newCall(request);
    }
}

