/*
 * Decompiled with CFR 0.152.
 */
package com.shopgun.android.sdk.eventskit;

import android.content.Context;
import android.location.Location;
import android.util.Base64;
import com.fonfon.geohash.GeoHash;
import com.shopgun.android.sdk.ShopGun;
import com.shopgun.android.sdk.eventskit.AnonymousEvent;
import com.shopgun.android.sdk.utils.SgnUtils;
import com.shopgun.android.utils.LocationUtils;
import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;
import java.util.Arrays;
import java.util.concurrent.TimeUnit;

public class EventUtils {
    public static final String TAG = EventUtils.class.getSimpleName();
    public static final int GEO_HASH_PRECISION = 4;

    private EventUtils() {
    }

    public static String generateViewToken(byte[] data, String salt) {
        try {
            byte[] id = salt.getBytes("UTF-8");
            byte[] payload = new byte[data.length + id.length];
            System.arraycopy(id, 0, payload, 0, id.length);
            System.arraycopy(data, 0, payload, id.length, data.length);
            MessageDigest digest = MessageDigest.getInstance("MD5");
            digest.update(payload);
            byte[] digest_result = digest.digest();
            byte[] md5 = Arrays.copyOfRange(digest_result, 0, 8);
            return Base64.encodeToString((byte[])md5, (int)2);
        }
        catch (Exception e) {
            e.printStackTrace();
            return "";
        }
    }

    public static void addLocationInformation(Context context, AnonymousEvent event) {
        if (!ShopGun.getInstance().getSettings().isLocationEnabled()) {
            return;
        }
        Location location = LocationUtils.getLastKnownLocation((Context)context);
        if (location != null && location.getAccuracy() < 2000.0f) {
            GeoHash geoHash = GeoHash.fromLocation((Location)location, (int)4);
            event.addUserLocation(geoHash.toString(), TimeUnit.MILLISECONDS.toSeconds(location.getTime()));
        }
    }

    public static byte[] getDataBytes(String ppid, int pageNumber) {
        byte[] ppidBytes;
        byte[] pageBytes = SgnUtils.intToByteArray(pageNumber);
        try {
            ppidBytes = ppid.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            ppidBytes = ppid.getBytes();
        }
        byte[] data = new byte[ppidBytes.length + pageBytes.length];
        System.arraycopy(ppidBytes, 0, data, 0, ppidBytes.length);
        System.arraycopy(pageBytes, 0, data, ppidBytes.length, pageBytes.length);
        return data;
    }
}

