/*
 * Decompiled with CFR 0.152.
 */
package com.shopgun.android.sdk.eventskit;

import android.content.Context;
import android.os.Bundle;
import com.shopgun.android.sdk.ShopGun;
import com.shopgun.android.sdk.eventskit.AnonymousEvent;
import com.shopgun.android.sdk.eventskit.EventManager;
import com.shopgun.android.sdk.eventskit.EventTrackerImpl;
import com.shopgun.android.sdk.eventskit.EventTrackerNoOp;
import com.shopgun.android.sdk.log.SgnLog;
import com.shopgun.android.utils.PackageUtils;
import com.shopgun.android.utils.TextUtils;

public abstract class EventTracker {
    public static final String TAG = EventTracker.class.getSimpleName();
    public static final String META_APPLICATION_TRACK_ID = "com.shopgun.android.sdk.eventskit.application_track_id";
    public static final String META_APPLICATION_TRACK_ID_DEBUG = "com.shopgun.android.sdk.develop.eventskit.application_track_id";
    private static EventTracker mGlobalInstance;
    private String applicationTrackId;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static EventTracker globalTracker() {
        if (mGlobalInstance != null) return mGlobalInstance;
        Class<EventTracker> clazz = EventTracker.class;
        synchronized (EventTracker.class) {
            if (mGlobalInstance != null) return mGlobalInstance;
            Context c = ShopGun.getInstance().getContext();
            Bundle b = PackageUtils.getMetaData((Context)c);
            String appTrackId = b.getString(ShopGun.getInstance().isDevelop() && b.containsKey(META_APPLICATION_TRACK_ID_DEBUG) ? META_APPLICATION_TRACK_ID_DEBUG : META_APPLICATION_TRACK_ID);
            if (TextUtils.isEmpty((CharSequence)appTrackId)) {
                SgnLog.w(TAG, "Application track id not found");
                mGlobalInstance = new EventTrackerNoOp();
            } else {
                mGlobalInstance = new EventTrackerImpl();
                mGlobalInstance.setApplicationTrackId(appTrackId);
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return mGlobalInstance;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setGlobalTracker(EventTracker tracker) {
        Class<EventTracker> clazz = EventTracker.class;
        synchronized (EventTracker.class) {
            mGlobalInstance = tracker;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    String getApplicationTrackId() {
        return this.applicationTrackId;
    }

    void setApplicationTrackId(String applicationTrackId) {
        this.applicationTrackId = applicationTrackId;
    }

    public void track(int type) {
        AnonymousEvent event = new AnonymousEvent(type);
        this.track(event);
    }

    public void flush() {
        EventManager.getInstance().flush();
    }

    public abstract void track(AnonymousEvent var1);
}

