/*
 * Decompiled with CFR 0.152.
 */
package com.shopgun.android.sdk.eventskit;

import android.app.Activity;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import com.shopgun.android.sdk.ShopGun;
import com.shopgun.android.sdk.corekit.LifecycleManager;
import com.shopgun.android.sdk.eventskit.AnonymousEvent;
import com.shopgun.android.sdk.eventskit.EventDispatcher;
import com.shopgun.android.sdk.eventskit.EventListener;
import com.shopgun.android.sdk.eventskit.LegacyEventDispatcher;
import com.shopgun.android.sdk.log.SgnLog;
import com.shopgun.android.sdk.utils.Constants;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;

public class EventManager {
    public static final String TAG = Constants.getTag(EventManager.class);
    private static final int DISPATCH_MSG = 5738629;
    private static final long DISPATCH_INTERVAL = TimeUnit.SECONDS.toMillis(120L);
    public static final int MAX_QUEUE_SIZE = 1024;
    private static EventManager mInstance;
    private static final Handler mHandler;
    private static BlockingQueue<AnonymousEvent> mEventQueue;
    private EventDispatcher mEventDispatcher;
    private LegacyEventDispatcher mLegacyEventDispatcher;
    private long mDispatchInterval = DISPATCH_INTERVAL;
    private final List<EventListener> mEventListeners = new ArrayList<EventListener>();
    private String mCountryCode;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static EventManager getInstance() {
        if (mInstance != null) return mInstance;
        Class<EventManager> clazz = EventManager.class;
        synchronized (EventManager.class) {
            if (mInstance != null) return mInstance;
            mInstance = new EventManager(ShopGun.getInstance());
            // ** MonitorExit[var0] (shouldn't be in output)
            return mInstance;
        }
    }

    private EventManager(ShopGun shopGun) {
        mEventQueue = new LinkedBlockingQueue<AnonymousEvent>(1024);
        this.mEventDispatcher = new EventDispatcher(mEventQueue, shopGun.getClient(), shopGun.getEventEnvironment());
        this.mCountryCode = "";
        this.checkLegacyEvents(shopGun);
        EventLifecycle lifecycleCallback = new EventLifecycle();
        shopGun.getLifecycleManager().registerCallback(lifecycleCallback);
        if (shopGun.getLifecycleManager().isActive()) {
            lifecycleCallback.onCreate(shopGun.getLifecycleManager().getActivity());
        }
    }

    private void checkLegacyEvents(ShopGun shopGun) {
        this.mLegacyEventDispatcher = null;
        if (shopGun.legacyEventsDetected()) {
            this.mLegacyEventDispatcher = new LegacyEventDispatcher(shopGun.getClient(), shopGun.getLegacyEventEnvironment());
        }
    }

    public void addEvent(AnonymousEvent event) {
        boolean isActive;
        event.addUserCountry(this.mCountryCode);
        if (!event.doNotTrack()) {
            SgnLog.d(TAG, "Adding tracked event: " + event.toString());
        }
        if (!(isActive = ShopGun.getInstance().getLifecycleManager().isActive())) {
            this.mEventDispatcher.start();
        }
        if (mEventQueue.remainingCapacity() > 0) {
            this.dispatchOnEvent(event);
            mEventQueue.add(event);
        }
        if (!isActive) {
            this.mEventDispatcher.quit();
        }
    }

    public void setUserCountry(String userCountry) {
        if (userCountry != null && userCountry.length() == 2) {
            this.mCountryCode = userCountry.toUpperCase(Locale.ENGLISH);
        }
    }

    private void resetTimer() {
        mHandler.removeMessages(5738629);
        mHandler.sendEmptyMessageDelayed(5738629, this.mDispatchInterval);
    }

    public void flush() {
        this.resetTimer();
        this.mEventDispatcher.flush();
    }

    private void startDispatcher() {
        if (this.mEventDispatcher == null || this.mEventDispatcher.getState() == Thread.State.TERMINATED) {
            ShopGun sgn = ShopGun.getInstance();
            this.mEventDispatcher = new EventDispatcher(mEventQueue, sgn.getClient(), sgn.getEventEnvironment());
        }
        this.mEventDispatcher.start();
        if (this.mLegacyEventDispatcher != null) {
            this.mLegacyEventDispatcher.start();
        }
        mHandler.sendEmptyMessageDelayed(5738629, this.mDispatchInterval);
    }

    public void addEventListener(EventListener tracker) {
        this.mEventListeners.add(tracker);
    }

    public void removeEventListener(EventListener tracker) {
        this.mEventListeners.remove(tracker);
    }

    public void removeAllEventListeners() {
        this.mEventListeners.clear();
    }

    private void dispatchOnEvent(AnonymousEvent event) {
        for (EventListener tracker : this.mEventListeners) {
            tracker.onEvent(event);
        }
    }

    static {
        mHandler = new Handler(Looper.getMainLooper()){

            public void handleMessage(Message msg) {
                switch (msg.what) {
                    case 5738629: {
                        mInstance.flush();
                    }
                }
            }
        };
    }

    private class EventLifecycle
    extends LifecycleManager.SimpleCallback {
        private EventLifecycle() {
        }

        @Override
        public void onCreate(Activity activity) {
            EventManager.this.startDispatcher();
        }

        @Override
        public void onDestroy(Activity activity) {
            mHandler.removeMessages(5738629);
            EventManager.this.mEventDispatcher.quit();
            if (EventManager.this.mLegacyEventDispatcher != null) {
                EventManager.this.mLegacyEventDispatcher.quit();
            }
        }
    }
}

