/*
 * Decompiled with CFR 0.152.
 */
package com.shopgun.android.sdk.eventskit;

import android.os.Process;
import com.google.gson.ExclusionStrategy;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.shopgun.android.sdk.ShopGun;
import com.shopgun.android.sdk.corekit.gson.JsonNullExclusionStrategy;
import com.shopgun.android.sdk.corekit.gson.RealmObjectExclusionStrategy;
import com.shopgun.android.sdk.eventskit.AnonymousEvent;
import com.shopgun.android.sdk.eventskit.AnonymousEventSerializer;
import com.shopgun.android.sdk.eventskit.AnonymousEventWrapper;
import com.shopgun.android.sdk.eventskit.EventResponse;
import com.shopgun.android.sdk.log.SgnLog;
import com.shopgun.android.sdk.utils.Constants;
import io.realm.Realm;
import io.realm.RealmModel;
import io.realm.RealmQuery;
import io.realm.RealmResults;
import io.realm.exceptions.RealmPrimaryKeyConstraintException;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.TimeUnit;
import okhttp3.Call;
import okhttp3.Headers;
import okhttp3.HttpUrl;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;

public class EventDispatcher
extends Thread {
    public static final String TAG = Constants.getTag(EventDispatcher.class);
    private static final int FLUSH_EVENT_TYPE = 11111;
    private static final int DEFAULT_EVENT_BATCH_SIZE = 100;
    private static final int EVENT_MAX_AGE = 7;
    private final BlockingQueue<AnonymousEvent> mQueue;
    private final OkHttpClient mClient;
    private volatile boolean mQuit = true;
    private final int mEventBatchSize;
    private final AnonymousEvent mFlushEvent;
    private final HttpUrl mUrl;
    private final MediaType mMediatype;
    private final Headers mHeaders;
    private Realm mRealm;
    private final Gson mGson;

    public EventDispatcher(BlockingQueue<AnonymousEvent> queue, OkHttpClient client, String url) {
        this(queue, client, url, 100);
    }

    public EventDispatcher(BlockingQueue<AnonymousEvent> queue, OkHttpClient client, String url, int eventBatchSize) {
        this.mQueue = queue;
        this.mClient = client;
        this.mEventBatchSize = eventBatchSize;
        this.mFlushEvent = new AnonymousEvent(11111).add("custom event", "flush event").doNotTrack(true);
        this.mUrl = HttpUrl.parse((String)url);
        this.mMediatype = MediaType.parse((String)"application/json");
        this.mHeaders = new Headers.Builder().add("Content-Type", "application/json").add("Accept", "application/json").build();
        this.mGson = this.getGson();
    }

    private Gson getGson() {
        try {
            Class<?> clazz = Class.forName("io.realm.com_shopgun_android_sdk_eventskit_AnonymousEventWrapperRealmProxy");
            return new GsonBuilder().setExclusionStrategies(new ExclusionStrategy[]{new RealmObjectExclusionStrategy(), new JsonNullExclusionStrategy()}).registerTypeAdapter(clazz, (Object)new AnonymousEventSerializer()).create();
        }
        catch (ClassNotFoundException e) {
            throw new IllegalStateException("Gson not instantiated due to missing RealmProxy class", e);
        }
    }

    public void quit() {
        this.flush();
        this.mQuit = true;
    }

    @Override
    public synchronized void start() {
        if (this.mQuit) {
            this.mQuit = false;
            if (!this.isAlive()) {
                try {
                    super.start();
                }
                catch (IllegalThreadStateException illegalThreadStateException) {
                    // empty catch block
                }
            }
            this.flush();
        }
    }

    @Override
    public void run() {
        Process.setThreadPriority((int)10);
        this.mRealm = ShopGun.getInstance().getRealmInstance();
        if (this.mRealm == null) {
            return;
        }
        while (!this.mQuit || !this.mQueue.isEmpty()) {
            AnonymousEvent event;
            try {
                event = this.mQueue.take();
            }
            catch (InterruptedException e) {
                continue;
            }
            if (event.doNotTrack()) {
                SgnLog.v(TAG, event.toString());
            } else {
                AnonymousEventWrapper wrappedEvent = new AnonymousEventWrapper(event.getId(), event.getVersion(), event.getTimestamp(), event.toString());
                this.mRealm.executeTransaction((Realm.Transaction)new InsertTransaction(wrappedEvent));
            }
            boolean flush = event.getType() == 11111;
            this.dispatchEventQueue(flush);
        }
        this.mRealm.close();
        this.interrupt();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dispatchEventQueue(boolean force) {
        if (!force && !ShopGun.getInstance().getLifecycleManager().isActive()) {
            return;
        }
        int count = (int)this.mRealm.where(AnonymousEventWrapper.class).count();
        if (!force && count < this.mEventBatchSize) {
            return;
        }
        Response response = null;
        try {
            List<AnonymousEventWrapper> events = this.getEvents(this.mEventBatchSize);
            if (events.isEmpty()) {
                return;
            }
            Call call = this.buildCallFromEvents(events);
            response = call.execute();
            if (response.isSuccessful()) {
                String responseBody = response.body().string();
                Gson gson = new GsonBuilder().create();
                EventResponse resp = (EventResponse)gson.fromJson(responseBody, EventResponse.class);
                this.mRealm.beginTransaction();
                Set<String> removeIds = resp.getRemovableItems();
                this.getEvents(removeIds).deleteAllFromRealm();
                Set<String> nackIds = resp.getNackItems();
                this.getOldEvents(nackIds).deleteAllFromRealm();
                this.mRealm.commitTransaction();
                List<EventResponse.Item> errors = resp.getErrors();
                SgnLog.d(TAG, events.size() + " events successfully shipped. " + resp.getAckItems().size() + " ack, " + nackIds.size() + " nack, " + errors.size() + " error.");
                if (!errors.isEmpty()) {
                    for (EventResponse.Item i : resp.getErrors()) {
                        SgnLog.d(TAG, " - " + i.getErrors().toString());
                    }
                }
            } else {
                SgnLog.d(TAG, response.toString() + ", " + response.body().string());
            }
        }
        catch (Exception e) {
            SgnLog.e(TAG, "Network failed", e);
        }
        finally {
            if (this.mRealm.isInTransaction()) {
                this.mRealm.cancelTransaction();
            }
            if (response != null) {
                response.close();
            }
        }
    }

    private RealmResults<AnonymousEventWrapper> getOldEvents(Set<String> ids) {
        long timeLimit = TimeUnit.MILLISECONDS.toSeconds(System.currentTimeMillis()) - TimeUnit.DAYS.toSeconds(7L);
        RealmQuery query = this.mRealm.where(AnonymousEventWrapper.class);
        query.beginGroup();
        boolean first = true;
        for (String id : ids) {
            if (!first) {
                query.or();
            }
            first = false;
            query = query.equalTo("id", id);
        }
        query.endGroup();
        query.and().lessThan("timestamp", timeLimit);
        return query.findAll();
    }

    private List<AnonymousEventWrapper> getEvents(int limit) {
        RealmResults events = this.mRealm.where(AnonymousEventWrapper.class).findAll();
        ArrayList<AnonymousEventWrapper> dispatchEvents = new ArrayList<AnonymousEventWrapper>(100);
        for (int i = 0; i < Math.min(limit, events.size()); ++i) {
            dispatchEvents.add((AnonymousEventWrapper)events.get(i));
        }
        return dispatchEvents;
    }

    private RealmResults<AnonymousEventWrapper> getEvents(Set<String> ids) {
        RealmQuery query = this.mRealm.where(AnonymousEventWrapper.class);
        boolean first = true;
        for (String id : ids) {
            if (!first) {
                query.or();
            }
            first = false;
            query = query.equalTo("id", id);
        }
        return query.findAll();
    }

    public void flush() {
        if (this.mQueue.remainingCapacity() > 0) {
            this.mQueue.add(this.mFlushEvent);
        }
    }

    private Call buildCallFromEvents(List<AnonymousEventWrapper> events) {
        JsonElement eventArray = this.mGson.toJsonTree(events);
        JsonObject eventWrapper = new JsonObject();
        eventWrapper.add("events", eventArray);
        RequestBody body = RequestBody.create((MediaType)this.mMediatype, (String)eventWrapper.toString());
        Request request = new Request.Builder().url(this.mUrl).post(body).headers(this.mHeaders).build();
        return this.mClient.newCall(request);
    }

    private static class InsertTransaction
    implements Realm.Transaction {
        AnonymousEventWrapper mEvent;

        InsertTransaction(AnonymousEventWrapper event) {
            this.mEvent = event;
        }

        public void execute(Realm realm) {
            try {
                realm.insert((RealmModel)this.mEvent);
            }
            catch (RealmPrimaryKeyConstraintException e) {
                throw new IllegalStateException("Realm duplicate key on event: " + this.mEvent.toString(), e);
            }
        }
    }
}

