/*
 * Decompiled with CFR 0.152.
 */
package com.shopgun.android.sdk.eventskit;

import com.google.gson.JsonObject;
import com.shopgun.android.sdk.eventskit.EventTracker;
import com.shopgun.android.sdk.utils.SgnUtils;
import com.shopgun.android.utils.TextUtils;
import java.util.concurrent.TimeUnit;

public class AnonymousEvent {
    public static final String TAG = AnonymousEvent.class.getSimpleName();
    private static final int VERSION = 2;
    public static final int DEFAULT_TYPE = 0;
    public static final int PAGED_PUBLICATION_OPENED = 1;
    public static final int PAGED_PUBLICATION_PAGE_DISAPPEARED = 2;
    public static final int OFFER_OPENED = 3;
    public static final int CLIENT_SESSION_OPENED = 4;
    public static final int SEARCHED = 5;
    private boolean mDoNotTrack;
    private JsonObject json_event;
    private int type;
    private String id = SgnUtils.createUUID();
    private long timestamp = this.timestamp();

    public AnonymousEvent(int type) {
        this.type = type;
        this.json_event = new JsonObject();
        this.json_event.addProperty("_v", (Number)2);
        this.json_event.addProperty("_i", this.id);
        this.json_event.addProperty("_e", (Number)type);
        this.json_event.addProperty("_t", (Number)this.timestamp);
    }

    private long timestamp() {
        return TimeUnit.MILLISECONDS.toSeconds(System.currentTimeMillis());
    }

    public AnonymousEvent add(String property, String value) {
        if (property != null) {
            this.json_event.addProperty(property, value);
        }
        return this;
    }

    protected AnonymousEvent setApplicationTrackId(String applicationTrackId) {
        if (!TextUtils.isEmpty((CharSequence)applicationTrackId)) {
            this.json_event.addProperty("_a", applicationTrackId);
        }
        return this;
    }

    public AnonymousEvent addUserLocation(String geohash, long timestamp) {
        if (!TextUtils.isEmpty((CharSequence)geohash) && timestamp > 0L) {
            this.json_event.addProperty("l.h", geohash);
            this.json_event.addProperty("l.ht", (Number)timestamp);
        }
        return this;
    }

    public AnonymousEvent addUserCountry(String countryCode) {
        if (!TextUtils.isEmpty((CharSequence)countryCode)) {
            this.json_event.addProperty("l.c", countryCode);
        }
        return this;
    }

    public AnonymousEvent addViewToken(String viewToken) {
        if (!TextUtils.isEmpty((CharSequence)viewToken)) {
            this.json_event.addProperty("vt", viewToken);
        }
        return this;
    }

    public AnonymousEvent addPublicationOpened(String publicationId) {
        if (!TextUtils.isEmpty((CharSequence)publicationId)) {
            this.json_event.addProperty("pp.id", publicationId);
        }
        return this;
    }

    public AnonymousEvent addPageOpened(String publicationId, int page) {
        if (!TextUtils.isEmpty((CharSequence)publicationId) && page > 0) {
            this.addPublicationOpened(publicationId);
            this.json_event.addProperty("ppp.n", (Number)page);
        }
        return this;
    }

    public AnonymousEvent addOfferOpened(String offerId) {
        if (!TextUtils.isEmpty((CharSequence)offerId)) {
            this.json_event.addProperty("of.id", offerId);
        }
        return this;
    }

    public AnonymousEvent addSearch(String query, String language) {
        if (!TextUtils.isEmpty((CharSequence)query)) {
            this.json_event.addProperty("sea.q", query);
        }
        if (!TextUtils.isEmpty((CharSequence)language)) {
            this.json_event.addProperty("sea.l", language);
        }
        return this;
    }

    public boolean doNotTrack() {
        return this.mDoNotTrack;
    }

    public AnonymousEvent doNotTrack(boolean doNotTrack) {
        this.mDoNotTrack = doNotTrack;
        return this;
    }

    public void track() {
        EventTracker.globalTracker().track(this);
    }

    public String toString() {
        return this.json_event.toString();
    }

    public int getType() {
        return this.type;
    }

    public String getType(int type) {
        switch (type) {
            case 0: {
                return "default_type";
            }
            case 1: {
                return "paged_publication_opened";
            }
            case 2: {
                return "paged_publication_page_disappeared";
            }
            case 3: {
                return "offer_opened";
            }
            case 4: {
                return "client_session_opened";
            }
            case 5: {
                return "searched";
            }
        }
        return "custom_event";
    }

    public String getId() {
        return this.id;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public int getVersion() {
        return 2;
    }
}

