/*
 * Decompiled with CFR 0.152.
 */
package com.shopgun.android.sdk.database;

import android.content.ContentValues;
import android.content.Context;
import android.database.Cursor;
import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteStatement;
import com.shopgun.android.sdk.database.DbUtils;
import com.shopgun.android.sdk.database.SgnOpenHelper;
import com.shopgun.android.sdk.model.Share;
import com.shopgun.android.sdk.utils.Constants;
import java.util.ArrayList;
import java.util.List;

@Deprecated
public class ShareSQLiteHelper
extends SgnOpenHelper {
    public static final String TAG = Constants.getTag(ShareSQLiteHelper.class);
    public static final String TABLE = "shares";
    public static final String CREATE_TABLE = "create table if not exists shares(id integer not null primary key, shopping_list_id text not null, user integer not null, email text, name text, accepted text, access text, accept_url text, state integer );";
    public static final String INSERT_STATEMENT = "INSERT OR REPLACE INTO shares VALUES (?,?,?,?,?,?,?,?,?)";

    public ShareSQLiteHelper(Context context) {
        super(context);
    }

    public static void create(SQLiteDatabase db) {
        db.acquireReference();
        db.execSQL(CREATE_TABLE);
        db.releaseReference();
    }

    public static void upgrade(SQLiteDatabase db, int oldVersion, int newVersion) {
        db.acquireReference();
        db.execSQL("DROP TABLE IF EXISTS shares");
        db.releaseReference();
    }

    public static SQLiteStatement getInsertStatement(SQLiteDatabase db) {
        return db.compileStatement(INSERT_STATEMENT);
    }

    public static void bind(SQLiteStatement s, Share share, String userId) {
        DbUtils.bindOrNull(s, 2, share.getShoppinglistId());
        DbUtils.bindOrNull(s, 3, userId);
        DbUtils.bindOrNull(s, 4, share.getEmail());
        DbUtils.bindOrNull(s, 5, share.getName());
        s.bindLong(6, (long)DbUtils.unescape(share.getAccepted()));
        DbUtils.bindOrNull(s, 7, share.getAccess());
        DbUtils.bindOrNull(s, 8, share.getAcceptUrl());
        s.bindLong(9, (long)share.getState());
    }

    public static List<Share> cursorToList(Cursor c, String shoppinglistId) {
        ArrayList<Share> list = new ArrayList<Share>();
        for (ContentValues cv : DbUtils.cursorToContentValues(c)) {
            Share s = ShareSQLiteHelper.contentValuesToObject(cv, shoppinglistId);
            if (s == null) continue;
            list.add(s);
        }
        return list;
    }

    public static Share contentValuesToObject(ContentValues cv, String shoppinglistId) {
        String email = cv.getAsString("email");
        String acceptUrl = cv.getAsString("accept_url");
        String access = cv.getAsString("access");
        Share s = new Share(email, access, acceptUrl);
        s.setShoppinglistId(shoppinglistId);
        s.setName(cv.getAsString("name"));
        s.setAccepted(0 < cv.getAsInteger("accepted"));
        s.setState(cv.getAsInteger("state"));
        return s;
    }

    public static ContentValues objectToContentValues(Share s, String userId) {
        ContentValues cv = new ContentValues();
        cv.put("shopping_list_id", s.getShoppinglistId());
        cv.put("user", userId);
        cv.put("email", s.getEmail());
        cv.put("name", s.getName());
        cv.put("accepted", Boolean.valueOf(s.getAccepted()));
        cv.put("access", s.getAccess());
        cv.put("accept_url", s.getAcceptUrl());
        cv.put("state", Integer.valueOf(s.getState()));
        return cv;
    }
}

