/*
 * Decompiled with CFR 0.152.
 */
package com.shopgun.android.sdk.database;

import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteOpenHelper;
import com.shopgun.android.sdk.log.SgnLog;
import com.shopgun.android.sdk.utils.Constants;
import java.util.concurrent.atomic.AtomicInteger;

public class SQLDataSource {
    public static final String TAG = Constants.getTag(SQLDataSource.class);
    private final Object LOCK = new Object();
    private SQLiteOpenHelper mHelper;
    private SQLiteDatabase mDatabase;
    private AtomicInteger mRefCount = new AtomicInteger();
    private boolean mOpen = false;

    public SQLDataSource(SQLiteOpenHelper sqLiteHelper) {
        this.mHelper = sqLiteHelper;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void open() {
        Object object = this.LOCK;
        synchronized (object) {
            if (!this.mOpen) {
                this.acquireDb();
            }
            this.mOpen = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        Object object = this.LOCK;
        synchronized (object) {
            if (this.mOpen) {
                this.releaseDb();
            }
            this.mOpen = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isOpen() {
        Object object = this.LOCK;
        synchronized (object) {
            return this.mRefCount.get() > 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized SQLiteDatabase acquireDb() {
        Object object = this.LOCK;
        synchronized (object) {
            if (this.mDatabase == null || !this.mDatabase.isOpen()) {
                this.mDatabase = this.mHelper.getWritableDatabase();
                this.mRefCount.set(0);
            }
            this.mDatabase.acquireReference();
            this.mRefCount.incrementAndGet();
            return this.mDatabase;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized void releaseDb() {
        Object object = this.LOCK;
        synchronized (object) {
            this.mDatabase.releaseReference();
            if (this.mRefCount.decrementAndGet() == 0) {
                this.mHelper.close();
            }
        }
    }

    protected void logRef(String action) {
        SgnLog.d(TAG, String.format("Thread: %s, Action: %s, RefCount: %s", Thread.currentThread().getName(), action, this.mRefCount.get()));
    }

    public void log(String tag, Exception e) {
        SgnLog.e(tag, e.getMessage(), e);
    }
}

