/*
 * Decompiled with CFR 0.152.
 */
package com.shopgun.android.sdk.api;

public enum Environment {
    PRODUCTION,
    EDGE,
    STAGING,
    CUSTOM;

    public static final String HOST_POSTFIX = "etilbudsavis.dk";
    private String mEnvironment;

    public static void setCustom(String env) {
        Environment.CUSTOM.mEnvironment = env == null || env.isEmpty() ? Environment.PRODUCTION.mEnvironment : env;
    }

    public static Environment fromString(String env) {
        if (env != null) {
            for (Environment e : Environment.values()) {
                if (!env.equalsIgnoreCase(e.mEnvironment)) continue;
                return e;
            }
        }
        Environment.setCustom(env);
        return CUSTOM;
    }

    public String toString() {
        return this.mEnvironment;
    }

    public String apply(String path) {
        if (path == null || path.isEmpty()) {
            return this.mEnvironment;
        }
        if (path.startsWith("http://") || path.startsWith("https://")) {
            return path;
        }
        if (!path.startsWith("/")) {
            path = "/" + path;
        }
        return this.mEnvironment + path;
    }

    static {
        Environment.PRODUCTION.mEnvironment = "https://api.etilbudsavis.dk";
        Environment.EDGE.mEnvironment = "https://api-edge.etilbudsavis.dk";
        Environment.STAGING.mEnvironment = "https://api-staging.etilbudsavis.dk";
        Environment.CUSTOM.mEnvironment = "https://api.etilbudsavis.dk";
    }
}

