/*
 * Decompiled with CFR 0.152.
 */
package com.shopgun.android.sdk;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.app.Application;
import android.content.Context;
import android.content.res.Configuration;
import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import com.apollographql.apollo.ApolloClient;
import com.shopgun.android.sdk.SessionManager;
import com.shopgun.android.sdk.Settings;
import com.shopgun.android.sdk.SgnLocation;
import com.shopgun.android.sdk.api.Environment;
import com.shopgun.android.sdk.api.ThemeEnvironment;
import com.shopgun.android.sdk.corekit.LifecycleManager;
import com.shopgun.android.sdk.corekit.UserAgentInterceptor;
import com.shopgun.android.sdk.corekit.realm.SgnAnonymousEventRealmModule;
import com.shopgun.android.sdk.corekit.realm.SgnLegacyEventRealmModule;
import com.shopgun.android.sdk.database.SgnDatabase;
import com.shopgun.android.sdk.eventskit.AnonymousEvent;
import com.shopgun.android.sdk.eventskit.EventUtils;
import com.shopgun.android.sdk.log.SgnLog;
import com.shopgun.android.sdk.network.Cache;
import com.shopgun.android.sdk.network.Network;
import com.shopgun.android.sdk.network.Request;
import com.shopgun.android.sdk.network.RequestQueue;
import com.shopgun.android.sdk.network.impl.DefaultRedirectProtocol;
import com.shopgun.android.sdk.network.impl.HttpURLNetwork;
import com.shopgun.android.sdk.network.impl.MemoryCache;
import com.shopgun.android.sdk.network.impl.NetworkImpl;
import com.shopgun.android.sdk.shoppinglists.ListManager;
import com.shopgun.android.sdk.shoppinglists.SyncManager;
import com.shopgun.android.sdk.utils.Constants;
import com.shopgun.android.sdk.utils.SgnThreadFactory;
import com.shopgun.android.sdk.utils.SgnUserAgent;
import com.shopgun.android.sdk.utils.SgnUtils;
import com.shopgun.android.sdk.utils.Version;
import com.shopgun.android.utils.PackageUtils;
import io.realm.Realm;
import io.realm.RealmConfiguration;
import io.realm.exceptions.RealmFileException;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import okhttp3.Interceptor;
import okhttp3.OkHttpClient;

public class ShopGun {
    public static final String TAG = Constants.getTag(ShopGun.class);
    public static final Version VERSION = new Version(4, 0, 0, "dev");
    @SuppressLint(value={"StaticFieldLeak"})
    private static ShopGun mSingleton;
    private Context mContext;
    private LifecycleManager mLifecycleManager;
    private final Handler mHandler = new Handler(Looper.getMainLooper());
    private final ExecutorService mExecutor;
    private boolean mDevelop = false;
    private Environment mEnvironment;
    private ThemeEnvironment mThemeEnvironment;
    private String mEventEnvironment;
    private OkHttpClient mClient;
    private String mSessionId;
    private String mDeviceId;
    private ApolloClient mApolloClient;
    private final Settings mSettings;
    private final SessionManager mSessionManager;
    private final SgnLocation mLocation;
    private final ListManager mListManager;
    private final SyncManager mSyncManager;
    private final RequestQueue mRequestQueue;
    private final RealmConfiguration mRealmConfiguration;
    private final RealmConfiguration mLegacyConfiguration;
    private SgnLifecycleCallback mLifecycleCallback;
    private static List<OnInstanceCreationListener> mOnInstanceCreationListeners;

    private ShopGun(Builder builder) {
        this.mContext = builder.application.getApplicationContext();
        this.mDevelop = builder.develop;
        this.mEnvironment = builder.environment;
        this.mThemeEnvironment = builder.themeEnvironment;
        this.mEventEnvironment = builder.eventEnvironment;
        this.mExecutor = builder.executorService;
        this.mClient = builder.okHttpClient;
        this.mRealmConfiguration = builder.realmConfiguration;
        this.mApolloClient = builder.apolloClient;
        this.mLegacyConfiguration = builder.legacyConfiguration;
        this.mLifecycleManager = new LifecycleManager(builder.application);
        this.mLifecycleCallback = new SgnLifecycleCallback();
        this.mLifecycleManager.registerCallback(this.mLifecycleCallback);
        this.mSettings = new Settings(this.mContext);
        this.mDeviceId = this.mSettings.getClientId();
        this.mSessionId = this.mSettings.getSessionId();
        this.mRequestQueue = new RequestQueue(this, builder.cache, builder.network);
        this.mRequestQueue.start();
        this.mLocation = this.mSettings.getLocation();
        this.mSessionManager = new SessionManager(this);
        SgnDatabase db = SgnDatabase.getInstance(this);
        this.mListManager = new ListManager(this, db);
        this.mSyncManager = new SyncManager(this, db);
    }

    public static ShopGun getInstance() {
        if (mSingleton == null) {
            throw new IllegalStateException("No ShopGun instance found, see ShopGun.Builder.");
        }
        return mSingleton;
    }

    public static boolean isInstantiated() {
        return mSingleton != null;
    }

    public OkHttpClient getClient() {
        return this.mClient;
    }

    public ApolloClient getApolloClient() {
        return this.mApolloClient;
    }

    public LifecycleManager getLifecycleManager() {
        return this.mLifecycleManager;
    }

    public ExecutorService getExecutor() {
        return this.mExecutor;
    }

    public Context getContext() {
        return this.mContext;
    }

    public synchronized String getApiKey() {
        Bundle b = PackageUtils.getMetaData((Context)this.mContext);
        if (this.isDevelop() && b.containsKey("com.shopgun.android.sdk.develop.api_key")) {
            return b.getString("com.shopgun.android.sdk.develop.api_key");
        }
        return b.getString("com.shopgun.android.sdk.api_key");
    }

    public synchronized String getApiSecret() {
        Bundle b = PackageUtils.getMetaData((Context)this.mContext);
        if (this.isDevelop() && b.containsKey("com.shopgun.android.sdk.develop.api_secret")) {
            return b.getString("com.shopgun.android.sdk.develop.api_secret");
        }
        return b.getString("com.shopgun.android.sdk.api_secret");
    }

    public Environment getEnvironment() {
        return this.mEnvironment;
    }

    public ThemeEnvironment getThemeEnvironment() {
        return this.mThemeEnvironment;
    }

    public String getEventEnvironment() {
        return this.mEventEnvironment;
    }

    public String getLegacyEventEnvironment() {
        return "https://events.service.shopgun.com/track";
    }

    public Request<?> add(Request<?> request) {
        return this.mRequestQueue.add(request);
    }

    public RequestQueue getRequestQueue() {
        return this.mRequestQueue;
    }

    public SessionManager getSessionManager() {
        return this.mSessionManager;
    }

    public Settings getSettings() {
        return this.mSettings;
    }

    public SgnLocation getLocation() {
        return this.mLocation;
    }

    @Deprecated
    public ListManager getListManager() {
        return this.mListManager;
    }

    @Deprecated
    public SyncManager getSyncManager() {
        return this.mSyncManager;
    }

    public Handler getHandler() {
        return this.mHandler;
    }

    public boolean isDevelop() {
        return this.mDevelop;
    }

    public void clear() {
        if (!this.mLifecycleManager.isActive()) {
            this.mSessionManager.invalidate();
            this.mSettings.clear();
            this.mLocation.clear();
            this.mRequestQueue.clear();
            this.mListManager.clear();
        }
    }

    public Realm getRealmInstance() {
        Realm realm;
        try {
            realm = Realm.getInstance((RealmConfiguration)this.mRealmConfiguration);
        }
        catch (RealmFileException | IllegalArgumentException ignore) {
            return null;
        }
        return realm;
    }

    public boolean legacyEventsDetected() {
        return this.mLegacyConfiguration != null;
    }

    public Realm getLegacyRealmInstance() {
        Realm realm;
        try {
            realm = Realm.getInstance((RealmConfiguration)this.mLegacyConfiguration);
        }
        catch (RealmFileException | IllegalArgumentException ignore) {
            return null;
        }
        return realm;
    }

    public static void registerOnInstanceCreationListener(OnInstanceCreationListener listener) {
        if (ShopGun.isInstantiated()) {
            throw new IllegalStateException("ShopGun instance already created");
        }
        mOnInstanceCreationListeners.add(listener);
    }

    private static void dispatchInstanceCreated() {
        OnInstanceCreationListener[] listeners = null;
        int size = mOnInstanceCreationListeners.size();
        if (size > 0) {
            listeners = mOnInstanceCreationListeners.toArray(new OnInstanceCreationListener[size]);
        }
        if (listeners != null) {
            for (OnInstanceCreationListener listener : listeners) {
                listener.onInstanceCreated();
            }
        }
    }

    static {
        mOnInstanceCreationListeners = new ArrayList<OnInstanceCreationListener>();
    }

    public static interface OnInstanceCreationListener {
        public void onInstanceCreated();
    }

    public static class Builder {
        final Application application;
        ExecutorService executorService;
        Cache cache;
        Network network;
        Boolean develop;
        Environment environment;
        ThemeEnvironment themeEnvironment;
        String eventEnvironment;
        RealmConfiguration realmConfiguration;
        RealmConfiguration legacyConfiguration;
        OkHttpClient okHttpClient;
        ApolloClient apolloClient;
        List<Interceptor> interceptors = new ArrayList<Interceptor>();
        List<Interceptor> networkInterceptors = new ArrayList<Interceptor>();

        public Builder(Application application) {
            if (application == null) {
                throw new IllegalArgumentException("Context must not be null.");
            }
            this.application = application;
        }

        public Builder addInterceptor(Interceptor interceptor) {
            this.interceptors.add(interceptor);
            return this;
        }

        public Builder addNetworkInterceptor(Interceptor interceptor) {
            this.networkInterceptors.add(interceptor);
            return this;
        }

        public Builder setCache(Cache cache) {
            if (cache == null) {
                throw new IllegalArgumentException("Cache must not be null.");
            }
            if (this.cache != null) {
                throw new IllegalStateException("Cache already set.");
            }
            this.cache = cache;
            return this;
        }

        public Builder setNetwork(Network network) {
            if (network == null) {
                throw new IllegalArgumentException("Network must not be null.");
            }
            if (this.network != null) {
                throw new IllegalStateException("Network already set.");
            }
            this.network = network;
            return this;
        }

        public Builder setExecutorService(ExecutorService executorService) {
            if (executorService == null) {
                throw new IllegalArgumentException("ExecutorService must not be null.");
            }
            if (this.executorService != null) {
                throw new IllegalStateException("ExecutorService already set.");
            }
            this.executorService = executorService;
            return this;
        }

        public Builder setDevelop(boolean develop) {
            if (this.develop != null) {
                throw new IllegalStateException("Develop already set.");
            }
            this.develop = develop;
            return this;
        }

        public Builder setEnvironment(Environment environment) {
            if (environment == null) {
                throw new IllegalArgumentException("Environment must not be null.");
            }
            if (this.environment != null) {
                throw new IllegalStateException("Environment already set.");
            }
            this.environment = environment;
            return this;
        }

        public Builder setThemeEnvironment(ThemeEnvironment themeEnvironment) {
            if (themeEnvironment == null) {
                throw new IllegalArgumentException("ThemeEnvironment must not be null.");
            }
            if (this.themeEnvironment != null) {
                throw new IllegalStateException("ThemeEnvironment already set.");
            }
            this.themeEnvironment = themeEnvironment;
            return this;
        }

        public Builder setEventEnvironment(String eventEnvironment) {
            if (eventEnvironment == null) {
                throw new IllegalArgumentException("EventEndpoint must not be null.");
            }
            if (this.eventEnvironment != null) {
                throw new IllegalStateException("EventEndpoint already set.");
            }
            this.eventEnvironment = eventEnvironment;
            return this;
        }

        public synchronized ShopGun setInstance() {
            if (mSingleton != null) {
                SgnLog.d(TAG, "ShopGun instance already build and set.");
                return mSingleton;
            }
            if (this.executorService == null) {
                this.executorService = Executors.newFixedThreadPool(3, new SgnThreadFactory());
            }
            if (this.cache == null) {
                this.cache = new MemoryCache();
            }
            if (this.network == null) {
                this.network = new NetworkImpl(new HttpURLNetwork(new DefaultRedirectProtocol()));
            }
            if (this.develop == null) {
                this.develop = false;
            }
            if (this.environment == null) {
                this.environment = Environment.PRODUCTION;
            }
            if (this.themeEnvironment == null) {
                this.themeEnvironment = ThemeEnvironment.PRODUCTION;
            }
            if (this.eventEnvironment == null) {
                this.eventEnvironment = "https://events.service.shopgun.com/sync";
            }
            OkHttpClient.Builder okHttpClientBuilder = new OkHttpClient.Builder();
            for (Interceptor i : this.interceptors) {
                okHttpClientBuilder.addInterceptor(i);
            }
            for (Interceptor i : this.networkInterceptors) {
                okHttpClientBuilder.addNetworkInterceptor(i);
            }
            okHttpClientBuilder.addInterceptor((Interceptor)new UserAgentInterceptor(SgnUserAgent.getUserAgent((Context)this.application)));
            this.okHttpClient = okHttpClientBuilder.build();
            this.apolloClient = ApolloClient.builder().serverUrl("https://graph.service.shopgun.com").okHttpClient(this.okHttpClient).build();
            Realm.init((Context)this.application);
            this.detectLegacyEvents();
            this.realmConfiguration = new RealmConfiguration.Builder().name("com.shopgun.android.sdk.anonymousEvent.realm").modules((Object)new SgnAnonymousEventRealmModule(), new Object[0]).schemaVersion(2L).build();
            mSingleton = new ShopGun(this);
            return ShopGun.getInstance();
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private void detectLegacyEvents() {
            this.legacyConfiguration = new RealmConfiguration.Builder().name("com.shopgun.android.sdk.realm").modules((Object)new SgnLegacyEventRealmModule(), new Object[0]).schemaVersion(1L).build();
            if (new File(this.legacyConfiguration.getPath()).exists()) {
                boolean isEmpty = true;
                try {
                    Realm realm = Realm.getInstance((RealmConfiguration)this.legacyConfiguration);
                    isEmpty = realm.isEmpty();
                    realm.close();
                    if (!isEmpty) return;
                    Realm.deleteRealm((RealmConfiguration)this.legacyConfiguration);
                    return;
                }
                catch (RealmFileException | IllegalStateException throwable) {
                    return;
                }
                finally {
                    if (isEmpty) {
                        this.legacyConfiguration = null;
                    }
                }
            } else {
                this.legacyConfiguration = null;
            }
        }
    }

    private class SgnLifecycleCallback
    implements LifecycleManager.Callback {
        private SgnLifecycleCallback() {
        }

        @Override
        public void onCreate(Activity activity) {
            ShopGun.this.mSessionId = SgnUtils.createUUID();
            ShopGun.this.mSettings.incrementUsageCount();
            AnonymousEvent session_open_event = new AnonymousEvent(4);
            EventUtils.addLocationInformation(ShopGun.getInstance().getContext(), session_open_event);
            session_open_event.track();
            SgnLog.v(TAG, "onCreate");
        }

        @Override
        public void onStart(Activity activity) {
        }

        @Override
        public void onStop(Activity activity) {
        }

        @Override
        public void onDestroy(Activity activity) {
            ShopGun.this.mSettings.saveLocation(ShopGun.this.mLocation);
            ShopGun.this.mSettings.setLastUsedTimeNow();
            ShopGun.this.mSettings.setSessionId(ShopGun.this.mSessionId);
            SgnLog.v(TAG, "onDestroy");
        }

        @Override
        public void onTrimMemory(int level) {
        }

        @Override
        public void onConfigurationChanged(Configuration newConfig) {
        }
    }
}

