/*
 * Decompiled with CFR 0.152.
 */
package com.shopgun.android.sdk;

import android.app.Activity;
import android.content.Context;
import android.webkit.CookieManager;
import android.webkit.CookieSyncManager;
import com.shopgun.android.sdk.ShopGun;
import com.shopgun.android.sdk.bus.SessionEvent;
import com.shopgun.android.sdk.bus.SgnBus;
import com.shopgun.android.sdk.corekit.LifecycleManager;
import com.shopgun.android.sdk.log.SgnLog;
import com.shopgun.android.sdk.model.Session;
import com.shopgun.android.sdk.network.Request;
import com.shopgun.android.sdk.network.Response;
import com.shopgun.android.sdk.network.ShopGunError;
import com.shopgun.android.sdk.network.impl.JsonObjectRequest;
import com.shopgun.android.sdk.utils.Constants;
import com.shopgun.android.sdk.utils.ExternalClientIdStore;
import com.shopgun.android.sdk.utils.SgnUtils;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.concurrent.TimeUnit;
import org.json.JSONObject;

public class SessionManager {
    public static final String TAG = Constants.getTag(SessionManager.class);
    public static final String ETA_COOKIE_DOMAIN = "etilbudsavis.dk";
    public static final String COOKIE_AUTH_ID = "auth[id]";
    public static final String COOKIE_AUTH_TIME = "auth[time]";
    public static final String COOKIE_AUTH_HASH = "auth[hash]";
    public static long TTL = 3888000L;
    private final Object LOCK = new Object();
    boolean mTryToRecover = true;
    private ShopGun mShopGun;
    private Session mSession;
    private LinkedList<Request<?>> mSessionQueue = new LinkedList();
    private Request<?> mReqInFlight;
    private LifecycleManager.Callback mLifecycleCallback = new LifecycleManager.SimpleCallback(){

        @Override
        public void onCreate(Activity activity) {
            if (SessionManager.this.mSession.getToken() == null) {
                SessionManager.this.postSession(null);
            } else {
                Date now = new Date();
                long delta = now.getTime() - SessionManager.this.mShopGun.getSettings().getLastUsedTime();
                if (delta > TimeUnit.HOURS.toMillis(2L)) {
                    SessionManager.this.putSession(null);
                }
            }
            ExternalClientIdStore.updateCid(SessionManager.this.mSession, SessionManager.this.mShopGun);
        }
    };

    public SessionManager(ShopGun shopGun) {
        this.mShopGun = shopGun;
        JSONObject session = this.mShopGun.getSettings().getSessionJson();
        this.mSession = Session.fromJSON(session);
        if (this.mSession == null) {
            this.mSession = new Session();
        }
        ExternalClientIdStore.updateCid(this.mSession, this.mShopGun);
        this.mShopGun.getLifecycleManager().registerCallback(this.mLifecycleCallback);
    }

    public static boolean recoverableError(ShopGunError e) {
        return e != null && (e.getCode() == 1101 || e.getCode() == 1104 || e.getCode() == 1107 || e.getCode() == 1108);
    }

    public static boolean isSessionError(ShopGunError e) {
        return e != null && 1100 <= e.getCode() && e.getCode() < 1200;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addRequest(JsonObjectRequest r) {
        Object object = this.LOCK;
        synchronized (object) {
            r.setPriority(Request.Priority.HIGH);
            if (this.mSession.getClientId() != null) {
                r.getParameters().put("client_id", this.mSession.getClientId());
            }
            this.mSessionQueue.add(r);
            this.runQueue();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runQueue() {
        if (this.isRequestInFlight()) {
            SgnLog.d(TAG, "Session in flight, waiting for session call to finish");
            return;
        }
        if (this.mSessionQueue.isEmpty()) {
            this.mShopGun.getRequestQueue().runParkedQueue();
        } else {
            Object object = this.LOCK;
            synchronized (object) {
                this.mReqInFlight = this.mSessionQueue.removeFirst();
                this.mShopGun.add(this.mReqInFlight);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean recover(ShopGunError e) {
        Object object = this.LOCK;
        synchronized (object) {
            if (this.mTryToRecover) {
                if (!SessionManager.recoverableError(e)) {
                    this.postSession(null);
                } else {
                    this.putSession(null);
                }
                return true;
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean setSession(JSONObject session) {
        Object object = this.LOCK;
        synchronized (object) {
            Session s = Session.fromJSON(session);
            if (this.mSession == null) {
                this.mSession = new Session();
            }
            if (s.getToken() == null) {
                return false;
            }
            int oldId = this.mSession.getUser().getUserId();
            int newId = s.getUser().getUserId();
            this.mSession = s;
            ExternalClientIdStore.updateCid(this.mSession, this.mShopGun);
            this.mShopGun.getSettings().setSessionJson(session);
            this.mTryToRecover = true;
            SgnBus.getInstance().post((Object)new SessionEvent(oldId, newId));
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Request<?> getRequestInFlight() {
        Object object = this.LOCK;
        synchronized (object) {
            return this.mReqInFlight;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isRequestInFlight() {
        Object object = this.LOCK;
        synchronized (object) {
            return this.mReqInFlight != null;
        }
    }

    private void postSession(Response.Listener<JSONObject> l) {
        HashMap<String, Object> args = new HashMap<String, Object>();
        args.put("token_ttl", TTL);
        args.put("api_key", this.mShopGun.getApiKey());
        try {
            String[] cookies;
            CookieSyncManager.createInstance((Context)this.mShopGun.getContext());
            CookieManager cm = CookieManager.getInstance();
            String cookieString = cm.getCookie(ETA_COOKIE_DOMAIN);
            String authId = null;
            String authTime = null;
            String authHash = null;
            for (String cookie : cookies = cookieString.split(";")) {
                String[] keyValue = cookie.split("=");
                String key = keyValue[0].trim();
                String value = keyValue[1];
                if (value.equals("")) continue;
                if (key.equals(COOKIE_AUTH_ID)) {
                    authId = value;
                    continue;
                }
                if (key.equals(COOKIE_AUTH_HASH)) {
                    authHash = value;
                    continue;
                }
                if (!key.equals(COOKIE_AUTH_TIME)) continue;
                authTime = value;
            }
            if (authId != null && authHash != null && authTime != null) {
                args.put("v1_auth_id", authId);
                args.put("v1_auth_hash", authHash);
                args.put("v1_auth_time", authTime);
            }
            cm.removeAllCookie();
        }
        catch (Exception cm) {
            // empty catch block
        }
        JsonObjectRequest req = new JsonObjectRequest(Request.Method.POST, "/v2/sessions", new JSONObject(args), new SessionListenerWrapper(l));
        this.addRequest(req);
    }

    private void putSession(Response.Listener<JSONObject> l) {
        JsonObjectRequest req = new JsonObjectRequest(Request.Method.PUT, "/v2/sessions", null, new SessionListenerWrapper(l));
        this.addRequest(req);
    }

    public JsonObjectRequest login(String email, String password, Response.Listener<JSONObject> l) {
        HashMap<String, String> args = new HashMap<String, String>();
        args.put("email", email);
        args.put("password", password);
        this.mShopGun.getSettings().setSessionUser(email);
        JsonObjectRequest req = new JsonObjectRequest(Request.Method.PUT, "/v2/sessions", new JSONObject(args), new SessionListenerWrapper(l));
        this.addRequest(req);
        return req;
    }

    public JsonObjectRequest loginFacebook(String facebookAccessToken, Response.Listener<JSONObject> l) {
        HashMap<String, String> args = new HashMap<String, String>();
        args.put("facebook_token", facebookAccessToken);
        this.mShopGun.getSettings().setSessionFacebook(facebookAccessToken);
        JsonObjectRequest req = new JsonObjectRequest(Request.Method.PUT, "/v2/sessions", new JSONObject(args), new SessionListenerWrapper(l));
        this.addRequest(req);
        return req;
    }

    public boolean isFacebookSession() {
        return this.mShopGun.getSettings().getSessionFacebook() != null;
    }

    public JsonObjectRequest signout(Response.Listener<JSONObject> l) {
        this.mShopGun.getSettings().setSessionFacebook(null);
        this.mShopGun.getListManager().clear(this.mSession.getUser().getUserId());
        HashMap<String, String> args = new HashMap<String, String>();
        args.put("email", "");
        JsonObjectRequest req = new JsonObjectRequest(Request.Method.PUT, "/v2/sessions", new JSONObject(args), new SessionListenerWrapper(l));
        this.addRequest(req);
        return req;
    }

    public JsonObjectRequest createUser(String email, String password, String name, int birthYear, String gender, String locale, String successRedirect, String errorRedirect, Response.Listener<JSONObject> l) {
        HashMap<String, String> args = new HashMap<String, String>();
        args.put("email", email.trim());
        args.put("password", password);
        args.put("name", name.trim());
        args.put("birth_year", String.valueOf(birthYear));
        args.put("gender", gender.trim());
        args.put("success_redirect", successRedirect);
        args.put("error_redirect", errorRedirect);
        args.put("locale", locale);
        JsonObjectRequest req = new JsonObjectRequest(Request.Method.POST, "/v2/users", new JSONObject(args), l);
        this.mShopGun.add(req);
        return req;
    }

    public JsonObjectRequest forgotPassword(String email, String successRedirect, String errorRedirect, Response.Listener<JSONObject> l) {
        HashMap<String, String> args = new HashMap<String, String>();
        args.put("email", email);
        args.put("success_redirect", successRedirect);
        args.put("error_redirect", errorRedirect);
        JsonObjectRequest req = new JsonObjectRequest(Request.Method.POST, "/v2/users/reset", new JSONObject(args), l);
        this.mShopGun.add(req);
        return req;
    }

    public Session getSession() {
        return this.mSession;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateTokens(String headerToken, String headerExpires) {
        Object object = this.LOCK;
        synchronized (object) {
            if (this.mSession.getToken() == null || !this.mSession.getToken().equals(headerToken)) {
                this.mSession.setToken(headerToken);
                Date exp = SgnUtils.stringToDate(headerExpires);
                this.mSession.setExpires(exp);
                this.mShopGun.getSettings().setSessionJson(this.mSession.toJSON());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void invalidate() {
        Object object = this.LOCK;
        synchronized (object) {
            int oldUserId = this.mSession.getUser().getUserId();
            this.mSession = new Session();
            ExternalClientIdStore.updateCid(this.mSession, this.mShopGun);
            this.mShopGun.getSettings().setSessionJson(this.mSession.toJSON());
            this.mShopGun.getSettings().setSessionFacebook(null);
            this.clearUser();
            SgnBus.getInstance().post((Object)new SessionEvent(oldUserId, this.mSession.getUser().getUserId()));
        }
    }

    private void clearUser() {
        this.mShopGun.getSettings().setSessionUser(null);
        this.mShopGun.getSettings().setSessionFacebook(null);
    }

    private class SessionListenerWrapper
    implements Response.Listener<JSONObject> {
        Response.Listener<JSONObject> mListener;

        public SessionListenerWrapper(Response.Listener<JSONObject> l) {
            this.mListener = l;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onComplete(JSONObject response, ShopGunError error) {
            Object object = SessionManager.this.LOCK;
            synchronized (object) {
                SessionManager.this.mReqInFlight = null;
                if (response != null) {
                    SessionManager.this.setSession(response);
                    SessionManager.this.runQueue();
                } else if (error.isSdk()) {
                    SessionManager.this.runQueue();
                } else if (SessionManager.this.mTryToRecover && SessionManager.recoverableError(error)) {
                    SessionManager.this.mTryToRecover = false;
                    SessionManager.this.postSession(null);
                } else {
                    SessionManager.this.runQueue();
                }
            }
            if (this.mListener != null) {
                this.mListener.onComplete(response, error);
            }
        }
    }
}

