/*
 * Decompiled with CFR 0.152.
 */
package io.realm;

import android.annotation.TargetApi;
import android.util.JsonReader;
import android.util.JsonToken;
import com.shopgun.android.sdk.eventskit.Event;
import io.realm.BaseRealm;
import io.realm.EventRealmProxyInterface;
import io.realm.ProxyState;
import io.realm.Realm;
import io.realm.RealmFieldType;
import io.realm.RealmModel;
import io.realm.exceptions.RealmException;
import io.realm.internal.ColumnInfo;
import io.realm.internal.OsObject;
import io.realm.internal.OsObjectSchemaInfo;
import io.realm.internal.OsSchemaInfo;
import io.realm.internal.RealmObjectProxy;
import io.realm.internal.Row;
import io.realm.internal.Table;
import io.realm.internal.android.JsonUtils;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.json.JSONException;
import org.json.JSONObject;

public class EventRealmProxy
extends Event
implements RealmObjectProxy,
EventRealmProxyInterface {
    private static final OsObjectSchemaInfo expectedObjectSchemaInfo = EventRealmProxy.createExpectedObjectSchemaInfo();
    private static final List<String> FIELD_NAMES;
    private EventColumnInfo columnInfo;
    private ProxyState<Event> proxyState;

    EventRealmProxy() {
        this.proxyState.setConstructionFinished();
    }

    public void realm$injectObjectContext() {
        if (this.proxyState != null) {
            return;
        }
        BaseRealm.RealmObjectContext context = (BaseRealm.RealmObjectContext)BaseRealm.objectContext.get();
        this.columnInfo = (EventColumnInfo)context.getColumnInfo();
        this.proxyState = new ProxyState((RealmModel)this);
        this.proxyState.setRealm$realm(context.getRealm());
        this.proxyState.setRow$realm(context.getRow());
        this.proxyState.setAcceptDefaultValue$realm(context.getAcceptDefaultValue());
        this.proxyState.setExcludeFields$realm(context.getExcludeFields());
    }

    @Override
    public String realmGet$mVersion() {
        this.proxyState.getRealm$realm().checkIfValid();
        return this.proxyState.getRow$realm().getString(this.columnInfo.mVersionIndex);
    }

    @Override
    public void realmSet$mVersion(String value) {
        if (this.proxyState.isUnderConstruction()) {
            if (!this.proxyState.getAcceptDefaultValue$realm()) {
                return;
            }
            Row row = this.proxyState.getRow$realm();
            if (value == null) {
                row.getTable().setNull(this.columnInfo.mVersionIndex, row.getIndex(), true);
                return;
            }
            row.getTable().setString(this.columnInfo.mVersionIndex, row.getIndex(), value, true);
            return;
        }
        this.proxyState.getRealm$realm().checkIfValid();
        if (value == null) {
            this.proxyState.getRow$realm().setNull(this.columnInfo.mVersionIndex);
            return;
        }
        this.proxyState.getRow$realm().setString(this.columnInfo.mVersionIndex, value);
    }

    @Override
    public String realmGet$mId() {
        this.proxyState.getRealm$realm().checkIfValid();
        return this.proxyState.getRow$realm().getString(this.columnInfo.mIdIndex);
    }

    @Override
    public void realmSet$mId(String value) {
        if (this.proxyState.isUnderConstruction()) {
            return;
        }
        this.proxyState.getRealm$realm().checkIfValid();
        throw new RealmException("Primary key field 'mId' cannot be changed after object was created.");
    }

    @Override
    public String realmGet$mType() {
        this.proxyState.getRealm$realm().checkIfValid();
        return this.proxyState.getRow$realm().getString(this.columnInfo.mTypeIndex);
    }

    @Override
    public void realmSet$mType(String value) {
        if (this.proxyState.isUnderConstruction()) {
            if (!this.proxyState.getAcceptDefaultValue$realm()) {
                return;
            }
            Row row = this.proxyState.getRow$realm();
            if (value == null) {
                row.getTable().setNull(this.columnInfo.mTypeIndex, row.getIndex(), true);
                return;
            }
            row.getTable().setString(this.columnInfo.mTypeIndex, row.getIndex(), value, true);
            return;
        }
        this.proxyState.getRealm$realm().checkIfValid();
        if (value == null) {
            this.proxyState.getRow$realm().setNull(this.columnInfo.mTypeIndex);
            return;
        }
        this.proxyState.getRow$realm().setString(this.columnInfo.mTypeIndex, value);
    }

    @Override
    public Date realmGet$mRecordedAt() {
        this.proxyState.getRealm$realm().checkIfValid();
        if (this.proxyState.getRow$realm().isNull(this.columnInfo.mRecordedAtIndex)) {
            return null;
        }
        return this.proxyState.getRow$realm().getDate(this.columnInfo.mRecordedAtIndex);
    }

    @Override
    public void realmSet$mRecordedAt(Date value) {
        if (this.proxyState.isUnderConstruction()) {
            if (!this.proxyState.getAcceptDefaultValue$realm()) {
                return;
            }
            Row row = this.proxyState.getRow$realm();
            if (value == null) {
                row.getTable().setNull(this.columnInfo.mRecordedAtIndex, row.getIndex(), true);
                return;
            }
            row.getTable().setDate(this.columnInfo.mRecordedAtIndex, row.getIndex(), value, true);
            return;
        }
        this.proxyState.getRealm$realm().checkIfValid();
        if (value == null) {
            this.proxyState.getRow$realm().setNull(this.columnInfo.mRecordedAtIndex);
            return;
        }
        this.proxyState.getRow$realm().setDate(this.columnInfo.mRecordedAtIndex, value);
    }

    @Override
    public Date realmGet$mSentAt() {
        this.proxyState.getRealm$realm().checkIfValid();
        if (this.proxyState.getRow$realm().isNull(this.columnInfo.mSentAtIndex)) {
            return null;
        }
        return this.proxyState.getRow$realm().getDate(this.columnInfo.mSentAtIndex);
    }

    @Override
    public void realmSet$mSentAt(Date value) {
        if (this.proxyState.isUnderConstruction()) {
            if (!this.proxyState.getAcceptDefaultValue$realm()) {
                return;
            }
            Row row = this.proxyState.getRow$realm();
            if (value == null) {
                row.getTable().setNull(this.columnInfo.mSentAtIndex, row.getIndex(), true);
                return;
            }
            row.getTable().setDate(this.columnInfo.mSentAtIndex, row.getIndex(), value, true);
            return;
        }
        this.proxyState.getRealm$realm().checkIfValid();
        if (value == null) {
            this.proxyState.getRow$realm().setNull(this.columnInfo.mSentAtIndex);
            return;
        }
        this.proxyState.getRow$realm().setDate(this.columnInfo.mSentAtIndex, value);
    }

    @Override
    public Date realmGet$mReceivedAt() {
        this.proxyState.getRealm$realm().checkIfValid();
        if (this.proxyState.getRow$realm().isNull(this.columnInfo.mReceivedAtIndex)) {
            return null;
        }
        return this.proxyState.getRow$realm().getDate(this.columnInfo.mReceivedAtIndex);
    }

    @Override
    public void realmSet$mReceivedAt(Date value) {
        if (this.proxyState.isUnderConstruction()) {
            if (!this.proxyState.getAcceptDefaultValue$realm()) {
                return;
            }
            Row row = this.proxyState.getRow$realm();
            if (value == null) {
                row.getTable().setNull(this.columnInfo.mReceivedAtIndex, row.getIndex(), true);
                return;
            }
            row.getTable().setDate(this.columnInfo.mReceivedAtIndex, row.getIndex(), value, true);
            return;
        }
        this.proxyState.getRealm$realm().checkIfValid();
        if (value == null) {
            this.proxyState.getRow$realm().setNull(this.columnInfo.mReceivedAtIndex);
            return;
        }
        this.proxyState.getRow$realm().setDate(this.columnInfo.mReceivedAtIndex, value);
    }

    @Override
    public int realmGet$mRetryCount() {
        this.proxyState.getRealm$realm().checkIfValid();
        return (int)this.proxyState.getRow$realm().getLong(this.columnInfo.mRetryCountIndex);
    }

    @Override
    public void realmSet$mRetryCount(int value) {
        if (this.proxyState.isUnderConstruction()) {
            if (!this.proxyState.getAcceptDefaultValue$realm()) {
                return;
            }
            Row row = this.proxyState.getRow$realm();
            row.getTable().setLong(this.columnInfo.mRetryCountIndex, row.getIndex(), (long)value, true);
            return;
        }
        this.proxyState.getRealm$realm().checkIfValid();
        this.proxyState.getRow$realm().setLong(this.columnInfo.mRetryCountIndex, (long)value);
    }

    @Override
    public String realmGet$mStringClient() {
        this.proxyState.getRealm$realm().checkIfValid();
        return this.proxyState.getRow$realm().getString(this.columnInfo.mStringClientIndex);
    }

    @Override
    public void realmSet$mStringClient(String value) {
        if (this.proxyState.isUnderConstruction()) {
            if (!this.proxyState.getAcceptDefaultValue$realm()) {
                return;
            }
            Row row = this.proxyState.getRow$realm();
            if (value == null) {
                row.getTable().setNull(this.columnInfo.mStringClientIndex, row.getIndex(), true);
                return;
            }
            row.getTable().setString(this.columnInfo.mStringClientIndex, row.getIndex(), value, true);
            return;
        }
        this.proxyState.getRealm$realm().checkIfValid();
        if (value == null) {
            this.proxyState.getRow$realm().setNull(this.columnInfo.mStringClientIndex);
            return;
        }
        this.proxyState.getRow$realm().setString(this.columnInfo.mStringClientIndex, value);
    }

    @Override
    public String realmGet$mStringContext() {
        this.proxyState.getRealm$realm().checkIfValid();
        return this.proxyState.getRow$realm().getString(this.columnInfo.mStringContextIndex);
    }

    @Override
    public void realmSet$mStringContext(String value) {
        if (this.proxyState.isUnderConstruction()) {
            if (!this.proxyState.getAcceptDefaultValue$realm()) {
                return;
            }
            Row row = this.proxyState.getRow$realm();
            if (value == null) {
                row.getTable().setNull(this.columnInfo.mStringContextIndex, row.getIndex(), true);
                return;
            }
            row.getTable().setString(this.columnInfo.mStringContextIndex, row.getIndex(), value, true);
            return;
        }
        this.proxyState.getRealm$realm().checkIfValid();
        if (value == null) {
            this.proxyState.getRow$realm().setNull(this.columnInfo.mStringContextIndex);
            return;
        }
        this.proxyState.getRow$realm().setString(this.columnInfo.mStringContextIndex, value);
    }

    @Override
    public String realmGet$mStringProperties() {
        this.proxyState.getRealm$realm().checkIfValid();
        return this.proxyState.getRow$realm().getString(this.columnInfo.mStringPropertiesIndex);
    }

    @Override
    public void realmSet$mStringProperties(String value) {
        if (this.proxyState.isUnderConstruction()) {
            if (!this.proxyState.getAcceptDefaultValue$realm()) {
                return;
            }
            Row row = this.proxyState.getRow$realm();
            if (value == null) {
                row.getTable().setNull(this.columnInfo.mStringPropertiesIndex, row.getIndex(), true);
                return;
            }
            row.getTable().setString(this.columnInfo.mStringPropertiesIndex, row.getIndex(), value, true);
            return;
        }
        this.proxyState.getRealm$realm().checkIfValid();
        if (value == null) {
            this.proxyState.getRow$realm().setNull(this.columnInfo.mStringPropertiesIndex);
            return;
        }
        this.proxyState.getRow$realm().setString(this.columnInfo.mStringPropertiesIndex, value);
    }

    private static OsObjectSchemaInfo createExpectedObjectSchemaInfo() {
        OsObjectSchemaInfo.Builder builder = new OsObjectSchemaInfo.Builder("Event", 10, 0);
        builder.addPersistedProperty("mVersion", RealmFieldType.STRING, false, false, false);
        builder.addPersistedProperty("mId", RealmFieldType.STRING, true, true, false);
        builder.addPersistedProperty("mType", RealmFieldType.STRING, false, false, false);
        builder.addPersistedProperty("mRecordedAt", RealmFieldType.DATE, false, false, false);
        builder.addPersistedProperty("mSentAt", RealmFieldType.DATE, false, false, false);
        builder.addPersistedProperty("mReceivedAt", RealmFieldType.DATE, false, false, false);
        builder.addPersistedProperty("mRetryCount", RealmFieldType.INTEGER, false, false, true);
        builder.addPersistedProperty("mStringClient", RealmFieldType.STRING, false, false, false);
        builder.addPersistedProperty("mStringContext", RealmFieldType.STRING, false, false, false);
        builder.addPersistedProperty("mStringProperties", RealmFieldType.STRING, false, false, false);
        return builder.build();
    }

    public static OsObjectSchemaInfo getExpectedObjectSchemaInfo() {
        return expectedObjectSchemaInfo;
    }

    public static EventColumnInfo createColumnInfo(OsSchemaInfo schemaInfo) {
        return new EventColumnInfo(schemaInfo);
    }

    public static String getSimpleClassName() {
        return "Event";
    }

    public static List<String> getFieldNames() {
        return FIELD_NAMES;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Event createOrUpdateUsingJsonObject(Realm realm, JSONObject json, boolean update) throws JSONException {
        Object timestamp;
        List excludeFields = Collections.emptyList();
        EventRealmProxy obj = null;
        if (update) {
            Table table = realm.getTable(Event.class);
            EventColumnInfo columnInfo = (EventColumnInfo)realm.getSchema().getColumnInfo(Event.class);
            long pkColumnIndex = columnInfo.mIdIndex;
            long rowIndex = -1L;
            rowIndex = json.isNull("mId") ? table.findFirstNull(pkColumnIndex) : table.findFirstString(pkColumnIndex, json.getString("mId"));
            if (rowIndex != -1L) {
                BaseRealm.RealmObjectContext objectContext = (BaseRealm.RealmObjectContext)BaseRealm.objectContext.get();
                try {
                    objectContext.set((BaseRealm)realm, (Row)table.getUncheckedRow(rowIndex), realm.getSchema().getColumnInfo(Event.class), false, Collections.emptyList());
                    obj = new EventRealmProxy();
                }
                finally {
                    objectContext.clear();
                }
            }
        }
        if (obj == null) {
            if (json.has("mId")) {
                obj = json.isNull("mId") ? (EventRealmProxy)realm.createObjectInternal(Event.class, null, true, excludeFields) : (EventRealmProxy)realm.createObjectInternal(Event.class, (Object)json.getString("mId"), true, excludeFields);
            } else {
                throw new IllegalArgumentException("JSON object doesn't have the primary key field 'mId'.");
            }
        }
        EventRealmProxyInterface objProxy = obj;
        if (json.has("mVersion")) {
            if (json.isNull("mVersion")) {
                objProxy.realmSet$mVersion(null);
            } else {
                objProxy.realmSet$mVersion(json.getString("mVersion"));
            }
        }
        if (json.has("mType")) {
            if (json.isNull("mType")) {
                objProxy.realmSet$mType(null);
            } else {
                objProxy.realmSet$mType(json.getString("mType"));
            }
        }
        if (json.has("mRecordedAt")) {
            if (json.isNull("mRecordedAt")) {
                objProxy.realmSet$mRecordedAt(null);
            } else {
                timestamp = json.get("mRecordedAt");
                if (timestamp instanceof String) {
                    objProxy.realmSet$mRecordedAt(JsonUtils.stringToDate((String)((String)timestamp)));
                } else {
                    objProxy.realmSet$mRecordedAt(new Date(json.getLong("mRecordedAt")));
                }
            }
        }
        if (json.has("mSentAt")) {
            if (json.isNull("mSentAt")) {
                objProxy.realmSet$mSentAt(null);
            } else {
                timestamp = json.get("mSentAt");
                if (timestamp instanceof String) {
                    objProxy.realmSet$mSentAt(JsonUtils.stringToDate((String)((String)timestamp)));
                } else {
                    objProxy.realmSet$mSentAt(new Date(json.getLong("mSentAt")));
                }
            }
        }
        if (json.has("mReceivedAt")) {
            if (json.isNull("mReceivedAt")) {
                objProxy.realmSet$mReceivedAt(null);
            } else {
                timestamp = json.get("mReceivedAt");
                if (timestamp instanceof String) {
                    objProxy.realmSet$mReceivedAt(JsonUtils.stringToDate((String)((String)timestamp)));
                } else {
                    objProxy.realmSet$mReceivedAt(new Date(json.getLong("mReceivedAt")));
                }
            }
        }
        if (json.has("mRetryCount")) {
            if (json.isNull("mRetryCount")) {
                throw new IllegalArgumentException("Trying to set non-nullable field 'mRetryCount' to null.");
            }
            objProxy.realmSet$mRetryCount(json.getInt("mRetryCount"));
        }
        if (json.has("mStringClient")) {
            if (json.isNull("mStringClient")) {
                objProxy.realmSet$mStringClient(null);
            } else {
                objProxy.realmSet$mStringClient(json.getString("mStringClient"));
            }
        }
        if (json.has("mStringContext")) {
            if (json.isNull("mStringContext")) {
                objProxy.realmSet$mStringContext(null);
            } else {
                objProxy.realmSet$mStringContext(json.getString("mStringContext"));
            }
        }
        if (json.has("mStringProperties")) {
            if (json.isNull("mStringProperties")) {
                objProxy.realmSet$mStringProperties(null);
            } else {
                objProxy.realmSet$mStringProperties(json.getString("mStringProperties"));
            }
        }
        return obj;
    }

    @TargetApi(value=11)
    public static Event createUsingJsonStream(Realm realm, JsonReader reader) throws IOException {
        boolean jsonHasPrimaryKey = false;
        Event obj = new Event();
        EventRealmProxyInterface objProxy = obj;
        reader.beginObject();
        while (reader.hasNext()) {
            long timestamp;
            String name = reader.nextName();
            if (name.equals("mVersion")) {
                if (reader.peek() != JsonToken.NULL) {
                    objProxy.realmSet$mVersion(reader.nextString());
                    continue;
                }
                reader.skipValue();
                objProxy.realmSet$mVersion(null);
                continue;
            }
            if (name.equals("mId")) {
                if (reader.peek() != JsonToken.NULL) {
                    objProxy.realmSet$mId(reader.nextString());
                } else {
                    reader.skipValue();
                    objProxy.realmSet$mId(null);
                }
                jsonHasPrimaryKey = true;
                continue;
            }
            if (name.equals("mType")) {
                if (reader.peek() != JsonToken.NULL) {
                    objProxy.realmSet$mType(reader.nextString());
                    continue;
                }
                reader.skipValue();
                objProxy.realmSet$mType(null);
                continue;
            }
            if (name.equals("mRecordedAt")) {
                if (reader.peek() == JsonToken.NULL) {
                    reader.skipValue();
                    objProxy.realmSet$mRecordedAt(null);
                    continue;
                }
                if (reader.peek() == JsonToken.NUMBER) {
                    timestamp = reader.nextLong();
                    if (timestamp <= -1L) continue;
                    objProxy.realmSet$mRecordedAt(new Date(timestamp));
                    continue;
                }
                objProxy.realmSet$mRecordedAt(JsonUtils.stringToDate((String)reader.nextString()));
                continue;
            }
            if (name.equals("mSentAt")) {
                if (reader.peek() == JsonToken.NULL) {
                    reader.skipValue();
                    objProxy.realmSet$mSentAt(null);
                    continue;
                }
                if (reader.peek() == JsonToken.NUMBER) {
                    timestamp = reader.nextLong();
                    if (timestamp <= -1L) continue;
                    objProxy.realmSet$mSentAt(new Date(timestamp));
                    continue;
                }
                objProxy.realmSet$mSentAt(JsonUtils.stringToDate((String)reader.nextString()));
                continue;
            }
            if (name.equals("mReceivedAt")) {
                if (reader.peek() == JsonToken.NULL) {
                    reader.skipValue();
                    objProxy.realmSet$mReceivedAt(null);
                    continue;
                }
                if (reader.peek() == JsonToken.NUMBER) {
                    timestamp = reader.nextLong();
                    if (timestamp <= -1L) continue;
                    objProxy.realmSet$mReceivedAt(new Date(timestamp));
                    continue;
                }
                objProxy.realmSet$mReceivedAt(JsonUtils.stringToDate((String)reader.nextString()));
                continue;
            }
            if (name.equals("mRetryCount")) {
                if (reader.peek() != JsonToken.NULL) {
                    objProxy.realmSet$mRetryCount(reader.nextInt());
                    continue;
                }
                reader.skipValue();
                throw new IllegalArgumentException("Trying to set non-nullable field 'mRetryCount' to null.");
            }
            if (name.equals("mStringClient")) {
                if (reader.peek() != JsonToken.NULL) {
                    objProxy.realmSet$mStringClient(reader.nextString());
                    continue;
                }
                reader.skipValue();
                objProxy.realmSet$mStringClient(null);
                continue;
            }
            if (name.equals("mStringContext")) {
                if (reader.peek() != JsonToken.NULL) {
                    objProxy.realmSet$mStringContext(reader.nextString());
                    continue;
                }
                reader.skipValue();
                objProxy.realmSet$mStringContext(null);
                continue;
            }
            if (name.equals("mStringProperties")) {
                if (reader.peek() != JsonToken.NULL) {
                    objProxy.realmSet$mStringProperties(reader.nextString());
                    continue;
                }
                reader.skipValue();
                objProxy.realmSet$mStringProperties(null);
                continue;
            }
            reader.skipValue();
        }
        reader.endObject();
        if (!jsonHasPrimaryKey) {
            throw new IllegalArgumentException("JSON object doesn't have the primary key field 'mId'.");
        }
        return (Event)realm.copyToRealm((RealmModel)obj);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Event copyOrUpdate(Realm realm, Event object, boolean update, Map<RealmModel, RealmObjectProxy> cache) {
        if (object instanceof RealmObjectProxy && ((RealmObjectProxy)object).realmGet$proxyState().getRealm$realm() != null) {
            BaseRealm otherRealm = ((RealmObjectProxy)object).realmGet$proxyState().getRealm$realm();
            if (otherRealm.threadId != realm.threadId) {
                throw new IllegalArgumentException("Objects which belong to Realm instances in other threads cannot be copied into this Realm instance.");
            }
            if (otherRealm.getPath().equals(realm.getPath())) {
                return object;
            }
        }
        BaseRealm.RealmObjectContext objectContext = (BaseRealm.RealmObjectContext)BaseRealm.objectContext.get();
        RealmObjectProxy cachedRealmObject = cache.get(object);
        if (cachedRealmObject != null) {
            return (Event)cachedRealmObject;
        }
        EventRealmProxy realmObject = null;
        boolean canUpdate = update;
        if (canUpdate) {
            Table table = realm.getTable(Event.class);
            EventColumnInfo columnInfo = (EventColumnInfo)realm.getSchema().getColumnInfo(Event.class);
            long pkColumnIndex = columnInfo.mIdIndex;
            String value = ((EventRealmProxyInterface)object).realmGet$mId();
            long rowIndex = -1L;
            rowIndex = value == null ? table.findFirstNull(pkColumnIndex) : table.findFirstString(pkColumnIndex, value);
            if (rowIndex == -1L) {
                canUpdate = false;
            } else {
                try {
                    objectContext.set((BaseRealm)realm, (Row)table.getUncheckedRow(rowIndex), realm.getSchema().getColumnInfo(Event.class), false, Collections.emptyList());
                    realmObject = new EventRealmProxy();
                    cache.put(object, realmObject);
                }
                finally {
                    objectContext.clear();
                }
            }
        }
        return canUpdate ? EventRealmProxy.update(realm, realmObject, object, cache) : EventRealmProxy.copy(realm, object, update, cache);
    }

    public static Event copy(Realm realm, Event newObject, boolean update, Map<RealmModel, RealmObjectProxy> cache) {
        RealmObjectProxy cachedRealmObject = cache.get(newObject);
        if (cachedRealmObject != null) {
            return (Event)cachedRealmObject;
        }
        Event realmObject = (Event)realm.createObjectInternal(Event.class, (Object)((EventRealmProxyInterface)newObject).realmGet$mId(), false, Collections.emptyList());
        cache.put(newObject, (RealmObjectProxy)realmObject);
        EventRealmProxyInterface realmObjectSource = newObject;
        EventRealmProxyInterface realmObjectCopy = realmObject;
        realmObjectCopy.realmSet$mVersion(realmObjectSource.realmGet$mVersion());
        realmObjectCopy.realmSet$mType(realmObjectSource.realmGet$mType());
        realmObjectCopy.realmSet$mRecordedAt(realmObjectSource.realmGet$mRecordedAt());
        realmObjectCopy.realmSet$mSentAt(realmObjectSource.realmGet$mSentAt());
        realmObjectCopy.realmSet$mReceivedAt(realmObjectSource.realmGet$mReceivedAt());
        realmObjectCopy.realmSet$mRetryCount(realmObjectSource.realmGet$mRetryCount());
        realmObjectCopy.realmSet$mStringClient(realmObjectSource.realmGet$mStringClient());
        realmObjectCopy.realmSet$mStringContext(realmObjectSource.realmGet$mStringContext());
        realmObjectCopy.realmSet$mStringProperties(realmObjectSource.realmGet$mStringProperties());
        return realmObject;
    }

    public static long insert(Realm realm, Event object, Map<RealmModel, Long> cache) {
        String realmGet$mStringProperties;
        String realmGet$mStringContext;
        Date realmGet$mReceivedAt;
        Date realmGet$mSentAt;
        Date realmGet$mRecordedAt;
        String realmGet$mType;
        if (object instanceof RealmObjectProxy && ((RealmObjectProxy)object).realmGet$proxyState().getRealm$realm() != null && ((RealmObjectProxy)object).realmGet$proxyState().getRealm$realm().getPath().equals(realm.getPath())) {
            return ((RealmObjectProxy)object).realmGet$proxyState().getRow$realm().getIndex();
        }
        Table table = realm.getTable(Event.class);
        long tableNativePtr = table.getNativePtr();
        EventColumnInfo columnInfo = (EventColumnInfo)realm.getSchema().getColumnInfo(Event.class);
        long pkColumnIndex = columnInfo.mIdIndex;
        String primaryKeyValue = ((EventRealmProxyInterface)object).realmGet$mId();
        long rowIndex = -1L;
        rowIndex = primaryKeyValue == null ? Table.nativeFindFirstNull((long)tableNativePtr, (long)pkColumnIndex) : Table.nativeFindFirstString((long)tableNativePtr, (long)pkColumnIndex, (String)primaryKeyValue);
        if (rowIndex == -1L) {
            rowIndex = OsObject.createRowWithPrimaryKey((Table)table, (long)pkColumnIndex, (Object)primaryKeyValue);
        } else {
            Table.throwDuplicatePrimaryKeyException((Object)primaryKeyValue);
        }
        cache.put(object, rowIndex);
        String realmGet$mVersion = ((EventRealmProxyInterface)object).realmGet$mVersion();
        if (realmGet$mVersion != null) {
            Table.nativeSetString((long)tableNativePtr, (long)columnInfo.mVersionIndex, (long)rowIndex, (String)realmGet$mVersion, (boolean)false);
        }
        if ((realmGet$mType = ((EventRealmProxyInterface)object).realmGet$mType()) != null) {
            Table.nativeSetString((long)tableNativePtr, (long)columnInfo.mTypeIndex, (long)rowIndex, (String)realmGet$mType, (boolean)false);
        }
        if ((realmGet$mRecordedAt = ((EventRealmProxyInterface)object).realmGet$mRecordedAt()) != null) {
            Table.nativeSetTimestamp((long)tableNativePtr, (long)columnInfo.mRecordedAtIndex, (long)rowIndex, (long)realmGet$mRecordedAt.getTime(), (boolean)false);
        }
        if ((realmGet$mSentAt = ((EventRealmProxyInterface)object).realmGet$mSentAt()) != null) {
            Table.nativeSetTimestamp((long)tableNativePtr, (long)columnInfo.mSentAtIndex, (long)rowIndex, (long)realmGet$mSentAt.getTime(), (boolean)false);
        }
        if ((realmGet$mReceivedAt = ((EventRealmProxyInterface)object).realmGet$mReceivedAt()) != null) {
            Table.nativeSetTimestamp((long)tableNativePtr, (long)columnInfo.mReceivedAtIndex, (long)rowIndex, (long)realmGet$mReceivedAt.getTime(), (boolean)false);
        }
        Table.nativeSetLong((long)tableNativePtr, (long)columnInfo.mRetryCountIndex, (long)rowIndex, (long)((EventRealmProxyInterface)object).realmGet$mRetryCount(), (boolean)false);
        String realmGet$mStringClient = ((EventRealmProxyInterface)object).realmGet$mStringClient();
        if (realmGet$mStringClient != null) {
            Table.nativeSetString((long)tableNativePtr, (long)columnInfo.mStringClientIndex, (long)rowIndex, (String)realmGet$mStringClient, (boolean)false);
        }
        if ((realmGet$mStringContext = ((EventRealmProxyInterface)object).realmGet$mStringContext()) != null) {
            Table.nativeSetString((long)tableNativePtr, (long)columnInfo.mStringContextIndex, (long)rowIndex, (String)realmGet$mStringContext, (boolean)false);
        }
        if ((realmGet$mStringProperties = ((EventRealmProxyInterface)object).realmGet$mStringProperties()) != null) {
            Table.nativeSetString((long)tableNativePtr, (long)columnInfo.mStringPropertiesIndex, (long)rowIndex, (String)realmGet$mStringProperties, (boolean)false);
        }
        return rowIndex;
    }

    public static void insert(Realm realm, Iterator<? extends RealmModel> objects, Map<RealmModel, Long> cache) {
        Table table = realm.getTable(Event.class);
        long tableNativePtr = table.getNativePtr();
        EventColumnInfo columnInfo = (EventColumnInfo)realm.getSchema().getColumnInfo(Event.class);
        long pkColumnIndex = columnInfo.mIdIndex;
        Event object = null;
        while (objects.hasNext()) {
            String realmGet$mStringProperties;
            String realmGet$mStringContext;
            Date realmGet$mReceivedAt;
            Date realmGet$mSentAt;
            Date realmGet$mRecordedAt;
            String realmGet$mType;
            object = (Event)objects.next();
            if (cache.containsKey(object)) continue;
            if (object instanceof RealmObjectProxy && ((RealmObjectProxy)object).realmGet$proxyState().getRealm$realm() != null && ((RealmObjectProxy)object).realmGet$proxyState().getRealm$realm().getPath().equals(realm.getPath())) {
                cache.put(object, ((RealmObjectProxy)object).realmGet$proxyState().getRow$realm().getIndex());
                continue;
            }
            String primaryKeyValue = ((EventRealmProxyInterface)object).realmGet$mId();
            long rowIndex = -1L;
            rowIndex = primaryKeyValue == null ? Table.nativeFindFirstNull((long)tableNativePtr, (long)pkColumnIndex) : Table.nativeFindFirstString((long)tableNativePtr, (long)pkColumnIndex, (String)primaryKeyValue);
            if (rowIndex == -1L) {
                rowIndex = OsObject.createRowWithPrimaryKey((Table)table, (long)pkColumnIndex, (Object)primaryKeyValue);
            } else {
                Table.throwDuplicatePrimaryKeyException((Object)primaryKeyValue);
            }
            cache.put(object, rowIndex);
            String realmGet$mVersion = ((EventRealmProxyInterface)object).realmGet$mVersion();
            if (realmGet$mVersion != null) {
                Table.nativeSetString((long)tableNativePtr, (long)columnInfo.mVersionIndex, (long)rowIndex, (String)realmGet$mVersion, (boolean)false);
            }
            if ((realmGet$mType = ((EventRealmProxyInterface)object).realmGet$mType()) != null) {
                Table.nativeSetString((long)tableNativePtr, (long)columnInfo.mTypeIndex, (long)rowIndex, (String)realmGet$mType, (boolean)false);
            }
            if ((realmGet$mRecordedAt = ((EventRealmProxyInterface)object).realmGet$mRecordedAt()) != null) {
                Table.nativeSetTimestamp((long)tableNativePtr, (long)columnInfo.mRecordedAtIndex, (long)rowIndex, (long)realmGet$mRecordedAt.getTime(), (boolean)false);
            }
            if ((realmGet$mSentAt = ((EventRealmProxyInterface)object).realmGet$mSentAt()) != null) {
                Table.nativeSetTimestamp((long)tableNativePtr, (long)columnInfo.mSentAtIndex, (long)rowIndex, (long)realmGet$mSentAt.getTime(), (boolean)false);
            }
            if ((realmGet$mReceivedAt = ((EventRealmProxyInterface)object).realmGet$mReceivedAt()) != null) {
                Table.nativeSetTimestamp((long)tableNativePtr, (long)columnInfo.mReceivedAtIndex, (long)rowIndex, (long)realmGet$mReceivedAt.getTime(), (boolean)false);
            }
            Table.nativeSetLong((long)tableNativePtr, (long)columnInfo.mRetryCountIndex, (long)rowIndex, (long)((EventRealmProxyInterface)object).realmGet$mRetryCount(), (boolean)false);
            String realmGet$mStringClient = ((EventRealmProxyInterface)object).realmGet$mStringClient();
            if (realmGet$mStringClient != null) {
                Table.nativeSetString((long)tableNativePtr, (long)columnInfo.mStringClientIndex, (long)rowIndex, (String)realmGet$mStringClient, (boolean)false);
            }
            if ((realmGet$mStringContext = ((EventRealmProxyInterface)object).realmGet$mStringContext()) != null) {
                Table.nativeSetString((long)tableNativePtr, (long)columnInfo.mStringContextIndex, (long)rowIndex, (String)realmGet$mStringContext, (boolean)false);
            }
            if ((realmGet$mStringProperties = ((EventRealmProxyInterface)object).realmGet$mStringProperties()) == null) continue;
            Table.nativeSetString((long)tableNativePtr, (long)columnInfo.mStringPropertiesIndex, (long)rowIndex, (String)realmGet$mStringProperties, (boolean)false);
        }
    }

    public static long insertOrUpdate(Realm realm, Event object, Map<RealmModel, Long> cache) {
        if (object instanceof RealmObjectProxy && ((RealmObjectProxy)object).realmGet$proxyState().getRealm$realm() != null && ((RealmObjectProxy)object).realmGet$proxyState().getRealm$realm().getPath().equals(realm.getPath())) {
            return ((RealmObjectProxy)object).realmGet$proxyState().getRow$realm().getIndex();
        }
        Table table = realm.getTable(Event.class);
        long tableNativePtr = table.getNativePtr();
        EventColumnInfo columnInfo = (EventColumnInfo)realm.getSchema().getColumnInfo(Event.class);
        long pkColumnIndex = columnInfo.mIdIndex;
        String primaryKeyValue = ((EventRealmProxyInterface)object).realmGet$mId();
        long rowIndex = -1L;
        rowIndex = primaryKeyValue == null ? Table.nativeFindFirstNull((long)tableNativePtr, (long)pkColumnIndex) : Table.nativeFindFirstString((long)tableNativePtr, (long)pkColumnIndex, (String)primaryKeyValue);
        if (rowIndex == -1L) {
            rowIndex = OsObject.createRowWithPrimaryKey((Table)table, (long)pkColumnIndex, (Object)primaryKeyValue);
        }
        cache.put(object, rowIndex);
        String realmGet$mVersion = ((EventRealmProxyInterface)object).realmGet$mVersion();
        if (realmGet$mVersion != null) {
            Table.nativeSetString((long)tableNativePtr, (long)columnInfo.mVersionIndex, (long)rowIndex, (String)realmGet$mVersion, (boolean)false);
        } else {
            Table.nativeSetNull((long)tableNativePtr, (long)columnInfo.mVersionIndex, (long)rowIndex, (boolean)false);
        }
        String realmGet$mType = ((EventRealmProxyInterface)object).realmGet$mType();
        if (realmGet$mType != null) {
            Table.nativeSetString((long)tableNativePtr, (long)columnInfo.mTypeIndex, (long)rowIndex, (String)realmGet$mType, (boolean)false);
        } else {
            Table.nativeSetNull((long)tableNativePtr, (long)columnInfo.mTypeIndex, (long)rowIndex, (boolean)false);
        }
        Date realmGet$mRecordedAt = ((EventRealmProxyInterface)object).realmGet$mRecordedAt();
        if (realmGet$mRecordedAt != null) {
            Table.nativeSetTimestamp((long)tableNativePtr, (long)columnInfo.mRecordedAtIndex, (long)rowIndex, (long)realmGet$mRecordedAt.getTime(), (boolean)false);
        } else {
            Table.nativeSetNull((long)tableNativePtr, (long)columnInfo.mRecordedAtIndex, (long)rowIndex, (boolean)false);
        }
        Date realmGet$mSentAt = ((EventRealmProxyInterface)object).realmGet$mSentAt();
        if (realmGet$mSentAt != null) {
            Table.nativeSetTimestamp((long)tableNativePtr, (long)columnInfo.mSentAtIndex, (long)rowIndex, (long)realmGet$mSentAt.getTime(), (boolean)false);
        } else {
            Table.nativeSetNull((long)tableNativePtr, (long)columnInfo.mSentAtIndex, (long)rowIndex, (boolean)false);
        }
        Date realmGet$mReceivedAt = ((EventRealmProxyInterface)object).realmGet$mReceivedAt();
        if (realmGet$mReceivedAt != null) {
            Table.nativeSetTimestamp((long)tableNativePtr, (long)columnInfo.mReceivedAtIndex, (long)rowIndex, (long)realmGet$mReceivedAt.getTime(), (boolean)false);
        } else {
            Table.nativeSetNull((long)tableNativePtr, (long)columnInfo.mReceivedAtIndex, (long)rowIndex, (boolean)false);
        }
        Table.nativeSetLong((long)tableNativePtr, (long)columnInfo.mRetryCountIndex, (long)rowIndex, (long)((EventRealmProxyInterface)object).realmGet$mRetryCount(), (boolean)false);
        String realmGet$mStringClient = ((EventRealmProxyInterface)object).realmGet$mStringClient();
        if (realmGet$mStringClient != null) {
            Table.nativeSetString((long)tableNativePtr, (long)columnInfo.mStringClientIndex, (long)rowIndex, (String)realmGet$mStringClient, (boolean)false);
        } else {
            Table.nativeSetNull((long)tableNativePtr, (long)columnInfo.mStringClientIndex, (long)rowIndex, (boolean)false);
        }
        String realmGet$mStringContext = ((EventRealmProxyInterface)object).realmGet$mStringContext();
        if (realmGet$mStringContext != null) {
            Table.nativeSetString((long)tableNativePtr, (long)columnInfo.mStringContextIndex, (long)rowIndex, (String)realmGet$mStringContext, (boolean)false);
        } else {
            Table.nativeSetNull((long)tableNativePtr, (long)columnInfo.mStringContextIndex, (long)rowIndex, (boolean)false);
        }
        String realmGet$mStringProperties = ((EventRealmProxyInterface)object).realmGet$mStringProperties();
        if (realmGet$mStringProperties != null) {
            Table.nativeSetString((long)tableNativePtr, (long)columnInfo.mStringPropertiesIndex, (long)rowIndex, (String)realmGet$mStringProperties, (boolean)false);
        } else {
            Table.nativeSetNull((long)tableNativePtr, (long)columnInfo.mStringPropertiesIndex, (long)rowIndex, (boolean)false);
        }
        return rowIndex;
    }

    public static void insertOrUpdate(Realm realm, Iterator<? extends RealmModel> objects, Map<RealmModel, Long> cache) {
        Table table = realm.getTable(Event.class);
        long tableNativePtr = table.getNativePtr();
        EventColumnInfo columnInfo = (EventColumnInfo)realm.getSchema().getColumnInfo(Event.class);
        long pkColumnIndex = columnInfo.mIdIndex;
        Event object = null;
        while (objects.hasNext()) {
            object = (Event)objects.next();
            if (cache.containsKey(object)) continue;
            if (object instanceof RealmObjectProxy && ((RealmObjectProxy)object).realmGet$proxyState().getRealm$realm() != null && ((RealmObjectProxy)object).realmGet$proxyState().getRealm$realm().getPath().equals(realm.getPath())) {
                cache.put(object, ((RealmObjectProxy)object).realmGet$proxyState().getRow$realm().getIndex());
                continue;
            }
            String primaryKeyValue = ((EventRealmProxyInterface)object).realmGet$mId();
            long rowIndex = -1L;
            rowIndex = primaryKeyValue == null ? Table.nativeFindFirstNull((long)tableNativePtr, (long)pkColumnIndex) : Table.nativeFindFirstString((long)tableNativePtr, (long)pkColumnIndex, (String)primaryKeyValue);
            if (rowIndex == -1L) {
                rowIndex = OsObject.createRowWithPrimaryKey((Table)table, (long)pkColumnIndex, (Object)primaryKeyValue);
            }
            cache.put(object, rowIndex);
            String realmGet$mVersion = ((EventRealmProxyInterface)object).realmGet$mVersion();
            if (realmGet$mVersion != null) {
                Table.nativeSetString((long)tableNativePtr, (long)columnInfo.mVersionIndex, (long)rowIndex, (String)realmGet$mVersion, (boolean)false);
            } else {
                Table.nativeSetNull((long)tableNativePtr, (long)columnInfo.mVersionIndex, (long)rowIndex, (boolean)false);
            }
            String realmGet$mType = ((EventRealmProxyInterface)object).realmGet$mType();
            if (realmGet$mType != null) {
                Table.nativeSetString((long)tableNativePtr, (long)columnInfo.mTypeIndex, (long)rowIndex, (String)realmGet$mType, (boolean)false);
            } else {
                Table.nativeSetNull((long)tableNativePtr, (long)columnInfo.mTypeIndex, (long)rowIndex, (boolean)false);
            }
            Date realmGet$mRecordedAt = ((EventRealmProxyInterface)object).realmGet$mRecordedAt();
            if (realmGet$mRecordedAt != null) {
                Table.nativeSetTimestamp((long)tableNativePtr, (long)columnInfo.mRecordedAtIndex, (long)rowIndex, (long)realmGet$mRecordedAt.getTime(), (boolean)false);
            } else {
                Table.nativeSetNull((long)tableNativePtr, (long)columnInfo.mRecordedAtIndex, (long)rowIndex, (boolean)false);
            }
            Date realmGet$mSentAt = ((EventRealmProxyInterface)object).realmGet$mSentAt();
            if (realmGet$mSentAt != null) {
                Table.nativeSetTimestamp((long)tableNativePtr, (long)columnInfo.mSentAtIndex, (long)rowIndex, (long)realmGet$mSentAt.getTime(), (boolean)false);
            } else {
                Table.nativeSetNull((long)tableNativePtr, (long)columnInfo.mSentAtIndex, (long)rowIndex, (boolean)false);
            }
            Date realmGet$mReceivedAt = ((EventRealmProxyInterface)object).realmGet$mReceivedAt();
            if (realmGet$mReceivedAt != null) {
                Table.nativeSetTimestamp((long)tableNativePtr, (long)columnInfo.mReceivedAtIndex, (long)rowIndex, (long)realmGet$mReceivedAt.getTime(), (boolean)false);
            } else {
                Table.nativeSetNull((long)tableNativePtr, (long)columnInfo.mReceivedAtIndex, (long)rowIndex, (boolean)false);
            }
            Table.nativeSetLong((long)tableNativePtr, (long)columnInfo.mRetryCountIndex, (long)rowIndex, (long)((EventRealmProxyInterface)object).realmGet$mRetryCount(), (boolean)false);
            String realmGet$mStringClient = ((EventRealmProxyInterface)object).realmGet$mStringClient();
            if (realmGet$mStringClient != null) {
                Table.nativeSetString((long)tableNativePtr, (long)columnInfo.mStringClientIndex, (long)rowIndex, (String)realmGet$mStringClient, (boolean)false);
            } else {
                Table.nativeSetNull((long)tableNativePtr, (long)columnInfo.mStringClientIndex, (long)rowIndex, (boolean)false);
            }
            String realmGet$mStringContext = ((EventRealmProxyInterface)object).realmGet$mStringContext();
            if (realmGet$mStringContext != null) {
                Table.nativeSetString((long)tableNativePtr, (long)columnInfo.mStringContextIndex, (long)rowIndex, (String)realmGet$mStringContext, (boolean)false);
            } else {
                Table.nativeSetNull((long)tableNativePtr, (long)columnInfo.mStringContextIndex, (long)rowIndex, (boolean)false);
            }
            String realmGet$mStringProperties = ((EventRealmProxyInterface)object).realmGet$mStringProperties();
            if (realmGet$mStringProperties != null) {
                Table.nativeSetString((long)tableNativePtr, (long)columnInfo.mStringPropertiesIndex, (long)rowIndex, (String)realmGet$mStringProperties, (boolean)false);
                continue;
            }
            Table.nativeSetNull((long)tableNativePtr, (long)columnInfo.mStringPropertiesIndex, (long)rowIndex, (boolean)false);
        }
    }

    public static Event createDetachedCopy(Event realmObject, int currentDepth, int maxDepth, Map<RealmModel, RealmObjectProxy.CacheData<RealmModel>> cache) {
        Event unmanagedObject;
        if (currentDepth > maxDepth || realmObject == null) {
            return null;
        }
        RealmObjectProxy.CacheData<RealmModel> cachedObject = cache.get(realmObject);
        if (cachedObject == null) {
            unmanagedObject = new Event();
            cache.put(realmObject, (RealmObjectProxy.CacheData<RealmModel>)new RealmObjectProxy.CacheData(currentDepth, (RealmModel)unmanagedObject));
        } else {
            if (currentDepth >= cachedObject.minDepth) {
                return (Event)cachedObject.object;
            }
            unmanagedObject = (Event)cachedObject.object;
            cachedObject.minDepth = currentDepth;
        }
        EventRealmProxyInterface unmanagedCopy = unmanagedObject;
        EventRealmProxyInterface realmSource = realmObject;
        unmanagedCopy.realmSet$mVersion(realmSource.realmGet$mVersion());
        unmanagedCopy.realmSet$mId(realmSource.realmGet$mId());
        unmanagedCopy.realmSet$mType(realmSource.realmGet$mType());
        unmanagedCopy.realmSet$mRecordedAt(realmSource.realmGet$mRecordedAt());
        unmanagedCopy.realmSet$mSentAt(realmSource.realmGet$mSentAt());
        unmanagedCopy.realmSet$mReceivedAt(realmSource.realmGet$mReceivedAt());
        unmanagedCopy.realmSet$mRetryCount(realmSource.realmGet$mRetryCount());
        unmanagedCopy.realmSet$mStringClient(realmSource.realmGet$mStringClient());
        unmanagedCopy.realmSet$mStringContext(realmSource.realmGet$mStringContext());
        unmanagedCopy.realmSet$mStringProperties(realmSource.realmGet$mStringProperties());
        return unmanagedObject;
    }

    static Event update(Realm realm, Event realmObject, Event newObject, Map<RealmModel, RealmObjectProxy> cache) {
        EventRealmProxyInterface realmObjectTarget = realmObject;
        EventRealmProxyInterface realmObjectSource = newObject;
        realmObjectTarget.realmSet$mVersion(realmObjectSource.realmGet$mVersion());
        realmObjectTarget.realmSet$mType(realmObjectSource.realmGet$mType());
        realmObjectTarget.realmSet$mRecordedAt(realmObjectSource.realmGet$mRecordedAt());
        realmObjectTarget.realmSet$mSentAt(realmObjectSource.realmGet$mSentAt());
        realmObjectTarget.realmSet$mReceivedAt(realmObjectSource.realmGet$mReceivedAt());
        realmObjectTarget.realmSet$mRetryCount(realmObjectSource.realmGet$mRetryCount());
        realmObjectTarget.realmSet$mStringClient(realmObjectSource.realmGet$mStringClient());
        realmObjectTarget.realmSet$mStringContext(realmObjectSource.realmGet$mStringContext());
        realmObjectTarget.realmSet$mStringProperties(realmObjectSource.realmGet$mStringProperties());
        return realmObject;
    }

    public ProxyState<?> realmGet$proxyState() {
        return this.proxyState;
    }

    public int hashCode() {
        String realmName = this.proxyState.getRealm$realm().getPath();
        String tableName = this.proxyState.getRow$realm().getTable().getName();
        long rowIndex = this.proxyState.getRow$realm().getIndex();
        int result = 17;
        result = 31 * result + (realmName != null ? realmName.hashCode() : 0);
        result = 31 * result + (tableName != null ? tableName.hashCode() : 0);
        result = 31 * result + (int)(rowIndex ^ rowIndex >>> 32);
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        EventRealmProxy aEvent = (EventRealmProxy)o;
        String path = this.proxyState.getRealm$realm().getPath();
        String otherPath = aEvent.proxyState.getRealm$realm().getPath();
        if (path != null ? !path.equals(otherPath) : otherPath != null) {
            return false;
        }
        String tableName = this.proxyState.getRow$realm().getTable().getName();
        String otherTableName = aEvent.proxyState.getRow$realm().getTable().getName();
        if (tableName != null ? !tableName.equals(otherTableName) : otherTableName != null) {
            return false;
        }
        return this.proxyState.getRow$realm().getIndex() == aEvent.proxyState.getRow$realm().getIndex();
    }

    static {
        ArrayList<String> fieldNames = new ArrayList<String>(10);
        fieldNames.add("mVersion");
        fieldNames.add("mId");
        fieldNames.add("mType");
        fieldNames.add("mRecordedAt");
        fieldNames.add("mSentAt");
        fieldNames.add("mReceivedAt");
        fieldNames.add("mRetryCount");
        fieldNames.add("mStringClient");
        fieldNames.add("mStringContext");
        fieldNames.add("mStringProperties");
        FIELD_NAMES = Collections.unmodifiableList(fieldNames);
    }

    static final class EventColumnInfo
    extends ColumnInfo {
        long mVersionIndex;
        long mIdIndex;
        long mTypeIndex;
        long mRecordedAtIndex;
        long mSentAtIndex;
        long mReceivedAtIndex;
        long mRetryCountIndex;
        long mStringClientIndex;
        long mStringContextIndex;
        long mStringPropertiesIndex;

        EventColumnInfo(OsSchemaInfo schemaInfo) {
            super(10);
            OsObjectSchemaInfo objectSchemaInfo = schemaInfo.getObjectSchemaInfo("Event");
            this.mVersionIndex = this.addColumnDetails("mVersion", objectSchemaInfo);
            this.mIdIndex = this.addColumnDetails("mId", objectSchemaInfo);
            this.mTypeIndex = this.addColumnDetails("mType", objectSchemaInfo);
            this.mRecordedAtIndex = this.addColumnDetails("mRecordedAt", objectSchemaInfo);
            this.mSentAtIndex = this.addColumnDetails("mSentAt", objectSchemaInfo);
            this.mReceivedAtIndex = this.addColumnDetails("mReceivedAt", objectSchemaInfo);
            this.mRetryCountIndex = this.addColumnDetails("mRetryCount", objectSchemaInfo);
            this.mStringClientIndex = this.addColumnDetails("mStringClient", objectSchemaInfo);
            this.mStringContextIndex = this.addColumnDetails("mStringContext", objectSchemaInfo);
            this.mStringPropertiesIndex = this.addColumnDetails("mStringProperties", objectSchemaInfo);
        }

        EventColumnInfo(ColumnInfo src, boolean mutable) {
            super(src, mutable);
            this.copy(src, this);
        }

        protected final ColumnInfo copy(boolean mutable) {
            return new EventColumnInfo(this, mutable);
        }

        protected final void copy(ColumnInfo rawSrc, ColumnInfo rawDst) {
            EventColumnInfo src = (EventColumnInfo)rawSrc;
            EventColumnInfo dst = (EventColumnInfo)rawDst;
            dst.mVersionIndex = src.mVersionIndex;
            dst.mIdIndex = src.mIdIndex;
            dst.mTypeIndex = src.mTypeIndex;
            dst.mRecordedAtIndex = src.mRecordedAtIndex;
            dst.mSentAtIndex = src.mSentAtIndex;
            dst.mReceivedAtIndex = src.mReceivedAtIndex;
            dst.mRetryCountIndex = src.mRetryCountIndex;
            dst.mStringClientIndex = src.mStringClientIndex;
            dst.mStringContextIndex = src.mStringContextIndex;
            dst.mStringPropertiesIndex = src.mStringPropertiesIndex;
        }
    }
}

