/*
 * Decompiled with CFR 0.152.
 */
package com.shopgun.android.sdk.utils;

import android.graphics.Color;
import com.shopgun.android.materialcolorcreator.MaterialColor;
import com.shopgun.android.materialcolorcreator.MaterialColorImpl;
import com.shopgun.android.sdk.log.SgnLog;
import com.shopgun.android.sdk.model.Branding;
import com.shopgun.android.sdk.model.Catalog;
import com.shopgun.android.sdk.model.Country;
import com.shopgun.android.sdk.model.Dealer;
import com.shopgun.android.sdk.model.Dimension;
import com.shopgun.android.sdk.model.Images;
import com.shopgun.android.sdk.model.Links;
import com.shopgun.android.sdk.model.Offer;
import com.shopgun.android.sdk.model.Pageflip;
import com.shopgun.android.sdk.model.Permission;
import com.shopgun.android.sdk.model.Pieces;
import com.shopgun.android.sdk.model.Pricing;
import com.shopgun.android.sdk.model.Quantity;
import com.shopgun.android.sdk.model.Share;
import com.shopgun.android.sdk.model.Si;
import com.shopgun.android.sdk.model.Size;
import com.shopgun.android.sdk.model.Store;
import com.shopgun.android.sdk.model.Unit;
import com.shopgun.android.sdk.model.User;
import com.shopgun.android.sdk.model.interfaces.IJson;
import com.shopgun.android.sdk.utils.Constants;
import com.shopgun.android.sdk.utils.SgnUtils;
import com.shopgun.android.utils.TextUtils;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class SgnJson {
    public static final String TAG = Constants.getTag(SgnJson.class);
    public static final String API_DATE_FORMAT = "yyyy-MM-dd'T'HH:mm:ssZZZZ";
    private static final SimpleDateFormat DATE_FORMATTER = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ssZZZZ", Locale.US);
    private JSONObject mObject;
    private Stats mStats;
    public static final String STORE = "store";
    private static final String SDK_STORE = "sdk_store";
    public static final String CATALOG = "catalog";
    public static final String SDK_CATALOG = "sdk_catalog";
    public static final String OFFERS = "offers";
    public static final String DEALER = "dealer";
    private static final String SDK_DEALER = "sdk_dealer";
    public static final String ID = "id";
    public static final String ERN = "ern";
    public static final String NAME = "name";
    public static final String RUN_FROM = "run_from";
    public static final String RUN_TILL = "run_till";
    public static final String DEALER_ID = "dealer_id";
    public static final String DEALER_URL = "dealer_url";
    public static final String STORE_ID = "store_id";
    public static final String STORE_URL = "store_url";
    public static final String IMAGES = "images";
    public static final String BRANDING = "branding";
    public static final String MODIFIED = "modified";
    public static final String DESCRIPTION = "description";
    public static final String WEBSITE = "website";
    public static final String LOGO = "logo";
    public static final String COLOR = "color";
    public static final String PAGEFLIP = "pageflip";
    public static final String COUNTRY = "country";
    public static final String ACCESS = "access";
    public static final String LABEL = "label";
    public static final String BACKGROUND = "background";
    public static final String PAGE_COUNT = "page_count";
    public static final String FAVORITE_COUNT = "favorite_count";
    public static final String OFFER_COUNT = "offer_count";
    public static final String DIMENSIONS = "dimensions";
    public static final String PAGES = "pages";
    private static final String SDK_PAGES = "sdk_pages";
    public static final String PAGE = "page";
    public static final String OWNER = "owner";
    public static final String TICK = "tick";
    public static final String OFFER_ID = "offer_id";
    public static final String COUNT = "count";
    public static final String SHOPPINGLIST_ID = "shopping_list_id";
    public static final String CREATOR = "creator";
    public static final String HEADING = "heading";
    public static final String CATALOG_PAGE = "catalog_page";
    public static final String PRICING = "pricing";
    public static final String QUANTITY = "quantity";
    public static final String LINKS = "links";
    public static final String CATALOG_URL = "catalog_url";
    public static final String CATALOG_ID = "catalog_id";
    public static final String STREET = "street";
    public static final String CITY = "city";
    public static final String ZIP_CODE = "zip_code";
    public static final String LATITUDE = "latitude";
    public static final String LONGITUDE = "longitude";
    public static final String CONTACT = "contact";
    public static final String WEBSHOP = "webshop";
    public static final String WIDTH = "width";
    public static final String HEIGHT = "height";
    public static final String CODE = "code";
    public static final String MESSAGE = "message";
    public static final String DETAILS = "details";
    public static final String FAILED_ON_FIELD = "failed_on_field";
    public static final String VIEW = "view";
    public static final String ZOOM = "zoom";
    public static final String THUMB = "thumb";
    public static final String FROM = "from";
    public static final String TO = "to";
    public static final String UNIT = "unit";
    public static final String SIZE = "size";
    public static final String PIECES = "pieces";
    public static final String USER = "user";
    public static final String ACCEPTED = "accepted";
    public static final String SYMBOL = "symbol";
    public static final String GENDER = "gender";
    public static final String BIRTH_YEAR = "birth_year";
    public static final String EMAIL = "email";
    public static final String PERMISSIONS = "permissions";
    public static final String PREVIOUS_ID = "previous_id";
    public static final String SI = "si";
    public static final String FACTOR = "factor";
    public static final String UNSUBSCRIBE_PRINT_URL = "unsubscribe_print_url";
    public static final String TYPE = "type";
    public static final String META = "meta";
    public static final String SHARES = "shares";
    public static final String TOKEN = "token";
    public static final String EXPIRES = "expires";
    public static final String PROVIDER = "provider";
    public static final String PRICE = "price";
    public static final String PREPRICE = "pre_price";
    public static final String CURRENCY = "currency";
    public static final String LENGTH = "length";
    public static final String OFFSET = "offset";
    public static final String SUBJECT = "subject";
    public static final String ACCEPT_URL = "accept_url";
    public static final String PDF_URL = "pdf_url";
    public static final String CATEGORY_IDS = "category_ids";
    public static final String OFFER = "offer";
    public static final String LOCATIONS = "locations";
    public static final String CLIENT_ID = "client_id";
    public static final String REFERENCE = "reference";
    public static final String SUBSCRIBED = "subscribed";
    public static final String PAYLOAD = "payload";
    public static final String CATALOGS = "catalogs";
    public static final String PAYLOAD_TYPE = "payload_type";

    public SgnJson() {
        this(new JSONObject());
    }

    public SgnJson(JSONObject object) {
        this.mObject = object == null ? new JSONObject() : object;
        this.mStats = new Stats();
    }

    public JSONObject toJSON() {
        return this.mObject;
    }

    public boolean has(String key) {
        return this.mObject.has(key);
    }

    public boolean isErnType(String ernType, Class<?> clazz) {
        return this.hasErnType(ernType);
    }

    public void isErnTypeOrThrow(String ernType, Class<?> clazz) throws ErnTypeException {
        if (!this.isErnType(ernType, clazz)) {
            throw new ErnTypeException(ernType, clazz);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Date toDate(String date) {
        SimpleDateFormat simpleDateFormat = DATE_FORMATTER;
        synchronized (simpleDateFormat) {
            try {
                return DATE_FORMATTER.parse(date);
            }
            catch (Exception e) {
                return null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String toString(Date date) {
        SimpleDateFormat simpleDateFormat = DATE_FORMATTER;
        synchronized (simpleDateFormat) {
            try {
                return DATE_FORMATTER.format(date);
            }
            catch (NullPointerException e) {
                return null;
            }
        }
    }

    public boolean hasErnType(String type) {
        Ern e = new Ern(this.getErn());
        return e.getType() != null && e.getType().equals(type);
    }

    public Object get(String key) {
        return this.mObject.opt(key);
    }

    public Object get(String key, Object defValue) {
        try {
            this.mStats.logKey(key);
            return this.mObject.isNull(key) ? defValue : this.mObject.get(key);
        }
        catch (Exception e) {
            SgnLog.e(TAG, null, e);
            return defValue;
        }
    }

    public boolean getBoolean(String key) {
        return this.getBoolean(key, false);
    }

    public boolean getBoolean(String key, boolean defValue) {
        this.mStats.logKey(key);
        return this.mObject.optBoolean(key, defValue);
    }

    public double getDouble(String key) {
        return this.getDouble(key, 0.0);
    }

    public double getDouble(String key, double defValue) {
        this.mStats.logKey(key);
        return this.mObject.optDouble(key, defValue);
    }

    public float getFloat(String key) {
        return this.getFloat(key, 0.0f);
    }

    public float getFloat(String key, float defValue) {
        return (float)this.mObject.optDouble(key, (double)defValue);
    }

    public int getInt(String key) {
        return this.getInt(key, 0);
    }

    public int getInt(String key, int defValue) {
        try {
            this.mStats.logKey(key);
            return this.mObject.isNull(key) ? defValue : this.mObject.getInt(key);
        }
        catch (Exception e) {
            SgnLog.e(TAG, null, e);
            return defValue;
        }
    }

    public JSONArray getJSONArray(String key) {
        return this.getJSONArray(key, null);
    }

    public JSONArray getJSONArray(String key, JSONArray defValue) {
        try {
            this.mStats.logKey(key);
            return this.mObject.isNull(key) ? defValue : this.mObject.getJSONArray(key);
        }
        catch (Exception e) {
            SgnLog.e(TAG, null, e);
            return defValue;
        }
    }

    public JSONObject getJSONObject(String key) {
        return this.getJSONObject(key, null);
    }

    public JSONObject getJSONObject(String key, JSONObject defValue) {
        try {
            this.mStats.logKey(key);
            return this.mObject.isNull(key) ? defValue : this.mObject.getJSONObject(key);
        }
        catch (Exception e) {
            SgnLog.e(TAG, null, e);
            return defValue;
        }
    }

    public long getLong(String key) {
        return this.getLong(key, 0L);
    }

    public long getLong(String key, long defValue) {
        this.mStats.logKey(key);
        return this.mObject.optLong(key, defValue);
    }

    public String getString(String key) {
        return this.getString(key, null);
    }

    public String getString(String key, String defValue) {
        try {
            this.mStats.logKey(key);
            return this.mObject.isNull(key) ? defValue : this.mObject.getString(key);
        }
        catch (JSONException e) {
            SgnLog.e(TAG, e.getMessage(), e);
            return defValue;
        }
    }

    public Date getDate(String key) {
        return this.getDate(key, null);
    }

    public Date getDate(String key, Date defValue) {
        Date date = SgnJson.toDate(this.getString(key));
        return date == null ? defValue : date;
    }

    public int getColor(String key) {
        return this.getColor(key, -16777216);
    }

    public int getColor(String key, int defValue) {
        String rawColor = this.getString(key);
        if (rawColor != null) {
            try {
                if (rawColor.charAt(0) != '#') {
                    rawColor = '#' + rawColor;
                }
                return Color.parseColor((String)rawColor);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return defValue;
    }

    public MaterialColor getMaterialColor(String key) {
        return this.getMaterialColor(key, (MaterialColor)new MaterialColorImpl(-16777216));
    }

    public MaterialColor getMaterialColor(String key, MaterialColor defValue) {
        int color = this.getColor(key, -16777216);
        return color == -16777216 ? defValue : new MaterialColorImpl(color);
    }

    public SgnJson put(String key, String value) {
        try {
            this.mObject.put(key, SgnJson.putCheck(value));
        }
        catch (Exception e) {
            SgnLog.e(TAG, e.getMessage(), e);
        }
        return this;
    }

    public SgnJson put(String key, boolean value) {
        try {
            this.mObject.put(key, SgnJson.putCheck(value));
        }
        catch (Exception e) {
            SgnLog.e(TAG, e.getMessage(), e);
        }
        return this;
    }

    public SgnJson put(String key, double value) {
        try {
            this.mObject.put(key, SgnJson.putCheck(value));
        }
        catch (Exception e) {
            SgnLog.e(TAG, e.getMessage(), e);
        }
        return this;
    }

    public SgnJson put(String key, int value) {
        try {
            this.mObject.put(key, SgnJson.putCheck(value));
        }
        catch (Exception e) {
            SgnLog.e(TAG, e.getMessage(), e);
        }
        return this;
    }

    public SgnJson put(String key, long value) {
        try {
            this.mObject.put(key, SgnJson.putCheck(value));
        }
        catch (Exception e) {
            SgnLog.e(TAG, e.getMessage(), e);
        }
        return this;
    }

    public SgnJson put(String key, Object value) {
        try {
            this.mObject.put(key, SgnJson.putCheck(value));
        }
        catch (Exception e) {
            SgnLog.e(TAG, e.getMessage(), e);
        }
        return this;
    }

    public SgnJson putColor(String key, int value) {
        try {
            if (Color.alpha((int)value) != 255) {
                SgnLog.w(TAG, "ShopGun api doesn't support transparency. Transparency will be stripped.");
            }
            String color = String.format("%06X", 0xFFFFFF & value);
            this.mObject.put(key, SgnJson.putCheck(color));
        }
        catch (Exception e) {
            SgnLog.e(TAG, e.getMessage(), e);
        }
        return this;
    }

    public SgnJson putMaterialColor(String key, MaterialColor value) {
        try {
            if (value == null) {
                this.mObject.put(key, JSONObject.NULL);
            } else {
                this.putColor(key, value.getValue());
            }
        }
        catch (Exception e) {
            SgnLog.e(TAG, e.getMessage(), e);
        }
        return this;
    }

    public SgnJson putDate(String key, Date date) {
        this.put(key, SgnJson.toString(date));
        return this;
    }

    private SgnJson putIJsonIfNotNull(String key, IJson<JSONObject> object) {
        if (object != null) {
            this.put(key, object.toJSON());
        }
        return this;
    }

    private SgnJson putIJsonIfNotNull(String key, Collection<? extends IJson<JSONObject>> list) {
        if (list != null) {
            JSONArray a = new JSONArray();
            for (IJson<JSONObject> iJson : list) {
                a.put((Object)iJson.toJSON());
            }
            this.put(key, SgnJson.putCheck(a));
        }
        return this;
    }

    private SgnJson putIJson(String key, IJson<JSONObject> object) {
        this.put(key, SgnJson.putCheck(object));
        return this;
    }

    private SgnJson putIJson(String key, Collection<? extends IJson<JSONObject>> list) {
        if (list == null) {
            this.put(key, SgnJson.putCheck(null));
        } else {
            this.putIJsonIfNotNull(key, list);
        }
        return this;
    }

    private static <T> Object putCheck(T object) {
        if (object == null) {
            return JSONObject.NULL;
        }
        if (object instanceof IJson) {
            return ((IJson)object).toJSON();
        }
        return object;
    }

    public SgnJson putStore(Store store) {
        this.putIJsonIfNotNull(STORE, store);
        return this;
    }

    public Store getStore() {
        if (this.mObject.has(SDK_STORE)) {
            return Store.fromJSON(this.getJSONObject(SDK_STORE));
        }
        return Store.fromJSON(this.getJSONObject(STORE));
    }

    public SgnJson putCatalog(Catalog catalog) {
        this.putIJsonIfNotNull(CATALOG, catalog);
        return this;
    }

    public Catalog getCatalog() {
        if (this.mObject.has(SDK_CATALOG)) {
            return Catalog.fromJSON(this.getJSONObject(SDK_CATALOG));
        }
        return Catalog.fromJSON(this.getJSONObject(CATALOG));
    }

    public SgnJson putCatalogList(List<Catalog> catalogs) {
        this.putIJsonIfNotNull(CATALOGS, catalogs);
        return this;
    }

    public List<Catalog> getCatalogList() {
        JSONArray a = this.getJSONArray(CATALOGS);
        return a == null ? null : Catalog.fromJSON(a);
    }

    public SgnJson putOfferList(List<Offer> offers) {
        this.putIJsonIfNotNull(OFFERS, offers);
        return this;
    }

    public SgnJson putDealer(Dealer dealer) {
        this.putIJsonIfNotNull(DEALER, dealer);
        return this;
    }

    public Dealer getDealer() {
        if (this.mObject.has(SDK_DEALER)) {
            return Dealer.fromJSON(this.getJSONObject(SDK_DEALER));
        }
        return Dealer.fromJSON(this.getJSONObject(DEALER));
    }

    public List<Offer> getOfferList() {
        JSONArray a = this.getJSONArray(OFFERS);
        return a == null ? null : Offer.fromJSON(a);
    }

    public String getId() {
        return this.getString(ID);
    }

    public SgnJson setId(String value) {
        this.put(ID, value);
        return this;
    }

    public String getErn() {
        return this.getString(ERN);
    }

    public SgnJson setErn(String value) {
        this.put(ERN, value);
        return this;
    }

    public String getName() {
        return this.getString(NAME);
    }

    public SgnJson setName(String value) {
        this.put(NAME, value);
        return this;
    }

    public Date getRunFrom() {
        return this.getDate(RUN_FROM);
    }

    public SgnJson setRunFrom(Date value) {
        this.putDate(RUN_FROM, value);
        return this;
    }

    public Date getRunTill() {
        return this.getDate(RUN_TILL);
    }

    public SgnJson setRunTill(Date value) {
        this.putDate(RUN_TILL, value);
        return this;
    }

    public String getDealerId() {
        return this.getString(DEALER_ID);
    }

    public SgnJson setDealerId(String value) {
        this.put(DEALER_ID, value);
        return this;
    }

    public String getDealerUrl() {
        return this.getString(DEALER_URL);
    }

    public SgnJson setDealerUrl(String value) {
        this.put(DEALER_URL, value);
        return this;
    }

    public String getStoreId() {
        return this.getString(STORE_ID);
    }

    public SgnJson setStoreId(String value) {
        this.put(STORE_ID, value);
        return this;
    }

    public String getStoreUrl() {
        return this.getString(STORE_URL);
    }

    public SgnJson setStoreUrl(String value) {
        this.put(STORE_URL, value);
        return this;
    }

    public Images getImages() {
        return Images.fromJSON(this.getJSONObject(IMAGES));
    }

    public SgnJson setImages(Images value) {
        this.put(IMAGES, SgnJson.putCheck(value));
        return this;
    }

    public Branding getBranding() {
        return Branding.fromJSON(this.getJSONObject(BRANDING));
    }

    public SgnJson setBranding(Branding value) {
        this.put(BRANDING, SgnJson.putCheck(value));
        return this;
    }

    public Date getModified() {
        return this.getDate(MODIFIED, new Date(0L));
    }

    public SgnJson setModified(Date value) {
        this.putDate(MODIFIED, value);
        return this;
    }

    public String getDescription() {
        return this.getString(DESCRIPTION);
    }

    public SgnJson setDescription(String value) {
        this.put(DESCRIPTION, value);
        return this;
    }

    public String getWebsite() {
        return this.getString(WEBSITE);
    }

    public SgnJson setWebsite(String value) {
        this.put(WEBSITE, value);
        return this;
    }

    public String getLogo() {
        return this.getString(LOGO);
    }

    public SgnJson setLogo(String value) {
        this.put(LOGO, value);
        return this;
    }

    public int getColor() {
        return this.getColor(COLOR);
    }

    public SgnJson setColor(int value) {
        this.putColor(COLOR, value);
        return this;
    }

    public MaterialColor getMaterialColor() {
        return this.getMaterialColor(COLOR);
    }

    public SgnJson setMaterialColor(MaterialColor value) {
        this.putMaterialColor(COLOR, value);
        return this;
    }

    public Pageflip getPageflip() {
        return Pageflip.fromJSON(this.getJSONObject(PAGEFLIP));
    }

    public SgnJson setPageflip(Pageflip value) {
        this.put(PAGEFLIP, SgnJson.putCheck(value));
        return this;
    }

    public Country getCountry() {
        return Country.fromJSON(this.getJSONObject(COUNTRY));
    }

    public SgnJson setCountry(Country value) {
        this.put(COUNTRY, SgnJson.putCheck(value));
        return this;
    }

    public String getAccess() {
        return this.getString(ACCESS);
    }

    public SgnJson setAccess(String value) {
        this.put(ACCESS, value);
        return this;
    }

    public String getLabel() {
        return this.getString(LABEL);
    }

    public SgnJson setLabel(String value) {
        this.put(LABEL, value);
        return this;
    }

    public int getBackground() {
        return this.getColor(BACKGROUND);
    }

    public SgnJson setBackground(int value) {
        this.putColor(BACKGROUND, value);
        return this;
    }

    public SgnJson setBackground(MaterialColor value) {
        this.putMaterialColor(BACKGROUND, value);
        return this;
    }

    public int getPageCount() {
        return this.getInt(PAGE_COUNT);
    }

    public SgnJson setPagecount(int value) {
        this.put(PAGE_COUNT, value);
        return this;
    }

    public int getFavoriteCount() {
        return this.getInt(FAVORITE_COUNT);
    }

    public SgnJson setFavoriteCount(int value) {
        this.put(FAVORITE_COUNT, value);
        return this;
    }

    public int getOfferCount() {
        return this.getInt(OFFER_COUNT);
    }

    public SgnJson setOfferCount(int value) {
        this.put(OFFER_COUNT, value);
        return this;
    }

    public Dimension getDimensions() {
        return Dimension.fromJSON(this.getJSONObject(DIMENSIONS));
    }

    public SgnJson setDimensions(Dimension value) {
        this.put(DIMENSIONS, SgnJson.putCheck(value));
        return this;
    }

    public SgnJson putPages(List<Images> pages) {
        this.putIJsonIfNotNull(PAGES, pages);
        return this;
    }

    public List<Images> getPages() {
        JSONObject pages;
        Object o;
        if (this.mObject.has(SDK_PAGES)) {
            Images.fromJSON(this.getJSONArray(SDK_PAGES));
        }
        if ((o = this.mObject.opt(PAGES)) instanceof JSONObject ? (pages = this.getJSONObject(PAGES)).has(THUMB) && pages.has(VIEW) && pages.has(ZOOM) : o == null || o == JSONObject.NULL) {
            return null;
        }
        return Images.fromJSON(this.getJSONArray(PAGES));
    }

    public boolean getTick() {
        return this.getBoolean(TICK);
    }

    public SgnJson setTick(boolean value) {
        this.put(TICK, value);
        return this;
    }

    public String getOfferId() {
        return this.getString(OFFER_ID);
    }

    public SgnJson setOfferId(String value) {
        this.put(OFFER_ID, value);
        return this;
    }

    public int getCount() {
        return this.getInt(COUNT);
    }

    public SgnJson setCount(int value) {
        this.put(COUNT, value);
        return this;
    }

    public String getShoppingListId() {
        return this.getString(SHOPPINGLIST_ID);
    }

    public SgnJson setShoppingListId(String value) {
        this.put(SHOPPINGLIST_ID, value);
        return this;
    }

    public String getCreator() {
        return this.getString(CREATOR);
    }

    public SgnJson setCreator(String value) {
        this.put(CREATOR, value);
        return this;
    }

    public String getHeading() {
        return this.getString(HEADING);
    }

    public SgnJson setHeading(String value) {
        this.put(HEADING, value);
        return this;
    }

    public int getCatalogPage() {
        return this.getInt(CATALOG_PAGE);
    }

    public SgnJson setCatalogPage(int value) {
        this.put(CATALOG_PAGE, value);
        return this;
    }

    public Pricing getPricing() {
        return Pricing.fromJSON(this.getJSONObject(PRICING));
    }

    public SgnJson setPricing(Pricing value) {
        this.put(PRICING, SgnJson.putCheck(value));
        return this;
    }

    public Quantity getQuantity() {
        return Quantity.fromJSON(this.getJSONObject(QUANTITY));
    }

    public SgnJson setQuantity(Quantity value) {
        this.put(QUANTITY, SgnJson.putCheck(value));
        return this;
    }

    public Links getLinks() {
        return Links.fromJSON(this.getJSONObject(LINKS));
    }

    public SgnJson setLinks(Links value) {
        this.put(LINKS, SgnJson.putCheck(value));
        return this;
    }

    public String getCatalogUrl() {
        return this.getString(CATALOG_URL);
    }

    public SgnJson setCatalogUrl(String value) {
        this.put(CATALOG_URL, value);
        return this;
    }

    public String getCatalogId() {
        return this.getString(CATALOG_ID);
    }

    public SgnJson setCatalogId(String value) {
        this.put(CATALOG_ID, value);
        return this;
    }

    public String getStreet() {
        return this.getString(STREET);
    }

    public SgnJson setStreet(String value) {
        this.put(STREET, value);
        return this;
    }

    public String getCity() {
        return this.getString(CITY);
    }

    public SgnJson setCity(String value) {
        this.put(CITY, value);
        return this;
    }

    public String getZipCode() {
        return this.getString(ZIP_CODE);
    }

    public SgnJson setZipCode(String value) {
        this.put(ZIP_CODE, value);
        return this;
    }

    public double getLatitude() {
        return this.getDouble(LATITUDE);
    }

    public SgnJson setLatitude(double value) {
        this.put(LATITUDE, value);
        return this;
    }

    public double getLongitude() {
        return this.getDouble(LONGITUDE);
    }

    public SgnJson setLongitude(double value) {
        this.put(LONGITUDE, value);
        return this;
    }

    public String getContact() {
        return this.getString(CONTACT);
    }

    public SgnJson setContact(String value) {
        this.put(CONTACT, value);
        return this;
    }

    public String getWebshop() {
        return this.getString(WEBSHOP);
    }

    public SgnJson setWebshop(String value) {
        this.put(WEBSHOP, value);
        return this;
    }

    public double getWidth() {
        return this.getDouble(WIDTH);
    }

    public SgnJson setWidth(double value) {
        this.put(WIDTH, value);
        return this;
    }

    public double getHeight() {
        return this.getDouble(HEIGHT);
    }

    public SgnJson setHeight(double value) {
        this.put(HEIGHT, value);
        return this;
    }

    public String getView() {
        return this.getString(VIEW);
    }

    public SgnJson setView(String value) {
        this.put(VIEW, value);
        return this;
    }

    public String getZoom() {
        return this.getString(ZOOM);
    }

    public SgnJson setZoom(String value) {
        this.put(ZOOM, value);
        return this;
    }

    public String getThumb() {
        return this.getString(THUMB);
    }

    public SgnJson setThumb(String value) {
        this.put(THUMB, value);
        return this;
    }

    public double getFrom() {
        return this.getDouble(FROM, 1.0);
    }

    public SgnJson setFrom(double value) {
        this.put(FROM, value);
        return this;
    }

    public double getTo() {
        return this.getDouble(TO, 1.0);
    }

    public SgnJson setTo(double value) {
        this.put(TO, value);
        return this;
    }

    public Unit getUnit() {
        return Unit.fromJSON(this.getJSONObject(UNIT));
    }

    public SgnJson setUnit(Unit value) {
        this.put(UNIT, SgnJson.putCheck(value));
        return this;
    }

    public Size getSize() {
        return Size.fromJSON(this.getJSONObject(SIZE));
    }

    public SgnJson setSize(Size value) {
        this.put(SIZE, SgnJson.putCheck(value));
        return this;
    }

    public Pieces getPieces() {
        return Pieces.fromJSON(this.getJSONObject(PIECES));
    }

    public SgnJson setPieces(Pieces value) {
        this.put(PIECES, SgnJson.putCheck(value));
        return this;
    }

    public User getUser() {
        return User.fromJSON(this.getJSONObject(USER));
    }

    public SgnJson setUser(User value) {
        this.put(USER, SgnJson.putCheck(value == null || value.getUserId() == -1 ? null : value));
        return this;
    }

    public boolean getAccepted() {
        return this.getBoolean(ACCEPTED);
    }

    public SgnJson setAccepted(boolean value) {
        this.put(ACCEPTED, value);
        return this;
    }

    public String getSymbol() {
        return this.getString(SYMBOL);
    }

    public SgnJson setSymbol(String value) {
        this.put(SYMBOL, value);
        return this;
    }

    public String getGender() {
        return this.getString(GENDER);
    }

    public SgnJson setGender(String value) {
        this.put(GENDER, value);
        return this;
    }

    public int getBirthYear() {
        return this.getInt(BIRTH_YEAR);
    }

    public SgnJson setBirthYear(int value) {
        this.put(BIRTH_YEAR, value);
        return this;
    }

    public String getEmail() {
        return this.getString(EMAIL);
    }

    public SgnJson setEmail(String value) {
        this.put(EMAIL, value);
        return this;
    }

    public Permission getPermissions() {
        return Permission.fromJSON(this.getJSONObject(PERMISSIONS));
    }

    public SgnJson setPermissions(Permission value) {
        this.put(PERMISSIONS, SgnJson.putCheck(value));
        return this;
    }

    public String getPreviousId() {
        return this.getString(PREVIOUS_ID);
    }

    public SgnJson setPreviousId(String value) {
        this.put(PREVIOUS_ID, value);
        return this;
    }

    public Si getSi() {
        return Si.fromJSON(this.getJSONObject(SI));
    }

    public SgnJson setSi(Si value) {
        this.put(SI, SgnJson.putCheck(value));
        return this;
    }

    public double getFactor() {
        return this.getDouble(FACTOR, 1.0);
    }

    public SgnJson setFactor(double value) {
        this.put(FACTOR, value);
        return this;
    }

    public String getUnsubscribePrintUrl() {
        return this.getString(UNSUBSCRIBE_PRINT_URL);
    }

    public SgnJson setUnsubscribePrintUrl(String value) {
        this.put(UNSUBSCRIBE_PRINT_URL, value);
        return this;
    }

    public String getType() {
        return this.getString(TYPE);
    }

    public SgnJson setType(String value) {
        this.put(TYPE, value);
        return this;
    }

    public JSONObject getMeta() {
        return this.getJSONObject(META, new JSONObject());
    }

    public SgnJson setMeta(JSONObject value) {
        this.put(META, value);
        return this;
    }

    public Collection<Share> getShares() {
        return Share.fromJSON(this.getJSONArray(SHARES));
    }

    public SgnJson setShares(Collection<Share> value) {
        this.putIJson(SHARES, value);
        return this;
    }

    public String getToken() {
        return this.getString(TOKEN);
    }

    public SgnJson setToken(String value) {
        this.put(TOKEN, value);
        return this;
    }

    public Date getExpires() {
        return this.getDate(EXPIRES);
    }

    public SgnJson setExpires(Date value) {
        this.putDate(EXPIRES, value);
        return this;
    }

    public String getProvider() {
        return this.getString(PROVIDER);
    }

    public SgnJson setProvider(String value) {
        this.put(PROVIDER, value);
        return this;
    }

    public double getPrice() {
        return this.getDouble(PRICE, 1.0);
    }

    public SgnJson setPrice(double value) {
        this.put(PRICE, value);
        return this;
    }

    public Double getPrePrice() {
        try {
            return Double.valueOf(this.getString(PREPRICE));
        }
        catch (Exception e) {
            return null;
        }
    }

    public SgnJson setPrePrice(Double value) {
        this.put(PREPRICE, SgnJson.putCheck(value));
        return this;
    }

    public String getCurrency() {
        return this.getString(CURRENCY);
    }

    public SgnJson setCurrency(String value) {
        this.put(CURRENCY, value);
        return this;
    }

    public int getLength() {
        return this.getInt(LENGTH);
    }

    public SgnJson setLength(int value) {
        this.put(LENGTH, value);
        return this;
    }

    public int getOffset() {
        return this.getInt(OFFSET);
    }

    public SgnJson setOffset(int value) {
        this.put(OFFSET, value);
        return this;
    }

    public String getSubject() {
        return this.getString(SUBJECT);
    }

    public SgnJson setSubject(String value) {
        this.put(SUBJECT, value);
        return this;
    }

    public String getAcceptUrl() {
        return this.getString(ACCEPT_URL);
    }

    public SgnJson setAcceptUrl(String value) {
        this.put(ACCEPT_URL, value);
        return this;
    }

    public String getPdfUrl() {
        return this.getString(PDF_URL);
    }

    public SgnJson setPdfUrl(String value) {
        this.put(PDF_URL, value);
        return this;
    }

    public Set<String> getCategoryIds() {
        JSONArray json = this.getJSONArray(CATEGORY_IDS, new JSONArray());
        HashSet<String> cat = new HashSet<String>(json.length());
        for (int i = 0; i < json.length(); ++i) {
            try {
                cat.add(json.getString(i));
                continue;
            }
            catch (JSONException jSONException) {
                // empty catch block
            }
        }
        return cat;
    }

    public SgnJson setCategoryIds(Set<String> value) {
        this.put(CATEGORY_IDS, value == null ? new JSONArray() : new JSONArray(value));
        return this;
    }

    public String getClientId() {
        return this.getString(CLIENT_ID);
    }

    public SgnJson setClientId(String value) {
        this.put(CLIENT_ID, value);
        return this;
    }

    public String getReference() {
        return this.getString(REFERENCE);
    }

    public SgnJson setReference(String value) {
        this.put(REFERENCE, value);
        return this;
    }

    public boolean getSubscribed() {
        return this.getBoolean(SUBSCRIBED);
    }

    public SgnJson setSubscribed(boolean value) {
        this.put(SUBSCRIBED, value);
        return this;
    }

    public JSONObject getPayload() {
        return this.getJSONObject(PAYLOAD);
    }

    public SgnJson setPayload(JSONObject value) {
        this.put(PAYLOAD, SgnJson.putCheck(value));
        return this;
    }

    public String getPayloadType() {
        return this.getString(PAYLOAD_TYPE);
    }

    public SgnJson setPayloadType(String value) {
        this.put(PAYLOAD_TYPE, value);
        return this;
    }

    public Stats getStats() {
        return this.mStats;
    }

    public static int jsonArrayHashCode(JSONArray a) {
        try {
            return SgnJson.jsonArrayHashCodeInternal(a);
        }
        catch (JSONException e) {
            e.printStackTrace();
            return a.hashCode();
        }
    }

    private static int jsonArrayHashCodeInternal(JSONArray a) throws JSONException {
        if (a == null) {
            return 0;
        }
        int prime = 31;
        int result = 1;
        for (int i = 0; i < a.length(); ++i) {
            Object o = a.get(i);
            int hash = 0;
            hash = o instanceof JSONObject ? SgnJson.jsonObjectHashCode((JSONObject)o) : (o instanceof JSONArray ? SgnJson.jsonArrayHashCode((JSONArray)o) : (o == null ? 0 : o.hashCode()));
            result = 31 * result + hash;
        }
        return result;
    }

    public static boolean jsonArrayEquals(JSONArray one, JSONArray two) {
        try {
            return SgnJson.jsonEqualsInternal(one, two);
        }
        catch (JSONException e) {
            e.printStackTrace();
            return false;
        }
    }

    private static boolean jsonEqualsInternal(JSONArray one, JSONArray two) throws JSONException {
        if (one == null || two == null) {
            return one == two;
        }
        if (one.length() != two.length()) {
            return false;
        }
        HashSet<Integer> used = new HashSet<Integer>(two.length());
        block0: for (int i = 0; i < one.length(); ++i) {
            Object objOne = one.isNull(i) ? null : one.get(i);
            for (int j = 0; j < two.length(); ++j) {
                Object objTwo;
                if (used.contains(i)) continue;
                Object object = objTwo = two.isNull(j) ? null : two.get(j);
                if (objOne == null || objTwo == null) {
                    if (objOne == objTwo) {
                        used.add(j);
                        continue block0;
                    }
                    return false;
                }
                if (!SgnJson.isEqualJson(objOne, objTwo)) continue;
                used.add(j);
                continue block0;
            }
            return false;
        }
        return true;
    }

    public static int jsonObjectHashCode(JSONObject o) {
        try {
            return SgnJson.jsonObjectHashCodeInternal(o);
        }
        catch (JSONException e) {
            e.printStackTrace();
            return o.hashCode();
        }
    }

    private static int jsonObjectHashCodeInternal(JSONObject o) throws JSONException {
        if (o == null) {
            return 0;
        }
        ArrayList keys = new ArrayList();
        Iterator it = o.keys();
        while (it.hasNext()) {
            keys.add(it.next());
        }
        Collections.sort(keys);
        StringBuilder sb = new StringBuilder();
        int prime = 31;
        int result = 1;
        for (String key : keys) {
            Object tmp = o.get(key);
            if (tmp instanceof JSONObject) {
                result = 31 * result + SgnJson.jsonObjectHashCode((JSONObject)tmp);
                continue;
            }
            if (tmp instanceof JSONArray) {
                result = 31 * result + SgnJson.jsonArrayHashCode((JSONArray)tmp);
                continue;
            }
            sb.append(key).append(tmp);
        }
        result = 31 * result + sb.toString().hashCode();
        return result;
    }

    public static boolean jsonObjectEquals(JSONObject one, JSONObject two) {
        try {
            return SgnJson.jsonEqualsInternal(one, two);
        }
        catch (JSONException e) {
            e.printStackTrace();
            return false;
        }
    }

    private static boolean jsonEqualsInternal(JSONObject one, JSONObject two) throws JSONException {
        if (one == null || two == null) {
            return one == two;
        }
        if (one.length() != two.length()) {
            return false;
        }
        Iterator it = one.keys();
        while (it.hasNext()) {
            Object objTwo;
            String key = (String)it.next();
            if (!two.has(key)) {
                return false;
            }
            Object objOne = one.isNull(key) ? null : one.get(key);
            Object object = objTwo = two.isNull(key) ? null : two.get(key);
            if (objOne == null || objTwo == null) {
                if (objOne == objTwo) continue;
                return false;
            }
            if (SgnJson.isEqualJson(objOne, objTwo)) continue;
            return false;
        }
        return true;
    }

    private static boolean isEqualJson(Object one, Object two) {
        if (one instanceof JSONObject) {
            return two instanceof JSONObject && SgnJson.jsonObjectEquals((JSONObject)one, (JSONObject)two);
        }
        if (one instanceof JSONArray) {
            return two instanceof JSONArray && SgnJson.jsonArrayEquals((JSONArray)one, (JSONArray)two);
        }
        return one.equals(two);
    }

    public class Stats {
        private boolean mValidate = true;
        private String mIdentifier;
        private Set<String> mAccepted;
        private Set<String> mRejected;
        private Set<String> mIgnoreForgotten;
        private Set<String> mIgnoreRejected;

        public Stats() {
            int size = SgnJson.this.mObject.length();
            this.mIdentifier = SgnJson.this.mObject.optString(SgnJson.ERN);
            this.mAccepted = new HashSet<String>(size);
            this.mRejected = new HashSet<String>(size);
            this.mIgnoreForgotten = new HashSet<String>();
            this.mIgnoreRejected = new HashSet<String>();
        }

        public Set<String> getForgottenKeys() {
            List keys = SgnUtils.copyIterator(SgnJson.this.mObject.keys());
            HashSet<String> missing = new HashSet<String>(keys);
            missing.removeAll(this.mAccepted);
            missing.removeAll(this.mIgnoreForgotten);
            return missing;
        }

        public Set<String> getRejectedKeys() {
            HashSet<String> rejected = new HashSet<String>(this.mRejected);
            rejected.removeAll(this.mIgnoreRejected);
            return rejected;
        }

        private Stats logKey(String key) {
            if (this.mValidate) {
                if (SgnJson.this.mObject.has(key)) {
                    this.mAccepted.add(key);
                } else {
                    this.mRejected.add(key);
                }
            }
            return this;
        }

        public Stats ignoreForgottenKeys(String ... keys) {
            this.mIgnoreForgotten.addAll(Arrays.asList(keys));
            return this;
        }

        public Stats ignoreRejectedKeys(String ... keys) {
            this.mIgnoreRejected.addAll(Arrays.asList(keys));
            return this;
        }

        public void log(String tag) {
            if (!this.mValidate) {
                return;
            }
            this.log(tag, "forgotten", this.getForgottenKeys());
            this.log(tag, "rejected", this.getRejectedKeys());
        }

        private void log(String tag, String type, Set<String> keys) {
            if (!keys.isEmpty()) {
                String text = String.format("%s %s: %s", this.mIdentifier, type, TextUtils.join((CharSequence)", ", keys));
                SgnLog.d(tag, text.trim());
            }
        }
    }

    private class Ern {
        private String mType;
        private String mId;

        public Ern(String type, String id2) {
            this.mType = type;
            this.mId = id2;
        }

        public Ern(String ern) {
            if (ern.startsWith(SgnJson.ERN)) {
                String[] split = ern.split(":");
                StringBuilder sb = new StringBuilder();
                for (int i = 1; i <= split.length - 2; ++i) {
                    if (sb.length() > 0) {
                        sb.append(":");
                    }
                    sb.append(split[i]);
                }
                this.mType = sb.toString();
                this.mId = split[split.length - 1];
            }
        }

        public String getType() {
            return this.mType;
        }

        public void setType(String type) {
            this.mType = type;
        }

        public String getId() {
            return this.mId;
        }

        public void setId(String id2) {
            this.mId = id2;
        }

        public String toString() {
            return String.format("ern:%s:%s", this.mType, this.mId);
        }
    }

    public static class ErnTypeException
    extends RuntimeException {
        public ErnTypeException(String ernType, Class<?> clazz) {
            super(String.format("Ern:type '%s' cannot be parsed to '%s'", ernType, clazz.getSimpleName()));
        }
    }
}

