/*
 * Decompiled with CFR 0.152.
 */
package com.shopgun.android.sdk.utils;

import com.shopgun.android.sdk.model.Share;
import com.shopgun.android.sdk.model.Shoppinglist;
import com.shopgun.android.sdk.model.User;
import com.shopgun.android.sdk.utils.Constants;
import java.util.List;

public class PermissionUtils {
    public static final String TAG = Constants.getTag(PermissionUtils.class);
    public static final String ERROR_MISSING_PERMISSION = "User doesn't have edit permissions, reason: %s";

    public static void allowEditOrThrow(Shoppinglist sl, User user) {
        PermissionUtils.allowEditOrThrow(sl, user.getEmail());
    }

    public static void allowEditOrThrow(Shoppinglist sl, String email) {
        if (!PermissionUtils.allowEdit(sl, email)) {
            String reason = PermissionUtils.getReasonForNotAllowEdit(sl, email);
            String message = String.format(ERROR_MISSING_PERMISSION, reason);
            throw new IllegalArgumentException(message);
        }
    }

    public static void allowEditOrThrow(Shoppinglist sl, Share share) {
        if (!PermissionUtils.allowEdit(sl, share)) {
            String reason = PermissionUtils.getReasonForNotAllowEdit(sl, share);
            String message = String.format(ERROR_MISSING_PERMISSION, reason);
            throw new IllegalArgumentException(message);
        }
    }

    public static void allowEditOrThrow(String shoppinglistId, Share share) {
        if (!PermissionUtils.allowEdit(shoppinglistId, share)) {
            String reason = PermissionUtils.getReasonForNotAllowEdit(shoppinglistId, share);
            String message = String.format(ERROR_MISSING_PERMISSION, reason);
            throw new IllegalArgumentException(message);
        }
    }

    public static void allowEditOrThrow(List<Shoppinglist> list, User user) {
        if (!PermissionUtils.allowEdit(list, user)) {
            String reason = PermissionUtils.getReasonForNotAllowEdit(list, user);
            String message = String.format(ERROR_MISSING_PERMISSION, reason);
            throw new IllegalArgumentException(message);
        }
    }

    public static boolean allowEdit(List<Shoppinglist> list, User user) {
        if (list == null || user == null) {
            return false;
        }
        for (Shoppinglist sl : list) {
            if (PermissionUtils.allowEdit(sl, user)) continue;
            return false;
        }
        return true;
    }

    public static boolean allowEdit(Shoppinglist sl, User user) {
        return sl != null && sl.getShares() != null && user != null && PermissionUtils.allowEdit(sl.getId(), sl.getShares().get(user.getEmail()));
    }

    public static boolean allowEdit(Shoppinglist sl, String email) {
        return sl != null && sl.getShares() != null && PermissionUtils.allowEdit(sl.getId(), sl.getShares().get(email));
    }

    public static boolean allowEdit(Shoppinglist sl, Share share) {
        return sl != null && PermissionUtils.allowEdit(sl.getId(), share);
    }

    public static boolean allowEdit(String shoppinglistId, Share share) {
        if (share == null || shoppinglistId == null) {
            return false;
        }
        if (!shoppinglistId.equals(share.getShoppinglistId())) {
            return false;
        }
        return PermissionUtils.hasWritePermission(share);
    }

    private static boolean hasWritePermission(Share share) {
        boolean owner = "owner".equals(share.getAccess());
        boolean rw = "rw".equals(share.getAccess());
        return owner || rw;
    }

    public static String getReasonForNotAllowEdit(List<Shoppinglist> list, User user) {
        if (list == null) {
            return "list == null";
        }
        if (user == null) {
            return "user == null";
        }
        for (Shoppinglist sl : list) {
            if (PermissionUtils.allowEdit(sl, user)) continue;
            return PermissionUtils.getReasonForNotAllowEdit(sl, user);
        }
        return "Unknown reason";
    }

    public static String getReasonForNotAllowEdit(Shoppinglist sl, User user) {
        return PermissionUtils.getReasonForNotAllowEdit(sl, user.getEmail());
    }

    public static String getReasonForNotAllowEdit(Shoppinglist sl, Share share) {
        if (sl == null) {
            return "Shoppinglist == null";
        }
        return PermissionUtils.getReasonForNotAllowEdit(sl.getId(), share);
    }

    public static String getReasonForNotAllowEdit(Shoppinglist sl, String email) {
        if (sl == null) {
            return "Shoppinglist == null";
        }
        if (sl.getShares() == null) {
            return "Shoppinglist does not contain any shares (Shoppinglist.getShares() == null)";
        }
        return PermissionUtils.getReasonForNotAllowEdit(sl.getId(), sl.getShares().get(email));
    }

    public static String getReasonForNotAllowEdit(String shoppinglistId, Share share) {
        if (share == null) {
            return "Share == null";
        }
        if (shoppinglistId == null) {
            return "Shoppinglist.id == null";
        }
        if (!shoppinglistId.equals(share.getShoppinglistId())) {
            return "Shoppinglist.id != Share.getShoppinglistId()";
        }
        if (!PermissionUtils.hasWritePermission(share)) {
            String f = "Share (%s) does not have write permissions (access == %s)";
            return String.format(f, share.getEmail(), share.getAccess());
        }
        return "Unknown reason";
    }
}

