/*
 * Decompiled with CFR 0.152.
 */
package com.shopgun.android.sdk.utils;

import android.annotation.SuppressLint;
import android.annotation.TargetApi;
import android.app.ActivityManager;
import android.content.Context;
import android.os.Build;
import com.shopgun.android.sdk.utils.Constants;

public class Device {
    public static final String TAG = Constants.getTag(Device.class);
    public static final long KB = 1024L;
    public static final long MB = 0x100000L;

    @SuppressLint(value={"NewApi"})
    public static String getRadio() {
        try {
            return Build.VERSION.SDK_INT < 14 ? Build.RADIO : Build.getRadioVersion();
        }
        catch (Exception e) {
            return "";
        }
    }

    public static String getBuildVersion() {
        return Build.VERSION.RELEASE;
    }

    public static String getKernel() {
        return System.getProperty("os.version");
    }

    public static String getModel() {
        String model = Build.MODEL;
        String manufacturer = Build.MANUFACTURER;
        model = model.startsWith(manufacturer) ? Device.capitalize(model) : Device.capitalize(manufacturer) + " " + model;
        return model;
    }

    private static String capitalize(String s) {
        if (s == null || s.length() == 0) {
            return "";
        }
        char first = s.charAt(0);
        if (Character.isUpperCase(first)) {
            return s;
        }
        return Character.toUpperCase(first) + s.substring(1);
    }

    public static String getDeviceInfo() {
        String format = "Device[model:%s, android:%s, baseBand:%s, kernel:%s]";
        return String.format(format, Device.getModel(), Device.getBuildVersion(), Device.getRadio(), Device.getKernel());
    }

    @TargetApi(value=11)
    public static boolean hasLargeHeap(Context c) {
        return (c.getApplicationInfo().flags & 0x100000) != 0;
    }

    @TargetApi(value=11)
    public static String getHeapInfo(Context c) {
        StringBuilder sb = new StringBuilder();
        Runtime rt = Runtime.getRuntime();
        long free = rt.freeMemory() / 0x100000L;
        long available = rt.totalMemory() / 0x100000L;
        long max = rt.maxMemory() / 0x100000L;
        String format = "Heap[max %smb - currently %smb free, %smb allocated";
        sb.append(String.format(format, max, free, available));
        sb.append(", LargeHeap: ").append(Device.hasLargeHeap(c));
        if (Device.hasLargeHeap(c)) {
            ActivityManager am = (ActivityManager)c.getSystemService("activity");
            try {
                int largeMem = am.getLargeMemoryClass();
                sb.append("(").append(largeMem).append(")");
            }
            catch (Throwable t) {
                sb.append("NoInfo");
            }
        }
        return sb.append("]").toString();
    }
}

