/*
 * Decompiled with CFR 0.152.
 */
package com.shopgun.android.sdk.shoppinglists;

import android.app.Activity;
import android.content.Context;
import android.os.Handler;
import android.os.HandlerThread;
import android.os.Looper;
import com.shopgun.android.sdk.ShopGun;
import com.shopgun.android.sdk.api.Endpoints;
import com.shopgun.android.sdk.bus.SessionEvent;
import com.shopgun.android.sdk.bus.SgnBus;
import com.shopgun.android.sdk.bus.ShoppinglistEvent;
import com.shopgun.android.sdk.corekit.LifecycleManager;
import com.shopgun.android.sdk.database.SgnDatabase;
import com.shopgun.android.sdk.log.SgnLog;
import com.shopgun.android.sdk.model.Share;
import com.shopgun.android.sdk.model.Shoppinglist;
import com.shopgun.android.sdk.model.ShoppinglistItem;
import com.shopgun.android.sdk.model.User;
import com.shopgun.android.sdk.network.Delivery;
import com.shopgun.android.sdk.network.Request;
import com.shopgun.android.sdk.network.Response;
import com.shopgun.android.sdk.network.ShopGunError;
import com.shopgun.android.sdk.network.impl.HandlerDelivery;
import com.shopgun.android.sdk.network.impl.JsonArrayRequest;
import com.shopgun.android.sdk.network.impl.JsonObjectRequest;
import com.shopgun.android.sdk.shoppinglists.ItemListener;
import com.shopgun.android.sdk.shoppinglists.JSONObjectListener;
import com.shopgun.android.sdk.shoppinglists.ListArrayListener;
import com.shopgun.android.sdk.shoppinglists.ListObjectListener;
import com.shopgun.android.sdk.shoppinglists.ShareListener;
import com.shopgun.android.sdk.shoppinglists.SyncDebugger;
import com.shopgun.android.sdk.shoppinglists.SyncInterval;
import com.shopgun.android.sdk.shoppinglists.SyncLog;
import com.shopgun.android.sdk.utils.Constants;
import com.shopgun.android.sdk.utils.ListUtils;
import com.shopgun.android.sdk.utils.PermissionUtils;
import com.shopgun.android.sdk.utils.SgnUtils;
import com.shopgun.android.utils.ConnectivityUtils;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Stack;
import org.greenrobot.eventbus.Subscribe;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class SyncManager {
    public static final String TAG = Constants.getTag(SyncManager.class);
    private static final boolean SAVE_NETWORK_LOG = false;
    private final Object RESUME_LOCK = new Object();
    private final Stack<Request<?>> mCurrentRequests = new Stack();
    private int mSyncInterval = Integer.MIN_VALUE;
    private SyncLooper mSyncLooper;
    private ShopGun mShopGun;
    private SgnDatabase mDatabase;
    private Handler mHandler;
    private boolean mMigrateOfflineLists = false;
    private Object mRequestTag = new Object();
    private ShoppinglistEvent.Builder mBuilder = new ShoppinglistEvent.Builder(true);
    private Delivery mDelivery;

    public SyncManager(ShopGun shopGun, SgnDatabase db) {
        this.mShopGun = shopGun;
        this.mShopGun.getLifecycleManager().registerCallback(new LifecycleCallback());
        this.mDatabase = db;
        this.mSyncLooper = new SyncLooper();
        HandlerThread thread = new HandlerThread(TAG, 10);
        thread.start();
        this.mHandler = new Handler(thread.getLooper());
        this.mDelivery = new HandlerDelivery(this.mHandler);
    }

    @Subscribe
    public void onEvent(SessionEvent e) {
        if (e.isNewUser()) {
            this.mSyncLooper.restart();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isPaused() {
        Object object = this.RESUME_LOCK;
        synchronized (object) {
            return this.getSyncInterval() == SyncInterval.PAUSED;
        }
    }

    public boolean hasFirstSync() {
        return this.mSyncLooper.mSyncCount > 0;
    }

    public void forceSync() {
        this.mSyncLooper.forceSync();
    }

    public void setSyncInterval(int time) {
        if (time != SyncInterval.SLOW && time != SyncInterval.MEDIUM && time != SyncInterval.FAST && time != SyncInterval.PAUSED) {
            throw new IllegalArgumentException("The sync time must be one of SyncManager.SyncInterval");
        }
        this.mSyncInterval = time;
        this.mSyncLooper.forceSync();
    }

    public int getSyncInterval() {
        return this.mSyncInterval == Integer.MIN_VALUE ? SyncInterval.PAUSED : this.mSyncInterval;
    }

    public void setMigrateOfflineLists(boolean migrate) {
        this.mMigrateOfflineLists = migrate;
    }

    public boolean isMigratingOfflineLists() {
        return this.mMigrateOfflineLists;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addRequest(Request<?> r) {
        r.setIgnoreCache(true);
        Stack<Request<?>> stack = this.mCurrentRequests;
        synchronized (stack) {
            this.mCurrentRequests.add(r);
        }
        r.setDelivery(this.mDelivery);
        r.setTag(this.mRequestTag);
        r.setDebugger(new SyncDebugger(SyncDebugger.TAG).setSkipMethods(Request.Method.GET));
        this.mShopGun.add(r);
    }

    private void popRequest() {
        this.popRequestAndPostShoppinglistEvent();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void popRequestAndPostShoppinglistEvent() {
        Stack<Request<?>> stack = this.mCurrentRequests;
        synchronized (stack) {
            try {
                this.mCurrentRequests.pop();
            }
            catch (Exception e) {
                SgnLog.e(TAG, e.getMessage(), e);
            }
        }
        boolean bl = this.mBuilder.firstSync = this.mSyncLooper.mSyncCount == 1;
        if (this.mCurrentRequests.isEmpty() && !this.isPaused() && this.mBuilder.hasChanges()) {
            final ShoppinglistEvent e = this.mBuilder.build();
            this.mBuilder = new ShoppinglistEvent.Builder(true);
            new Handler(Looper.getMainLooper()).post(new Runnable(){

                @Override
                public void run() {
                    SgnBus.getInstance().post((Object)e);
                }
            });
        }
    }

    private void syncListsModifiedTimestamp(SgnDatabase database, User user) {
        List<Shoppinglist> lists = database.getLists(user);
        Iterator<Shoppinglist> it = lists.iterator();
        while (it.hasNext()) {
            Shoppinglist sl = it.next();
            if (sl.getState() == 1) {
                it.remove();
            }
            if (sl.getState() == 0) {
                this.addRequest(new ItemSyncRequest(database, sl, user));
                it.remove();
            }
            sl.setState(1);
        }
        database.insertLists(lists, user);
        for (Shoppinglist sl : lists) {
            this.addRequest(new ListModifiedRequest(database, user, sl));
        }
    }

    private boolean syncLocalListChanges(SgnDatabase database, List<Shoppinglist> lists, User user) {
        int count = lists.size();
        block5: for (Shoppinglist sl : lists) {
            switch (sl.getState()) {
                case 0: {
                    this.addRequest(new ListPutRequest(database, user, sl));
                    continue block5;
                }
                case 4: {
                    this.addRequest(new ListDelRequest(database, user, sl));
                    continue block5;
                }
                case 5: {
                    this.addRequest(new ListRevertRequest(database, user, sl));
                    continue block5;
                }
            }
            --count;
        }
        return count != 0;
    }

    private boolean syncLocalItemChanges(SgnDatabase database, Shoppinglist sl, User user) {
        List<ShoppinglistItem> items = database.getItems(sl, user, true);
        int count = items.size();
        block5: for (ShoppinglistItem item : items) {
            switch (item.getState()) {
                case 0: {
                    this.addRequest(new ItemPutRequest(database, user, item));
                    continue block5;
                }
                case 4: {
                    this.addRequest(new ItemDelRequest(database, user, item));
                    continue block5;
                }
                case 5: {
                    this.addRequest(new ItemRevertRequest(database, user, item));
                    continue block5;
                }
            }
            --count;
        }
        return count != 0;
    }

    private boolean syncLocalShareChanges(SgnDatabase database, Shoppinglist sl, User user) {
        List<Share> shares = database.getShares(sl, user, true);
        int count = shares.size();
        block5: for (Share s : shares) {
            if (s.isAccessOwner()) {
                if (s.getState() == 4) {
                    database.deleteShare(s, user);
                    SgnLog.v(TAG, "API doesn't allow owner to be 'deleted'. Deleting from own DB and ignoring.");
                } else if (s.getState() != 2) {
                    s.setState(2);
                    s.setShoppinglistId(sl.getId());
                    database.editShare(s, user);
                    SgnLog.v(TAG, "Owner cannot be edited. Resetting share.state and ignoring.");
                }
                --count;
                continue;
            }
            switch (s.getState()) {
                case 0: {
                    this.addRequest(new SharePutRequest(database, user, s));
                    continue block5;
                }
                case 4: {
                    this.addRequest(new ShareDelRequest(database, user, s));
                    continue block5;
                }
                case 5: {
                    this.addRequest(new ShareRevertRequest(database, user, s));
                    continue block5;
                }
            }
            --count;
        }
        return count != 0;
    }

    private void mergeListsToDbAndFetchItems(SgnDatabase database, List<Shoppinglist> serverList, List<Shoppinglist> localList, User user) {
        if (serverList.isEmpty() && localList.isEmpty()) {
            return;
        }
        HashMap<String, Shoppinglist> localMap = new HashMap<String, Shoppinglist>();
        HashMap<String, Shoppinglist> serverMap = new HashMap<String, Shoppinglist>();
        HashSet union = new HashSet();
        for (Shoppinglist sl : localList) {
            localMap.put(sl.getId(), sl);
        }
        for (Shoppinglist sl : serverList) {
            serverMap.put(sl.getId(), sl);
        }
        union.addAll(serverMap.keySet());
        union.addAll(localMap.keySet());
        for (String key : union) {
            if (localMap.containsKey(key)) {
                Shoppinglist localSl = (Shoppinglist)localMap.get(key);
                if (serverMap.containsKey(key)) {
                    Shoppinglist serverSl = (Shoppinglist)serverMap.get(key);
                    if (!localSl.getModified().before(serverSl.getModified())) continue;
                    serverSl.setState(2);
                    this.mBuilder.edit(serverSl);
                    database.editList(serverSl, user);
                    database.cleanShares(serverSl, user);
                    continue;
                }
                this.mBuilder.del(localSl);
                for (ShoppinglistItem sli : database.getItems(localSl, user)) {
                    this.mBuilder.del(sli);
                }
                database.deleteItems(localSl.getId(), null, user);
                database.deleteList(localSl, user);
                continue;
            }
            Shoppinglist add = (Shoppinglist)serverMap.get(key);
            add.setState(0);
            this.mBuilder.add(add);
            database.insertList(add, user);
        }
        for (Shoppinglist sl : this.mBuilder.getAddedLists()) {
            this.addRequest(new ItemSyncRequest(database, sl, user));
        }
        for (Shoppinglist sl : this.mBuilder.getEditedLists()) {
            this.addRequest(new ItemSyncRequest(database, sl, user));
        }
    }

    private void mergeItemsToDb(SgnDatabase database, List<ShoppinglistItem> serverItems, List<ShoppinglistItem> localItems, User user) {
        if (serverItems.isEmpty() && localItems.isEmpty()) {
            return;
        }
        HashMap<String, ShoppinglistItem> localMap = new HashMap<String, ShoppinglistItem>();
        HashMap<String, ShoppinglistItem> serverMap = new HashMap<String, ShoppinglistItem>();
        HashSet union = new HashSet();
        for (ShoppinglistItem sli : localItems) {
            localMap.put(sli.getId(), sli);
        }
        for (ShoppinglistItem sli : serverItems) {
            serverMap.put(sli.getId(), sli);
        }
        union.addAll(serverMap.keySet());
        union.addAll(localMap.keySet());
        for (String key : union) {
            if (localMap.containsKey(key)) {
                ShoppinglistItem localSli = (ShoppinglistItem)localMap.get(key);
                if (serverMap.containsKey(key)) {
                    ShoppinglistItem serverSli = (ShoppinglistItem)serverMap.get(key);
                    if (localSli.getModified().before(serverSli.getModified())) {
                        this.mBuilder.edit(serverSli);
                        database.editItems(serverSli, user);
                        continue;
                    }
                    if (!localSli.getMeta().toString().equals(serverSli.getMeta().toString())) {
                        this.mBuilder.edit(serverSli);
                        database.editItems(serverSli, user);
                        continue;
                    }
                    if (!localSli.equals(serverSli)) continue;
                    SgnLog.d(TAG, "We have a mismatch");
                    continue;
                }
                ShoppinglistItem delSli = (ShoppinglistItem)localMap.get(key);
                if (delSli.getState() == 0) continue;
                this.mBuilder.del(delSli);
                database.deleteItem(delSli, user);
                continue;
            }
            ShoppinglistItem serverSli = (ShoppinglistItem)serverMap.get(key);
            this.mBuilder.add(serverSli);
            database.insertItem(serverSli, user);
        }
    }

    private class ShareRevertListener
    extends ShareListener {
        private ShareRevertListener(SgnDatabase database, User user, Share local) {
            super(database, user, local);
        }

        @Override
        public void onSuccess(Share response) {
            response.setState(2);
            response.setShoppinglistId(((Share)this.mLocalCopy).getShoppinglistId());
            this.mDatabase.editShare(response, this.mUser);
            Shoppinglist sl = this.mDatabase.getList(response.getShoppinglistId(), this.mUser);
            if (sl != null) {
                sl.removeShare(response);
                SyncManager.this.mBuilder.edit(sl);
                SyncManager.this.popRequestAndPostShoppinglistEvent();
            } else {
                SyncManager.this.popRequest();
            }
        }

        @Override
        public void onError(ShopGunError error) {
            this.mDatabase.deleteShare((Share)this.mLocalCopy, this.mUser);
            SyncManager.this.popRequest();
        }
    }

    private class ShareRevertRequest
    extends JsonObjectRequest {
        private ShareRevertRequest(SgnDatabase database, User user, Share share) {
            super(Endpoints.listShareEmail(user.getUserId(), share.getShoppinglistId(), share.getEmail()), new ShareRevertListener(database, user, share));
            if (share.getState() != 5) {
                share.setState(5);
                database.editShare(share, user);
            }
        }
    }

    private class ShareDelListener
    extends ShareListener {
        private ShareDelListener(SgnDatabase database, User user, Share local) {
            super(database, user, local);
        }

        @Override
        public void onSuccess(Share response) {
            if (this.mUser.getEmail().equals(((Share)this.mLocalCopy).getEmail())) {
                this.mDatabase.deleteList(((Share)this.mLocalCopy).getShoppinglistId(), this.mUser);
                this.mDatabase.deleteItems(((Share)this.mLocalCopy).getShoppinglistId(), null, this.mUser);
                this.mDatabase.deleteShares(((Share)this.mLocalCopy).getShoppinglistId(), this.mUser);
            } else {
                this.mDatabase.deleteShare((Share)this.mLocalCopy, this.mUser);
            }
            SyncManager.this.popRequest();
        }

        @Override
        public void onError(ShopGunError error) {
            SyncManager.this.popRequest();
            switch (error.getCode()) {
                case 10200: {
                    break;
                }
                case 1501: {
                    this.mDatabase.deleteShare((Share)this.mLocalCopy, this.mUser);
                    break;
                }
                default: {
                    SyncManager.this.addRequest(new ShareRevertRequest(this.mDatabase, this.mUser, (Share)this.mLocalCopy));
                }
            }
        }
    }

    private class ShareDelRequest
    extends JsonObjectRequest {
        private ShareDelRequest(SgnDatabase database, User user, Share local) {
            super(Request.Method.DELETE, Endpoints.listShareEmail(user.getUserId(), local.getShoppinglistId(), local.getEmail()), (JSONObject)null, new ShareDelListener(database, user, local));
        }
    }

    private class SharePutListener
    extends ShareListener {
        private SharePutListener(SgnDatabase database, User user, Share share) {
            super(database, user, share);
        }

        @Override
        public void onSuccess(Share response) {
            response.setState(2);
            response.setShoppinglistId(((Share)this.mLocalCopy).getShoppinglistId());
            this.mDatabase.editShare(response, this.mUser);
            SyncManager.this.popRequest();
        }

        @Override
        public void onError(ShopGunError error) {
            if (error.getFailedOnField() != null) {
                this.mDatabase.deleteShare((Share)this.mLocalCopy, this.mUser);
                Shoppinglist sl = this.mDatabase.getList(((Share)this.mLocalCopy).getShoppinglistId(), this.mUser);
                if (sl != null) {
                    sl.removeShare((Share)this.mLocalCopy);
                    SyncManager.this.mBuilder.edit(sl);
                    SyncManager.this.popRequestAndPostShoppinglistEvent();
                } else {
                    SyncManager.this.popRequest();
                }
            } else {
                SyncManager.this.popRequest();
                SyncManager.this.addRequest(new ShareRevertRequest(this.mDatabase, this.mUser, (Share)this.mLocalCopy));
            }
        }
    }

    private class SharePutRequest
    extends JsonObjectRequest {
        private SharePutRequest(SgnDatabase database, User user, Share share) {
            super(Request.Method.PUT, Endpoints.listShareEmail(user.getUserId(), share.getShoppinglistId(), share.getEmail()), share.toJSON(), new SharePutListener(database, user, share));
            share.setState(1);
            database.editShare(share, user);
        }
    }

    private class ItemRevertListener
    extends ItemListener {
        private ItemRevertListener(SgnDatabase database, User user, ShoppinglistItem item) {
            super(database, user, item);
        }

        @Override
        public void onSuccess(ShoppinglistItem response) {
            response.setState(2);
            response.setPreviousId(response.getPreviousId() == null ? ((ShoppinglistItem)this.mLocalCopy).getPreviousId() : response.getPreviousId());
            SyncManager.this.mBuilder.edit(response);
        }

        @Override
        public void onError(ShopGunError error) {
            this.mDatabase.deleteItem((ShoppinglistItem)this.mLocalCopy, this.mUser);
            SyncManager.this.mBuilder.del((ShoppinglistItem)this.mLocalCopy);
        }

        @Override
        public void onComplete(JSONObject response, ShopGunError error) {
            List<ShoppinglistItem> items;
            super.onComplete(response, error);
            Shoppinglist sl = this.mDatabase.getList(((ShoppinglistItem)this.mLocalCopy).getShoppinglistId(), this.mUser);
            if (sl != null && !(items = this.mDatabase.getItems(sl, this.mUser, true)).isEmpty()) {
                Collections.sort(items, ShoppinglistItem.MODIFIED_DESCENDING);
                ShoppinglistItem newestItem = items.get(0);
                sl.setModified(newestItem.getModified());
                this.mDatabase.editList(sl, this.mUser);
                SyncManager.this.mBuilder.edit(sl);
            }
            SyncManager.this.popRequestAndPostShoppinglistEvent();
        }
    }

    private class ItemRevertRequest
    extends JsonObjectRequest {
        private ItemRevertRequest(SgnDatabase database, User user, ShoppinglistItem item) {
            super(Endpoints.listitem(user.getUserId(), item.getShoppinglistId(), item.getId()), new ItemRevertListener(database, user, item));
            if (item.getState() != 5) {
                item.setState(5);
                database.editItems(item, user);
            }
        }
    }

    private class ItemDelListener
    extends ItemListener {
        private ItemDelListener(SgnDatabase database, User user, ShoppinglistItem item) {
            super(database, user, item);
        }

        @Override
        public void onSuccess(ShoppinglistItem response) {
            this.mDatabase.deleteItem((ShoppinglistItem)this.mLocalCopy, this.mUser);
            SyncManager.this.popRequest();
        }

        @Override
        public void onError(ShopGunError error) {
            SyncManager.this.popRequest();
            switch (error.getCode()) {
                case 1501: {
                    this.mDatabase.deleteItem((ShoppinglistItem)this.mLocalCopy, this.mUser);
                    break;
                }
                case 10200: {
                    break;
                }
                default: {
                    SyncManager.this.addRequest(new ItemRevertRequest(this.mDatabase, this.mUser, (ShoppinglistItem)this.mLocalCopy));
                }
            }
        }
    }

    private class ItemDelRequest
    extends JsonObjectRequest {
        private ItemDelRequest(SgnDatabase database, User user, ShoppinglistItem item) {
            super(Request.Method.DELETE, Endpoints.listitem(user.getUserId(), item.getShoppinglistId(), item.getId()), (JSONObject)null, new ItemDelListener(database, user, item));
            this.getParameters().put("modified", SgnUtils.dateToString(item.getModified()));
        }
    }

    private class ItemPutListener
    extends ItemListener {
        private ItemPutListener(SgnDatabase database, User user, ShoppinglistItem item) {
            super(database, user, item);
        }

        @Override
        public void onSuccess(ShoppinglistItem response) {
            ShoppinglistItem local = this.mDatabase.getItem(((ShoppinglistItem)this.mLocalCopy).getId(), this.mUser);
            if (local != null && !local.getModified().equals(response.getModified())) {
                response.setState(2);
                if (response.getPreviousId() == null) {
                    response.setPreviousId(((ShoppinglistItem)this.mLocalCopy).getPreviousId());
                }
                this.mDatabase.editItems(response, this.mUser);
                SyncManager.this.mBuilder.edit(response);
            }
            SyncManager.this.popRequestAndPostShoppinglistEvent();
        }

        @Override
        public void onError(ShopGunError error) {
            SyncManager.this.popRequest();
            if (error.getCode() != 10200) {
                SyncManager.this.addRequest(new ItemRevertRequest(this.mDatabase, this.mUser, (ShoppinglistItem)this.mLocalCopy));
            }
        }
    }

    private class ItemPutRequest
    extends JsonObjectRequest {
        private ItemPutRequest(SgnDatabase database, User user, ShoppinglistItem item) {
            super(Request.Method.PUT, Endpoints.listitem(user.getUserId(), item.getShoppinglistId(), item.getId()), item.toJSON(), new ItemPutListener(database, user, item));
            item.setState(1);
            database.editItems(item, user);
        }
    }

    private class ListRevertListener
    extends ListObjectListener {
        private ListRevertListener(SgnDatabase database, User user, Shoppinglist local) {
            super(database, user, local);
        }

        @Override
        public void onComplete(JSONObject response, ShopGunError error) {
            super.onComplete(response, error);
            SyncManager.this.popRequestAndPostShoppinglistEvent();
        }

        @Override
        public void onSuccess(Shoppinglist response) {
            response.setState(2);
            response.setPreviousId(response.getPreviousId() == null ? ((Shoppinglist)this.mLocalCopy).getPreviousId() : response.getPreviousId());
            this.mDatabase.editList(response, this.mUser);
            SyncManager.this.mBuilder.add(response);
            SyncManager.this.syncLocalItemChanges(this.mDatabase, (Shoppinglist)this.mLocalCopy, this.mUser);
        }

        @Override
        public void onError(ShopGunError error) {
            if (error.getCode() != 10200) {
                this.mDatabase.deleteList((Shoppinglist)this.mLocalCopy, this.mUser);
                SyncManager.this.mBuilder.del((Shoppinglist)this.mLocalCopy);
            }
        }
    }

    private class ListRevertRequest
    extends JsonObjectRequest {
        private ListRevertRequest(SgnDatabase database, User user, Shoppinglist shoppinglist) {
            super(Endpoints.list(user.getUserId(), shoppinglist.getId()), new ListRevertListener(database, user, shoppinglist));
            if (shoppinglist.getState() != 5) {
                shoppinglist.setState(5);
                database.editList(shoppinglist, user);
            }
        }
    }

    private class ListDelListener
    extends ListObjectListener {
        private ListDelListener(SgnDatabase database, User user, Shoppinglist local) {
            super(database, user, local);
        }

        @Override
        public void onComplete(JSONObject response, ShopGunError error) {
            if (response != null) {
                this.onSuccess(null);
            } else {
                this.onError(error);
            }
        }

        @Override
        public void onSuccess(Shoppinglist response) {
            this.mDatabase.deleteList((Shoppinglist)this.mLocalCopy, this.mUser);
            this.mDatabase.deleteShares((Shoppinglist)this.mLocalCopy, this.mUser);
            this.mDatabase.deleteItems(((Shoppinglist)this.mLocalCopy).getId(), null, this.mUser);
            SyncManager.this.popRequest();
        }

        @Override
        public void onError(ShopGunError error) {
            SyncManager.this.popRequest();
            switch (error.getCode()) {
                case 1501: {
                    this.mDatabase.deleteList((Shoppinglist)this.mLocalCopy, this.mUser);
                    break;
                }
                case 10200: {
                    break;
                }
                default: {
                    SyncManager.this.addRequest(new ListRevertRequest(this.mDatabase, this.mUser, (Shoppinglist)this.mLocalCopy));
                }
            }
        }
    }

    private class ListDelRequest
    extends JsonObjectRequest {
        private ListDelRequest(SgnDatabase database, User user, Shoppinglist local) {
            super(Request.Method.DELETE, Endpoints.list(user.getUserId(), local.getId()), (JSONObject)null, new ListDelListener(database, user, local));
            this.getParameters().put("modified", SgnUtils.dateToString(local.getModified()));
        }
    }

    private class ListPutRequest
    extends JsonObjectRequest {
        private ListPutRequest(SgnDatabase database, User user, Shoppinglist shoppinglist) {
            super(Request.Method.PUT, Endpoints.list(user.getUserId(), shoppinglist.getId()), shoppinglist.toJSON(), new ListPutListener(database, user, shoppinglist));
            shoppinglist.setState(1);
            database.editList(shoppinglist, user);
        }
    }

    private class ListPutListener
    extends ListObjectListener {
        private ListPutListener(SgnDatabase database, User user, Shoppinglist shoppinglist) {
            super(database, user, shoppinglist);
        }

        @Override
        public void onError(ShopGunError error) {
            SyncManager.this.popRequest();
            switch (error.getCode()) {
                case 1501: {
                    this.mDatabase.deleteList((Shoppinglist)this.mLocalCopy, this.mUser);
                    break;
                }
                case 10200: {
                    break;
                }
                default: {
                    SyncManager.this.addRequest(new ListRevertRequest(this.mDatabase, this.mUser, (Shoppinglist)this.mLocalCopy));
                }
            }
        }

        @Override
        public void onSuccess(Shoppinglist response) {
            Shoppinglist localSl = this.mDatabase.getList(response.getId(), this.mUser);
            if (localSl != null && !response.getModified().equals(localSl.getModified())) {
                response.setState(2);
                response.setPreviousId(response.getPreviousId() == null ? ((Shoppinglist)this.mLocalCopy).getPreviousId() : response.getPreviousId());
                this.mDatabase.editList(response, this.mUser);
                SyncManager.this.mBuilder.edit(response);
            }
            SyncManager.this.popRequest();
            SyncManager.this.syncLocalItemChanges(this.mDatabase, (Shoppinglist)this.mLocalCopy, this.mUser);
        }
    }

    private class ItemSyncListener
    implements Response.Listener<JSONArray> {
        private SgnDatabase mDatabase;
        private User mUser;
        private Shoppinglist mShoppinglist;

        private ItemSyncListener(SgnDatabase database, Shoppinglist shoppinglist, User user) {
            this.mDatabase = database;
            this.mShoppinglist = shoppinglist;
            this.mUser = user;
        }

        @Override
        public void onComplete(JSONArray response, ShopGunError error) {
            if (response == null) {
                SyncManager.this.popRequest();
                SyncManager.this.addRequest(new ListPutRequest(this.mDatabase, this.mUser, this.mShoppinglist));
                return;
            }
            this.mShoppinglist.setState(2);
            this.mDatabase.editList(this.mShoppinglist, this.mUser);
            List<ShoppinglistItem> localItems = this.mDatabase.getItems(this.mShoppinglist, this.mUser, true);
            List<ShoppinglistItem> serverItems = ShoppinglistItem.fromJSON(response);
            Collections.reverse(serverItems);
            for (ShoppinglistItem sli : serverItems) {
                sli.setState(2);
            }
            SyncManager.this.mergeItemsToDb(this.mDatabase, serverItems, localItems, this.mUser);
            localItems = this.mDatabase.getItems(this.mShoppinglist, this.mUser);
            ListUtils.sortItems(localItems);
            if (PermissionUtils.allowEdit(this.mShoppinglist, this.mUser)) {
                String tmp = "00000000-0000-0000-0000-000000000000";
                for (ShoppinglistItem sli : localItems) {
                    if (!tmp.equals(sli.getPreviousId())) {
                        sli.setPreviousId(tmp);
                        sli.setModified(new Date());
                        sli.setState(0);
                        if (((SyncManager)SyncManager.this).mBuilder.items.containsKey(sli.getId())) {
                            SyncManager.this.mBuilder.add(sli);
                        } else {
                            SyncManager.this.mBuilder.edit(sli);
                        }
                        this.mDatabase.editItems(sli, this.mUser);
                    }
                    tmp = sli.getId();
                }
            }
            SyncManager.this.popRequestAndPostShoppinglistEvent();
        }
    }

    private class ItemSyncRequest
    extends JsonArrayRequest {
        private ItemSyncRequest(SgnDatabase database, Shoppinglist shoppinglist, User user) {
            super(Endpoints.listitems(user.getUserId(), shoppinglist.getId()), new ItemSyncListener(database, shoppinglist, user));
            this.getParameters().remove("offset");
            this.getParameters().remove("limit");
            this.setSaveNetworkLog(false);
            shoppinglist.setState(1);
            database.editList(shoppinglist, user);
        }
    }

    private class ListModifiedListener
    extends JSONObjectListener<JSONObject> {
        Shoppinglist mShoppinglist;

        private ListModifiedListener(SgnDatabase database, User user, Shoppinglist shoppinglist) {
            super(database, user, null);
            this.mShoppinglist = shoppinglist;
        }

        @Override
        public void onSuccess(JSONObject response) {
            this.mShoppinglist.setState(2);
            try {
                String modifiedString = response.getString("modified");
                Date modified = SgnUtils.stringToDate(modifiedString);
                if (this.mShoppinglist.getModified().before(modified)) {
                    SyncManager.this.addRequest(new ItemSyncRequest(this.mDatabase, this.mShoppinglist, this.mUser));
                } else {
                    this.mDatabase.editList(this.mShoppinglist, this.mUser);
                }
            }
            catch (JSONException e) {
                SgnLog.e(TAG, e.getMessage(), e);
                this.mDatabase.editList(this.mShoppinglist, this.mUser);
            }
            SyncManager.this.popRequestAndPostShoppinglistEvent();
        }

        @Override
        public void onError(ShopGunError error) {
            SyncManager.this.popRequest();
            SyncManager.this.addRequest(new ListPutRequest(this.mDatabase, this.mUser, this.mShoppinglist));
        }

        @Override
        public void onComplete(JSONObject response, ShopGunError error) {
            if (response != null) {
                this.onSuccess(response);
            } else {
                this.onError(error);
            }
        }
    }

    private class ListModifiedRequest
    extends JsonObjectRequest {
        private ListModifiedRequest(SgnDatabase database, User user, Shoppinglist shoppinglist) {
            super(Endpoints.listModified(user.getUserId(), shoppinglist.getId()), new ListModifiedListener(database, user, shoppinglist));
            this.setSaveNetworkLog(false);
        }
    }

    private class ListSyncListener
    extends ListArrayListener {
        private ListSyncListener(SgnDatabase database, User user, int syncCount) {
            super(database, user, null);
        }

        @Override
        public void onSuccess(List<Shoppinglist> serverLists) {
            List<Shoppinglist> localLists = this.mDatabase.getLists(this.mUser, true);
            Collections.reverse(serverLists);
            for (Shoppinglist sl : serverLists) {
                for (Share share : sl.getShares().values()) {
                    share.setState(2);
                }
            }
            SyncManager.this.mergeListsToDbAndFetchItems(this.mDatabase, serverLists, localLists, this.mUser);
            SyncManager.this.popRequestAndPostShoppinglistEvent();
        }

        @Override
        public void onError(ShopGunError error) {
            SyncManager.this.popRequest();
        }
    }

    private class ListSyncRequest
    extends JsonArrayRequest {
        private ListSyncRequest(SgnDatabase database, User user, int syncCount) {
            super(Endpoints.lists(user.getUserId()), new ListSyncListener(database, user, syncCount));
            this.getParameters().remove("offset");
            this.getParameters().remove("limit");
            this.setSaveNetworkLog(false);
        }
    }

    private class SyncLooper
    implements Runnable {
        private int mSyncCount = 0;

        private SyncLooper() {
        }

        private void restart() {
            this.mSyncCount = 0;
            this.forceSync();
        }

        private void forceSync() {
            SyncManager.this.mHandler.removeCallbacks((Runnable)this);
            SyncManager.this.mHandler.post((Runnable)this);
        }

        @Override
        public void run() {
            List<Shoppinglist> lists;
            int interval = SyncManager.this.getSyncInterval();
            if (interval == SyncInterval.PAUSED) {
                SyncLog.syncLooper(TAG, this.mSyncCount, "skip-loop-cycle (Paused)");
                return;
            }
            User user = SyncManager.this.mShopGun.getSessionManager().getSession().getUser();
            if (!user.isLoggedIn()) {
                ++this.mSyncCount;
                SyncLog.syncLooper(TAG, this.mSyncCount, "quit-loop-cycle (NotLoggedIn)");
                return;
            }
            if (SyncManager.this.mShopGun.getLifecycleManager().isActive()) {
                SyncManager.this.mHandler.postDelayed((Runnable)this, (long)interval);
            }
            if (!SyncManager.this.mCurrentRequests.isEmpty()) {
                SyncLog.syncLooper(TAG, this.mSyncCount, "skip-loop-cycle (ReqInFlight)");
                return;
            }
            if (!ConnectivityUtils.isOnline((Context)ShopGun.getInstance().getContext())) {
                SyncLog.syncLooper(TAG, this.mSyncCount, "skip-loop-cycle (Offline)");
                return;
            }
            SgnDatabase database = SyncManager.this.mDatabase;
            if (SyncManager.this.syncLocalListChanges(database, lists = database.getLists(user, true), user)) {
                ++this.mSyncCount;
                SyncLog.syncLooper(TAG, this.mSyncCount, "syncLocalListChanges");
                return;
            }
            boolean hasLocalChanges = false;
            for (Shoppinglist sl : lists) {
                boolean itemChanges = SyncManager.this.syncLocalItemChanges(database, sl, user);
                boolean shareChanges = SyncManager.this.syncLocalShareChanges(database, sl, user);
                hasLocalChanges = itemChanges || shareChanges || hasLocalChanges;
            }
            if (hasLocalChanges) {
                ++this.mSyncCount;
                SyncLog.syncLooper(TAG, this.mSyncCount, "hasLocalChanges");
                return;
            }
            if (this.mSyncCount % 3 == 0) {
                SyncLog.syncLooper(TAG, this.mSyncCount, "syncAllLists");
                SyncManager.this.addRequest(new ListSyncRequest(database, user, Integer.MAX_VALUE));
            } else if (this.mSyncCount % 10 == 0) {
                SyncLog.syncLooper(TAG, this.mSyncCount, "syncAllItems");
                List<Shoppinglist> localLists = database.getLists(user);
                for (Shoppinglist sl : localLists) {
                    SyncManager.this.addRequest(new ItemSyncRequest(database, sl, user));
                }
            } else {
                SyncLog.syncLooper(TAG, this.mSyncCount, "checkModified");
                SyncManager.this.syncListsModifiedTimestamp(database, user);
            }
            ++this.mSyncCount;
        }
    }

    private class LifecycleCallback
    extends LifecycleManager.SimpleCallback {
        private LifecycleCallback() {
        }

        @Override
        public void onCreate(Activity activity) {
            SyncManager.this.mDatabase.open();
            SgnBus.getInstance().register((Object)SyncManager.this);
            int interval = SyncManager.this.mSyncInterval == Integer.MIN_VALUE ? SyncInterval.SLOW : SyncManager.this.mSyncInterval;
            SyncManager.this.setSyncInterval(interval);
        }

        @Override
        public void onDestroy(Activity activity) {
            SyncManager.this.mSyncLooper.forceSync();
            SgnBus.getInstance().unregister((Object)SyncManager.this);
            SyncManager.this.mDatabase.close();
        }
    }
}

