/*
 * Decompiled with CFR 0.152.
 */
package com.shopgun.android.sdk.shoppinglists;

import com.shopgun.android.sdk.log.SgnLog;
import com.shopgun.android.sdk.network.Request;
import com.shopgun.android.sdk.network.RequestDebugger;
import com.shopgun.android.sdk.network.ShopGunError;
import com.shopgun.android.sdk.network.impl.DeliveryDebugger;
import com.shopgun.android.utils.log.Logger;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

public class SyncDebugger
implements RequestDebugger {
    public static final String TAG = DeliveryDebugger.class.getSimpleName();
    private final String mTag;
    private final Logger mLogger;
    private boolean mSkipSuccess;
    private Set<Request.Method> mSkipMethods = new HashSet<Request.Method>();

    public SyncDebugger(String tag) {
        this(tag, SgnLog.getLogger());
    }

    public SyncDebugger(String tag, Logger logger) {
        this.mLogger = logger;
        this.mTag = tag;
    }

    public SyncDebugger setSkipSuccess(boolean skipSuccess) {
        this.mSkipSuccess = skipSuccess;
        return this;
    }

    public SyncDebugger setSkipMethods(Request.Method method) {
        this.mSkipMethods.add(method);
        return this;
    }

    public SyncDebugger setSkipMethods(Request.Method method, Request.Method ... methods) {
        this.mSkipMethods.add(method);
        Collections.addAll(this.mSkipMethods, method);
        return this;
    }

    @Override
    public void onFinish(Request<?> r) {
    }

    @Override
    public void onDelivery(Request<?> r, Object response, ShopGunError error) {
        if (this.mSkipSuccess && error == null) {
            return;
        }
        if (this.mSkipMethods.contains((Object)r.getMethod())) {
            return;
        }
        this.mLogger.d(this.mTag, (Object)((Object)r.getMethod()) + " " + r.getUrl());
        if (error == null) {
            this.mLogger.d(this.mTag, "- Success: " + String.valueOf(response));
        } else {
            this.mLogger.d(this.mTag, "- Error in [" + r.getClass().getSimpleName() + "] " + String.valueOf(error));
        }
    }
}

