/*
 * Decompiled with CFR 0.152.
 */
package com.shopgun.android.sdk.shoppinglists;

import android.annotation.SuppressLint;
import android.app.Activity;
import com.shopgun.android.sdk.ShopGun;
import com.shopgun.android.sdk.bus.SgnBus;
import com.shopgun.android.sdk.bus.ShoppinglistEvent;
import com.shopgun.android.sdk.corekit.LifecycleManager;
import com.shopgun.android.sdk.database.SgnDatabase;
import com.shopgun.android.sdk.log.SgnLog;
import com.shopgun.android.sdk.model.Share;
import com.shopgun.android.sdk.model.Shoppinglist;
import com.shopgun.android.sdk.model.ShoppinglistItem;
import com.shopgun.android.sdk.model.User;
import com.shopgun.android.sdk.utils.Constants;
import com.shopgun.android.sdk.utils.ListUtils;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.json.JSONArray;

public class ListManager {
    public static final String TAG = Constants.getTag(ListManager.class);
    private ShopGun mShopGun;
    private SgnDatabase mDatabase;
    private ShoppinglistEvent.Builder mBuilder = new ShoppinglistEvent.Builder(false);

    public ListManager(ShopGun shopGun, SgnDatabase db) {
        this.mShopGun = shopGun;
        this.mDatabase = db;
        this.mShopGun.getLifecycleManager().registerCallback(new LifecycleCallback());
    }

    public Shoppinglist getList(String id2) {
        return this.mDatabase.getList(id2, this.user());
    }

    public List<Shoppinglist> getLists() {
        return this.mDatabase.getLists(this.user());
    }

    public List<Shoppinglist> getLists(User user) {
        return this.mDatabase.getLists(user);
    }

    public boolean addList(Shoppinglist sl) {
        boolean success;
        ArrayList<Shoppinglist> lists = new ArrayList<Shoppinglist>();
        lists.add(sl);
        sl.setModified(new Date());
        User user = this.user();
        Share owner = sl.getOwner();
        if (owner == null || owner.getEmail() == null) {
            owner = new Share(user.getEmail(), "owner", null);
            owner.setName(user.getName());
            owner.setAccepted(true);
            owner.setShoppinglistId(sl.getId());
            sl.putShare(owner);
        }
        sl.setPreviousId("00000000-0000-0000-0000-000000000000");
        sl.setState(0);
        Shoppinglist first = this.mDatabase.getFirstList(user);
        if (first != null) {
            first.setPreviousId(sl.getId());
            first.setModified(new Date());
            first.setState(0);
            lists.add(first);
        }
        if (success = this.mDatabase.insertLists(lists, user)) {
            this.mBuilder.add(sl);
        }
        this.postShoppinglistEvent();
        return success;
    }

    public boolean editList(Shoppinglist sl) {
        return this.editList(sl, this.user());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean editList(Shoppinglist sl, User user) {
        Shoppinglist original = this.mDatabase.getList(sl.getId(), user);
        if (original == null) {
            SgnLog.i(TAG, "No such list exists in the database. To add new items, use addList().");
            return false;
        }
        HashMap<String, Share> dbShares = original.getShares();
        HashMap<String, Share> slShares = sl.getShares();
        if (!slShares.containsKey(user.getEmail())) {
            Share dbShare = (Share)dbShares.get(user.getEmail());
            if (dbShare != null) {
                dbShare.setState(4);
                this.mDatabase.editShare(dbShare, user);
                this.mBuilder.del(sl);
                this.postShoppinglistEvent();
                return true;
            }
            return false;
        }
        this.mDatabase.allowEditOrThrow(sl, user);
        HashSet union = new HashSet();
        union.addAll(slShares.keySet());
        union.addAll(dbShares.keySet());
        for (String shareId : union) {
            if (!dbShares.containsKey(shareId)) continue;
            Share dbShare = (Share)dbShares.get(shareId);
            if (slShares.containsKey(shareId)) {
                Share slShare = (Share)slShares.get(shareId);
                if (dbShare.equals(slShare)) continue;
                slShare.setState(0);
                continue;
            }
            if (dbShare.getAccess().equals("owner")) {
                sl.putShare(dbShare);
                SgnLog.i(TAG, "Owner cannot be removed from lists, owner will be reattached");
                continue;
            }
            if (!user.isLoggedIn()) continue;
            dbShare.setState(4);
            sl.putShare(dbShare);
        }
        ArrayList<Shoppinglist> lists = new ArrayList<Shoppinglist>();
        lists.add(sl);
        Date now = new Date();
        sl.setModified(now);
        sl.setState(0);
        if (original.getPreviousId() != null && !original.getPreviousId().equals(sl.getPreviousId())) {
            Object slSamePointer;
            Shoppinglist slAfter = this.mDatabase.getListPrevious(sl.getId(), user);
            if (slAfter != null) {
                slAfter.setPreviousId(original.getPreviousId());
                slAfter.setModified(now);
                slAfter.setState(0);
                lists.add(slAfter);
            }
            if ((slSamePointer = this.mDatabase.getListPrevious(sl.getPreviousId(), user)) != null) {
                ((Shoppinglist)slSamePointer).setPreviousId(sl.getId());
                ((Shoppinglist)slSamePointer).setModified(now);
                ((Shoppinglist)slSamePointer).setState(0);
                lists.add((Shoppinglist)slSamePointer);
            }
        }
        try {
            boolean success = this.mDatabase.insertLists(lists, user);
            if (success) {
                for (Shoppinglist edited : lists) {
                    this.mBuilder.edit(edited);
                }
            }
            Iterator<Map.Entry<String, Share>> it = sl.getShares().entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry<String, Share> entry = it.next();
                if (entry.getValue().getState() != 4) continue;
                it.remove();
            }
            boolean bl = success;
            return bl;
        }
        finally {
            this.postShoppinglistEvent();
        }
    }

    public void deleteList(Shoppinglist sl) {
        User u = this.user();
        this.mDatabase.allowEditOrThrow(sl, u);
        this.deleteList(sl, u);
    }

    private boolean deleteList(Shoppinglist sl, User user) {
        ArrayList<Shoppinglist> editedLists = new ArrayList<Shoppinglist>();
        Date now = new Date();
        sl.setModified(now);
        editedLists.add(sl);
        Shoppinglist after = this.mDatabase.getListPrevious(sl.getId(), user);
        if (after != null) {
            after.setPreviousId(sl.getPreviousId());
            after.setModified(now);
            after.setState(0);
            editedLists.add(after);
            this.mBuilder.edit(after);
        }
        List<ShoppinglistItem> items = this.getItems(sl, user);
        for (ShoppinglistItem sli : items) {
            sli.setState(4);
            sli.setModified(now);
        }
        boolean success = this.mDatabase.editItems(items, user);
        if (success) {
            for (ShoppinglistItem sli : items) {
                this.mBuilder.del(sli);
            }
        }
        sl.setState(4);
        success = this.mDatabase.insertLists(editedLists, user);
        if (success) {
            for (Shoppinglist s : editedLists) {
                this.mBuilder.del(s);
            }
        }
        this.postShoppinglistEvent();
        return success;
    }

    public ShoppinglistItem getItem(String id2) {
        return this.mDatabase.getItem(id2, this.user());
    }

    public List<ShoppinglistItem> getItems(Shoppinglist sl) {
        return this.getItems(sl.getId(), this.user());
    }

    public List<ShoppinglistItem> getItems(String shoppinglistId) {
        return this.getItems(shoppinglistId, this.user());
    }

    private List<ShoppinglistItem> getItems(Shoppinglist sl, User user) {
        return this.getItems(sl.getId(), user);
    }

    private List<ShoppinglistItem> getItems(String shoppinglistId, User user) {
        List<ShoppinglistItem> items = this.mDatabase.getItems(shoppinglistId, user, false);
        ListUtils.sortItems(items);
        return items;
    }

    public boolean addItem(ShoppinglistItem sli) {
        return this.addItem(sli, true, this.user());
    }

    private boolean isStringEqual(String first, String last) {
        return first == null ? last == null : first.equalsIgnoreCase(last);
    }

    @SuppressLint(value={"DefaultLocale"})
    public boolean addItem(ShoppinglistItem sli, boolean incrementCount, User user) {
        boolean success;
        ShoppinglistItem first;
        Shoppinglist sl;
        this.mDatabase.allowEditOrThrow(sli.getShoppinglistId(), user);
        if (sli.getOfferId() == null && sli.getDescription() == null) {
            SgnLog.i(TAG, "The ShoppinglistItem neither has offerId, ordescription, one or the other this is required by the API");
            return false;
        }
        if (incrementCount) {
            List<ShoppinglistItem> items = this.mDatabase.getItems(sli.getShoppinglistId(), user, false);
            for (ShoppinglistItem s : items) {
                boolean descriptionEqual = this.isStringEqual(s.getDescription(), sli.getDescription());
                boolean idEqual = this.isStringEqual(sli.getOfferId(), s.getOfferId());
                if (!idEqual || !descriptionEqual) continue;
                s.setCount(s.getCount() + 1);
                s.setTick(false);
                return this.editItem(s);
            }
        }
        if ((sl = this.mDatabase.getList(sli.getShoppinglistId(), user)) == null) {
            SgnLog.i(TAG, "The shoppinglist id on the shoppinglist item, couldnot be found, please add a shoppinglist before adding items");
            return false;
        }
        ArrayList<ShoppinglistItem> editedItems = new ArrayList<ShoppinglistItem>();
        Date now = new Date();
        sli.setModified(now);
        sli.setState(0);
        sli.setPreviousId("00000000-0000-0000-0000-000000000000");
        editedItems.add(sli);
        if (sli.getCreator() == null) {
            if (user.getName() != null && user.getName().length() > 0) {
                sli.setCreator(user.getName());
            } else {
                sli.setCreator(user.getEmail());
            }
        }
        if ((first = this.mDatabase.getFirstItem(sli.getShoppinglistId(), user)) != null) {
            first.setPreviousId(sli.getId());
            first.setModified(now);
            first.setState(0);
            editedItems.add(first);
            this.mBuilder.edit(first);
        }
        if (success = this.mDatabase.insertItems(editedItems, user)) {
            sl.setModified(now);
            this.mDatabase.editList(sl, user);
            this.mBuilder.edit(sl);
            this.mBuilder.add(sli);
        }
        this.postShoppinglistEvent();
        return success;
    }

    public boolean editItem(ShoppinglistItem sli) {
        try {
            boolean bl = this.editItem(sli, this.user());
            return bl;
        }
        finally {
            this.postShoppinglistEvent();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean editItems(List<ShoppinglistItem> items) {
        long s = System.currentTimeMillis();
        try {
            boolean bl = this.editItems(items, this.user());
            return bl;
        }
        finally {
            SgnLog.d(TAG, "editItems.time: " + (System.currentTimeMillis() - s) + "ms");
        }
    }

    private boolean editItems(List<ShoppinglistItem> items, User user) {
        List<Shoppinglist> lists = this.mDatabase.allowEditItemsOrThrow(items, user);
        HashMap<String, ShoppinglistItem> dbItems = new HashMap<String, ShoppinglistItem>();
        for (Shoppinglist shoppinglist : lists) {
            for (ShoppinglistItem sli : this.getItems(shoppinglist, user)) {
                dbItems.put(sli.getId(), sli);
            }
        }
        Date now = new Date();
        for (ShoppinglistItem sli : items) {
            if (!dbItems.containsKey(sli.getId())) {
                SgnLog.i(TAG, "No such item exists, consider addItem() instead: " + sli.toString());
                return false;
            }
            sli.setModified(now);
            sli.setState(0);
        }
        boolean bl = this.mDatabase.editItems(items, user);
        if (bl) {
            for (Shoppinglist sl : lists) {
                sl.setModified(now);
                this.mDatabase.editList(sl, user);
                this.mBuilder.edit(sl);
            }
            for (ShoppinglistItem sli : items) {
                this.mBuilder.edit(sli);
            }
        }
        this.postShoppinglistEvent();
        return bl;
    }

    private boolean editItem(ShoppinglistItem sli, User user) {
        this.mDatabase.allowEditOrThrow(sli.getShoppinglistId(), user);
        Date now = new Date();
        sli.setModified(now);
        sli.setState(0);
        ShoppinglistItem oldItem = this.mDatabase.getItem(sli.getId(), user);
        if (oldItem == null) {
            SgnLog.i(TAG, "No such item exists, consider addItem() instead: " + sli.toString());
            return false;
        }
        boolean success = this.mDatabase.editItems(sli, user);
        if (success) {
            Shoppinglist sl = this.mDatabase.getList(sli.getShoppinglistId(), user);
            if (sl != null) {
                sl.setModified(now);
                this.mDatabase.editList(sl, user);
                this.mBuilder.edit(sl);
            }
            this.mBuilder.edit(sli);
        }
        this.postShoppinglistEvent();
        return success;
    }

    public void deleteItemsTicked(Shoppinglist sl) {
        this.deleteItems(sl, true, this.user());
    }

    public void deleteItemsUnticked(Shoppinglist sl) {
        this.deleteItems(sl, false, this.user());
    }

    public void deleteItemsAll(Shoppinglist sl) {
        this.deleteItems(sl, null, this.user());
    }

    private boolean deleteItems(Shoppinglist sl, Boolean stateToDelete, User user) {
        this.mDatabase.allowEditOrThrow(sl.getId(), user);
        Date now = new Date();
        List<ShoppinglistItem> list = this.getItems(sl, user);
        String preGoodId = "00000000-0000-0000-0000-000000000000";
        ArrayList<ShoppinglistItem> edited = new ArrayList<ShoppinglistItem>();
        for (ShoppinglistItem sli : list) {
            if (stateToDelete == null || sli.isTicked() == stateToDelete.booleanValue()) {
                sli.setState(4);
                sli.setModified(now);
                edited.add(sli);
                continue;
            }
            if (!sli.getPreviousId().equals(preGoodId)) {
                sli.setPreviousId(preGoodId);
                sli.setModified(now);
                sli.setState(0);
                edited.add(sli);
            }
            preGoodId = sli.getId();
        }
        boolean success = false;
        if (user.isLoggedIn()) {
            success = this.mDatabase.editItems(edited, user);
        } else {
            int rows = this.mDatabase.deleteItems(sl.getId(), stateToDelete, user);
            boolean bl = success = rows > 0;
        }
        if (success) {
            sl.setModified(now);
            this.mDatabase.editList(sl, user);
            this.mBuilder.edit(sl);
            for (ShoppinglistItem sli : edited) {
                if (sli.getState() == 4) {
                    this.mBuilder.del(sli);
                    continue;
                }
                this.mBuilder.edit(sli);
            }
        }
        this.postShoppinglistEvent();
        return success;
    }

    public boolean deleteItem(ShoppinglistItem sli) {
        User u = this.user();
        this.mDatabase.allowEditOrThrow(sli.getShoppinglistId(), u);
        return this.deleteItem(sli, u);
    }

    private boolean deleteItem(ShoppinglistItem sli, User user) {
        Date now = new Date();
        ArrayList<ShoppinglistItem> edited = new ArrayList<ShoppinglistItem>();
        sli.setModified(now);
        sli.setState(4);
        edited.add(sli);
        ShoppinglistItem after = this.mDatabase.getItemPrevious(sli.getShoppinglistId(), sli.getId(), user);
        if (after != null) {
            after.setPreviousId(sli.getPreviousId());
            after.setModified(now);
            edited.add(after);
            this.mBuilder.edit(after);
        }
        boolean success = false;
        if (user.isLoggedIn()) {
            success = this.mDatabase.editItems(edited, user);
        } else {
            success = this.mDatabase.deleteItem(sli, user);
            edited.remove(sli);
        }
        if (success) {
            Shoppinglist sl = this.getList(sli.getShoppinglistId());
            sl.setModified(now);
            this.mDatabase.editList(sl, user);
            this.mBuilder.edit(sl);
            this.mBuilder.del(sli);
        }
        this.postShoppinglistEvent();
        return success;
    }

    private User user() {
        return this.mShopGun.getSessionManager().getSession().getUser();
    }

    public void clear() {
        this.mDatabase.clear();
    }

    public void clear(int userId) {
        this.mDatabase.clear(userId);
    }

    private void postShoppinglistEvent() {
        if (!this.mShopGun.getSyncManager().isPaused() && this.mBuilder.hasChanges()) {
            SgnBus.getInstance().post((Object)this.mBuilder.build());
            this.mBuilder = new ShoppinglistEvent.Builder(false);
        }
    }

    public JSONArray dumpListTable() {
        return this.mDatabase.dumpListTable();
    }

    public JSONArray dumpShareTable() {
        return this.mDatabase.dumpShareTable();
    }

    public JSONArray dumpItemTable() {
        return this.mDatabase.dumpItemTable();
    }

    private class LifecycleCallback
    extends LifecycleManager.SimpleCallback {
        private LifecycleCallback() {
        }

        @Override
        public void onCreate(Activity activity) {
            ListManager.this.mDatabase.open();
        }

        @Override
        public void onDestroy(Activity activity) {
            ListManager.this.mDatabase.close();
        }
    }
}

