/*
 * Decompiled with CFR 0.152.
 */
package com.shopgun.android.sdk.requests;

import com.shopgun.android.sdk.model.Catalog;
import com.shopgun.android.sdk.model.interfaces.ICatalog;
import com.shopgun.android.sdk.model.interfaces.IDealer;
import com.shopgun.android.sdk.model.interfaces.IStore;
import com.shopgun.android.sdk.network.Request;
import com.shopgun.android.sdk.requests.LoaderRequest;
import com.shopgun.android.sdk.requests.RequestCreator;
import com.shopgun.android.sdk.utils.Constants;
import java.util.ArrayList;
import java.util.List;

public class ModelLoaderRequest<T>
extends LoaderRequest<T> {
    public static final String TAG = Constants.getTag(ModelLoaderRequest.class);
    private boolean mPages = false;
    private boolean mDealer = false;
    private boolean mStore = false;
    private boolean mHotspots = false;
    private boolean mCatalog = false;

    public ModelLoaderRequest(LoaderRequest.Listener<T> l) {
        super(l);
    }

    public ModelLoaderRequest(T data, LoaderRequest.Listener<T> l) {
        super(data, l);
    }

    protected boolean loadPages() {
        return this.mPages;
    }

    protected void loadPages(boolean pages) {
        this.mPages = pages;
    }

    protected boolean loadDealer() {
        return this.mDealer;
    }

    protected void loadDealer(boolean dealer) {
        this.mDealer = dealer;
    }

    protected boolean loadStore() {
        return this.mStore;
    }

    protected void loadStore(boolean store) {
        this.mStore = store;
    }

    protected boolean loadHotspots() {
        return this.mHotspots;
    }

    protected void loadHotspots(boolean hotspots) {
        this.mHotspots = hotspots;
    }

    protected boolean loadCatalog() {
        return this.mCatalog;
    }

    protected void loadCatalog(boolean catalog) {
        this.mCatalog = catalog;
    }

    @Override
    public List<Request> createRequests(T data) {
        ArrayList<Request> requests = new ArrayList<Request>();
        if (this.mPages && data instanceof Catalog) {
            requests.add(RequestCreator.getPagesRequestOrNull(this, (Catalog)data));
        }
        if (this.mStore && data instanceof IStore) {
            requests.add(RequestCreator.getStoreRequestOrNull(this, (IStore)data));
        }
        if (this.mDealer && data instanceof IDealer) {
            requests.add(RequestCreator.getDealerRequestOrNull(this, (IDealer)data));
        }
        if (this.mHotspots && data instanceof Catalog) {
            requests.add(RequestCreator.getHotspotsRequestOrNull(this, (Catalog)data));
        }
        if (this.mCatalog && data instanceof ICatalog) {
            requests.add(RequestCreator.createCatalogRequest((LoaderRequest)this, (ICatalog)data, true));
        }
        return requests;
    }
}

