/*
 * Decompiled with CFR 0.152.
 */
package com.shopgun.android.sdk.pagedpublicationkit.impl.apiv2;

import android.content.Context;
import android.view.View;
import android.view.animation.Animation;
import android.view.animation.AnimationUtils;
import android.widget.FrameLayout;
import com.shopgun.android.sdk.R;
import com.shopgun.android.sdk.pagedpublicationkit.PagedPublicationFragment;
import com.shopgun.android.sdk.pagedpublicationkit.PagedPublicationHotspot;
import com.shopgun.android.sdk.pagedpublicationkit.PagedPublicationOverlay;
import com.shopgun.android.sdk.pagedpublicationkit.impl.apiv2.CatalogHotspotView;
import java.util.ArrayList;
import java.util.List;

public class CatalogSpreadLayout
extends FrameLayout
implements PagedPublicationOverlay {
    public static final String TAG = CatalogSpreadLayout.class.getSimpleName();
    List<HotspotUIController> mHotspots = new ArrayList<HotspotUIController>();
    int[] mPages;

    public CatalogSpreadLayout(Context context, int[] pages) {
        super(context);
        this.mPages = pages;
    }

    @Override
    public void showHotspots(PagedPublicationFragment.PublicationTapInfo info) {
        if (info != null && info.hasHotspots()) {
            HotspotUIController huc = new HotspotUIController(info);
            this.mHotspots.add(huc);
            huc.display();
        }
    }

    @Override
    public void hideHotspots(PagedPublicationFragment.PublicationTapInfo info) {
        for (HotspotUIController huc : this.mHotspots) {
            huc.hide();
        }
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        int width = View.MeasureSpec.getSize((int)widthMeasureSpec);
        int height = View.MeasureSpec.getSize((int)heightMeasureSpec);
        int childWidthMeasureSpec = View.MeasureSpec.makeMeasureSpec((int)width, (int)Integer.MIN_VALUE);
        int childHeightMeasureSpec = View.MeasureSpec.makeMeasureSpec((int)height, (int)Integer.MIN_VALUE);
        this.measureChildren(childWidthMeasureSpec, childHeightMeasureSpec);
        this.setMeasuredDimension(width, height);
    }

    class HotspotUIController {
        final PagedPublicationFragment.PublicationTapInfo mInfo;
        final Animation mAnimateIn;
        final List<View> mViews;
        boolean mHideCalled = false;

        HotspotUIController(PagedPublicationFragment.PublicationTapInfo info) {
            this.mInfo = info;
            this.mAnimateIn = AnimationUtils.loadAnimation((Context)CatalogSpreadLayout.this.getContext(), (int)R.anim.sgn_pagedpubkit_hotspot_in);
            this.mAnimateIn.setAnimationListener(new Animation.AnimationListener(){

                public void onAnimationStart(Animation animation) {
                }

                public void onAnimationEnd(Animation animation) {
                    for (View v : HotspotUIController.this.mViews) {
                        v.clearAnimation();
                    }
                    if (HotspotUIController.this.mHideCalled) {
                        HotspotUIController.this.hide();
                    }
                }

                public void onAnimationRepeat(Animation animation) {
                }
            });
            this.mViews = new ArrayList<View>();
            for (PagedPublicationHotspot h : info.getHotspots()) {
                CatalogHotspotView view = new CatalogHotspotView(CatalogSpreadLayout.this.getContext(), h, CatalogSpreadLayout.this.mPages);
                view.setAnimation(this.mAnimateIn);
                CatalogSpreadLayout.this.addView(view);
                this.mViews.add(view);
            }
        }

        void display() {
            this.mAnimateIn.startNow();
        }

        public void hide() {
            this.mHideCalled = true;
            if (!this.mAnimateIn.hasStarted() || this.mAnimateIn.hasEnded()) {
                Animation out = AnimationUtils.loadAnimation((Context)CatalogSpreadLayout.this.getContext(), (int)R.anim.sgn_pagedpubkit_hotspot_out);
                for (View v : this.mViews) {
                    v.clearAnimation();
                    v.setAnimation(out);
                }
                out.setAnimationListener(new Animation.AnimationListener(){

                    public void onAnimationStart(Animation animation) {
                    }

                    public void onAnimationEnd(Animation animation) {
                        for (View v : HotspotUIController.this.mViews) {
                            v.clearAnimation();
                        }
                        CatalogSpreadLayout.this.post(new Runnable(){

                            @Override
                            public void run() {
                                CatalogSpreadLayout.this.removeAllViews();
                            }
                        });
                    }

                    public void onAnimationRepeat(Animation animation) {
                    }
                });
                out.startNow();
            }
        }
    }
}

