/*
 * Decompiled with CFR 0.152.
 */
package com.shopgun.android.sdk.pagedpublicationkit.impl.apiv2;

import android.content.Context;
import android.graphics.drawable.Drawable;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.ImageView;
import com.bumptech.glide.Glide;
import com.bumptech.glide.request.target.BaseTarget;
import com.bumptech.glide.request.target.SizeReadyCallback;
import com.bumptech.glide.request.target.Target;
import com.bumptech.glide.request.transition.Transition;
import com.shopgun.android.sdk.pagedpublicationkit.PagedPublicationPage;
import com.shopgun.android.sdk.pagedpublicationkit.impl.AspectRatioFrameLayout;
import com.shopgun.android.sdk.pagedpublicationkit.impl.PulsatingTextView;
import com.shopgun.android.sdk.pagedpublicationkit.impl.apiv2.CatalogImageView;
import com.shopgun.android.utils.UnitUtils;
import com.shopgun.android.verso.VersoPageView;
import com.shopgun.android.verso.VersoPageViewFragment;

public class CatalogPageView
extends AspectRatioFrameLayout
implements VersoPageView {
    public static final String TAG = CatalogPageView.class.getSimpleName();
    private PagedPublicationPage mPagedPublicationPage;
    private PagedPublicationPage.Size mSize;
    private ImageView mImageView;
    private PulsatingTextView mTextView;
    private GlidePageTarget mPageTarget = new GlidePageTarget();
    private boolean mVisible;
    private VersoPageViewFragment.OnLoadCompleteListener mLoadCompletionListener;

    public CatalogPageView(Context context, PagedPublicationPage page, int textColor) {
        super(context);
        this.mPagedPublicationPage = page;
        this.setAspectRatio(this.mPagedPublicationPage.getAspectRatio());
        this.mImageView = new CatalogImageView(context);
        this.addView((View)this.mImageView);
        this.mTextView = new PulsatingTextView(context);
        FrameLayout.LayoutParams lp = new FrameLayout.LayoutParams(-2, -2);
        lp.gravity = 17;
        this.mTextView.setLayoutParams((ViewGroup.LayoutParams)lp);
        this.mTextView.setPulseColors(textColor, 20, 80);
        this.mTextView.setText(String.valueOf(this.mPagedPublicationPage.getPageIndex() + 1));
        this.mTextView.setTextSize(UnitUtils.spToPx((int)26, (Context)this.getContext()));
        this.addView((View)this.mTextView);
    }

    public boolean onZoom(float scale) {
        if (scale > 1.1f && !this.isZoomed()) {
            this.load(PagedPublicationPage.Size.ZOOM);
        } else if (scale < 1.1f && this.isZoomed()) {
            this.load(PagedPublicationPage.Size.VIEW);
        }
        return false;
    }

    public void setOnLoadCompleteListener(VersoPageViewFragment.OnLoadCompleteListener listener) {
        this.mLoadCompletionListener = listener;
    }

    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        this.load(PagedPublicationPage.Size.VIEW);
    }

    public void onVisible() {
        this.mVisible = true;
    }

    public void onInvisible() {
        this.mVisible = false;
    }

    public int getPage() {
        return this.mPagedPublicationPage.getPageIndex();
    }

    private boolean isZoomed() {
        return this.mSize == PagedPublicationPage.Size.ZOOM;
    }

    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        Glide.with((Context)this.getContext()).clear((Target)this.mPageTarget);
    }

    private void load(PagedPublicationPage.Size size) {
        if (this.mSize == size) {
            return;
        }
        this.mSize = size;
        Glide.with((Context)this.getContext()).clear((Target)this.mPageTarget);
        Glide.with((Context)this.getContext()).load(this.mPagedPublicationPage.getUrl(size)).into((Target)this.mPageTarget);
    }

    private class GlidePageTarget
    extends BaseTarget<Drawable> {
        private boolean mCallback = true;

        private GlidePageTarget() {
        }

        public void onResourceReady(@NonNull Drawable resource, @Nullable Transition<? super Drawable> transition) {
            CatalogPageView.this.mTextView.setVisibility(8);
            CatalogPageView.this.mImageView.setImageDrawable(resource);
            if (CatalogPageView.this.mLoadCompletionListener != null && this.mCallback) {
                this.mCallback = false;
                CatalogPageView.this.mLoadCompletionListener.onPageLoadComplete(true, (VersoPageView)CatalogPageView.this);
            }
        }

        public void onLoadFailed(@Nullable Drawable errorDrawable) {
            if (CatalogPageView.this.mLoadCompletionListener != null) {
                CatalogPageView.this.mLoadCompletionListener.onPageLoadComplete(false, (VersoPageView)CatalogPageView.this);
            }
        }

        public void getSize(@NonNull SizeReadyCallback cb) {
            cb.onSizeReady(Integer.MIN_VALUE, Integer.MIN_VALUE);
        }

        public void removeCallback(@NonNull SizeReadyCallback cb) {
        }
    }
}

