/*
 * Decompiled with CFR 0.152.
 */
package com.shopgun.android.sdk.pagedpublicationkit.impl;

import android.support.annotation.NonNull;
import android.view.View;
import android.view.ViewGroup;
import com.shopgun.android.sdk.pagedpublicationkit.PagedPublicationConfiguration;
import com.shopgun.android.utils.enums.Orientation;
import com.shopgun.android.verso.VersoSpreadProperty;
import java.util.Arrays;

public abstract class IntroOutroConfiguration
implements PagedPublicationConfiguration {
    public static final String TAG = IntroOutroConfiguration.class.getSimpleName();

    public int getPageCount() {
        int count = this.getPublicationPageCount();
        if (count > 0) {
            if (this.hasIntro()) {
                ++count;
            }
            if (this.hasOutro()) {
                ++count;
            }
        }
        return count;
    }

    public int getSpreadCount() {
        int count = this.getPublicationPageCount();
        if (count > 0) {
            int n = count = this.getOrientation().isLandscape() ? count / 2 + 1 : count;
            if (this.hasIntro()) {
                ++count;
            }
            if (this.hasOutro()) {
                ++count;
            }
        }
        return count;
    }

    public int getSpreadPositionFromPage(int page) {
        if (this.getOrientation().isPortrait()) {
            return page;
        }
        if (page == 0 || this.hasIntro() && page == 1) {
            return page;
        }
        if (this.hasOutro() && page == this.getPageCount() - 1) {
            return this.getSpreadCount() - 1;
        }
        if (this.hasIntro()) {
            return (page - page % 2) / 2 + 1;
        }
        return (page - 1) / 2 + 1;
    }

    public int[] getPagesFromSpreadPosition(int position) {
        int[] nArray;
        boolean isSinglePage;
        int page;
        if (this.getOrientation().isPortrait()) {
            return new int[]{position};
        }
        if (position == 0 || this.hasIntro() && position == 1) {
            return new int[]{position};
        }
        int n = page = this.hasIntro() ? (position - 1) * 2 : position * 2 - 1;
        if (this.hasOutro() && position == this.getSpreadCount() - 1 && !this.missingLastPage()) {
            --page;
        }
        int lastDoublePage = this.getSpreadCount() - 1;
        lastDoublePage -= this.hasOutro() ? 2 : 1;
        if (this.missingLastPage()) {
            ++lastDoublePage;
        }
        boolean bl = isSinglePage = position > lastDoublePage;
        if (isSinglePage) {
            int[] nArray2 = new int[1];
            nArray = nArray2;
            nArray2[0] = page;
        } else {
            int[] nArray3 = new int[2];
            nArray3[0] = page;
            nArray = nArray3;
            nArray3[1] = page + 1;
        }
        return nArray;
    }

    @NonNull
    public View getPageView(ViewGroup container, int page) {
        if (this.hasIntro() && page == 0) {
            return this.getIntroPageView(container, page);
        }
        if (this.hasOutro() && page == this.getPageCount() - 1) {
            return this.getOutroPageView(container, page);
        }
        int publicationPage = this.hasIntro() ? page - 1 : page;
        return this.getPublicationPageView(container, publicationPage);
    }

    public VersoSpreadProperty getSpreadProperty(int spreadPosition) {
        int[] pages = this.getPagesFromSpreadPosition(spreadPosition);
        if (this.hasIntro() && spreadPosition == 0) {
            return this.getIntroSpreadProperty(spreadPosition, pages);
        }
        if (this.hasOutro() && spreadPosition == this.getSpreadCount() - 1) {
            return this.getOutroSpreadProperty(spreadPosition, pages);
        }
        return this.getPublicationSpreadProperty(spreadPosition, pages);
    }

    public View getSpreadOverlay(ViewGroup container, int[] pages) {
        int position = this.getSpreadPositionFromPage(pages[0]);
        if (this.hasIntro() && position == 0) {
            return this.getIntroSpreadOverlay(container, pages);
        }
        if (this.hasOutro() && position == this.getSpreadCount() - 1) {
            return this.getOutroSpreadOverlay(container, pages);
        }
        return this.getPublicationSpreadOverlay(container, this.fixPages(pages));
    }

    public abstract int getPublicationPageCount();

    public abstract Orientation getOrientation();

    public abstract View getPublicationPageView(ViewGroup var1, int var2);

    @Override
    public boolean hasIntro() {
        return false;
    }

    @Override
    public boolean hasOutro() {
        return false;
    }

    @Override
    public View getIntroPageView(ViewGroup container, int page) {
        return null;
    }

    @Override
    public View getOutroPageView(ViewGroup container, int page) {
        return null;
    }

    public abstract VersoSpreadProperty getPublicationSpreadProperty(int var1, int[] var2);

    public VersoSpreadProperty getIntroSpreadProperty(int spreadPosition, int[] pages) {
        return null;
    }

    public VersoSpreadProperty getOutroSpreadProperty(int spreadPosition, int[] pages) {
        return null;
    }

    public View getPublicationSpreadOverlay(ViewGroup container, int[] publicationPages) {
        return null;
    }

    public View getIntroSpreadOverlay(ViewGroup container, int[] pages) {
        return null;
    }

    public View getOutroSpreadOverlay(ViewGroup container, int[] pages) {
        return null;
    }

    private int[] fixPages(int[] pages) {
        int[] tmp = Arrays.copyOf(pages, pages.length);
        if (this.hasIntro()) {
            int i = 0;
            while (i < tmp.length) {
                int n = i++;
                tmp[n] = tmp[n] - 1;
            }
        }
        return tmp;
    }

    private boolean missingLastPage() {
        return this.getPublicationPageCount() % 2 != 0;
    }
}

