/*
 * Decompiled with CFR 0.152.
 */
package com.shopgun.android.sdk.pagedpublicationkit.impl;

import android.annotation.TargetApi;
import android.content.Context;
import android.util.AttributeSet;
import android.view.View;
import android.widget.FrameLayout;
import com.shopgun.android.utils.NumberUtils;

public class AspectRatioFrameLayout
extends FrameLayout {
    public static final String TAG = AspectRatioFrameLayout.class.getSimpleName();
    float mAspectRatio;

    public AspectRatioFrameLayout(Context context) {
        super(context);
        this.init(context, null, 0, 0);
    }

    public AspectRatioFrameLayout(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init(context, attrs, 0, 0);
    }

    public AspectRatioFrameLayout(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init(context, attrs, defStyleAttr, 0);
    }

    @TargetApi(value=21)
    public AspectRatioFrameLayout(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        super(context, attrs, defStyleAttr, defStyleRes);
        this.init(context, attrs, defStyleAttr, defStyleRes);
    }

    private void init(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
    }

    public void setAspectRatio(float aspectRatio) {
        this.mAspectRatio = aspectRatio;
    }

    public float getAspectRatio() {
        return this.mAspectRatio;
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        float containerHeight;
        if (NumberUtils.isEqual((float)this.mAspectRatio, (float)0.0f)) {
            super.onMeasure(widthMeasureSpec, heightMeasureSpec);
            return;
        }
        float containerWidth = View.MeasureSpec.getSize((int)widthMeasureSpec);
        float containerAspectRatio = containerWidth / (containerHeight = (float)View.MeasureSpec.getSize((int)heightMeasureSpec));
        if (this.mAspectRatio < containerAspectRatio) {
            containerWidth = containerHeight * this.mAspectRatio;
        } else if (this.mAspectRatio > containerAspectRatio) {
            containerHeight = containerWidth / this.mAspectRatio;
        }
        int childWidthMeasureSpec = View.MeasureSpec.makeMeasureSpec((int)((int)containerWidth), (int)Integer.MIN_VALUE);
        int childHeightMeasureSpec = View.MeasureSpec.makeMeasureSpec((int)((int)containerHeight), (int)Integer.MIN_VALUE);
        this.measureChildren(childWidthMeasureSpec, childHeightMeasureSpec);
        this.setMeasuredDimension((int)containerWidth, (int)containerHeight);
    }
}

