/*
 * Decompiled with CFR 0.152.
 */
package com.shopgun.android.sdk.pagedpublicationkit;

import android.os.Parcel;
import android.os.Parcelable;
import com.shopgun.android.sdk.pagedpublicationkit.PagedPublicationConfiguration;
import com.shopgun.android.sdk.pagedpublicationkit.PagedPublicationEvent;
import com.shopgun.android.utils.NumberUtils;
import com.shopgun.android.utils.log.L;
import com.shopgun.android.utils.log.LogUtil;
import com.shopgun.android.verso.VersoZoomPanInfo;

class PagedPublicationLifecycle
implements Parcelable {
    public static final String TAG = PagedPublicationLifecycle.class.getSimpleName();
    private boolean mDebug = false;
    PagedPublicationConfiguration mConfig;
    private boolean mOpened = false;
    private boolean mAppeared = false;
    private boolean mResumed = false;
    private boolean[] mPageAppeared;
    private boolean[] mPageLoaded;
    private boolean[] mPageLoadedTmp;
    private boolean[] mSpreadAppeared;
    private boolean[] mSpreadZoomedIn;
    private boolean[] mSpreadZoomedInTmp;
    public static final Parcelable.Creator<PagedPublicationLifecycle> CREATOR = new Parcelable.Creator<PagedPublicationLifecycle>(){

        public PagedPublicationLifecycle createFromParcel(Parcel source) {
            return new PagedPublicationLifecycle(source);
        }

        public PagedPublicationLifecycle[] newArray(int size) {
            return new PagedPublicationLifecycle[size];
        }
    };

    PagedPublicationLifecycle() {
    }

    public void setConfig(PagedPublicationConfiguration config) {
        this.mConfig = config;
    }

    private boolean isReady() {
        if (this.mConfig == null || !this.mConfig.hasData()) {
            this.log("Event called before configuration is ready");
            return false;
        }
        if (this.mPageAppeared == null) {
            this.ensureArrays(this.mConfig.getPageCount(), this.mConfig.getSpreadCount());
        }
        return true;
    }

    private boolean isReadyAndResumed() {
        if (this.isReady()) {
            if (this.mResumed) {
                return true;
            }
            this.log("Lifecycle not resumed - event likely ignored");
        }
        return false;
    }

    private void log(String msg) {
        if (this.mDebug) {
            LogUtil.printStackTrace((String)TAG, (int)4, (int)100);
            L.d((String)TAG, (String)msg);
        }
    }

    public void ensureArrays(int pageCount, int spreadCount) {
        this.mPageAppeared = new boolean[pageCount];
        this.mPageLoaded = new boolean[pageCount];
        this.mPageLoadedTmp = new boolean[pageCount];
        this.mSpreadAppeared = new boolean[spreadCount];
        this.mSpreadZoomedIn = new boolean[spreadCount];
        this.mSpreadZoomedInTmp = new boolean[spreadCount];
    }

    public void resetSpreadsPagesLoadedAndZoom() {
        this.mPageAppeared = null;
        this.mPageLoaded = null;
        this.mPageLoadedTmp = null;
        this.mSpreadAppeared = null;
        this.mSpreadZoomedIn = null;
        this.mSpreadZoomedInTmp = null;
    }

    void resumed() {
        this.mResumed = true;
        this.appeared();
    }

    void paused() {
        this.disappeared();
        this.mResumed = false;
    }

    void opened() {
        if (this.isReady() && !this.mOpened) {
            this.mOpened = true;
            PagedPublicationEvent.opened(this.mConfig).track();
        }
    }

    void appeared() {
        this.opened();
        if (this.isReadyAndResumed() && !this.mAppeared) {
            this.mAppeared = true;
        }
    }

    void disappeared() {
        if (this.isReady() && this.mAppeared) {
            this.mAppeared = false;
            for (int i = 0; i < this.mSpreadAppeared.length; ++i) {
                this.spreadDisappeared(i, this.mConfig.getPagesFromSpreadPosition(i));
            }
        }
    }

    void pageAppeared(int page) {
        if (this.isReadyAndResumed() && !this.mPageAppeared[page]) {
            int sp = this.mConfig.getSpreadPositionFromPage(page);
            if (this.mSpreadAppeared[sp]) {
                this.mPageAppeared[page] = true;
                if (this.mPageLoaded[page]) {
                    this.pageLoaded(page);
                }
            } else {
                L.d((String)TAG, (String)("Page " + page + " appeared before it's spread"));
            }
        }
    }

    void pageDisappeared(int page) {
        if (this.isReady() && this.mPageAppeared[page]) {
            this.mPageAppeared[page] = false;
            this.mPageLoaded[page] = false;
        }
    }

    void spreadAppeared(int spread, int[] pageNumbers, boolean callPagesAppear) {
        if (this.isReadyAndResumed() && this.mAppeared && !this.mSpreadAppeared[spread]) {
            this.mSpreadAppeared[spread] = true;
            PagedPublicationEvent.pageSpreadAppeared(this.mConfig, pageNumbers).track();
            if (callPagesAppear) {
                for (int page : pageNumbers) {
                    this.pageAppeared(page);
                }
            }
            if (this.mSpreadZoomedInTmp[spread]) {
                this.internalSpreadZoomedIn(spread, pageNumbers);
                this.mSpreadZoomedInTmp[spread] = false;
            }
            if (this.mConfig.hasOutro() && this.mConfig.getSpreadCount() - 1 == spread) {
                PagedPublicationEvent.outroAppeared(this.mConfig).track();
            }
        }
    }

    void spreadDisappeared(int spread, int[] pageNumbers) {
        if (this.isReady() && this.mSpreadAppeared[spread]) {
            this.spreadZoomedOut(spread, pageNumbers, 1.0f);
            for (int i : pageNumbers) {
                this.pageDisappeared(i);
            }
            this.mSpreadAppeared[spread] = false;
            PagedPublicationEvent.pageSpreadDisappeared(this.mConfig, pageNumbers).track();
        }
    }

    void spreadZoomedIn(VersoZoomPanInfo info) {
        this.spreadZoomedIn(info.getPosition(), info.getPages(), info.getScale());
    }

    void spreadZoomedIn(int spread, int[] pages, float scale) {
        if (this.isReadyAndResumed() && !this.mSpreadZoomedIn[spread] && scale > 1.0f) {
            this.internalSpreadZoomedIn(spread, pages);
        }
    }

    private void internalSpreadZoomedIn(int spread, int[] pages) {
        if (this.isReadyAndResumed()) {
            this.mSpreadZoomedIn[spread] = true;
            PagedPublicationEvent.pageSpreadZoomedIn(this.mConfig, pages).track();
        }
    }

    void spreadZoomedOut(VersoZoomPanInfo info) {
        this.spreadZoomedOut(info.getPosition(), info.getPages(), info.getScale());
    }

    void spreadZoomedOut(int spread, int[] pages, float scale) {
        if (this.isReady() && this.mSpreadZoomedIn[spread] && NumberUtils.isEqual((float)1.0f, (float)scale)) {
            this.mSpreadZoomedIn[spread] = false;
            PagedPublicationEvent.pageSpreadZoomedOut(this.mConfig, pages).track();
        }
    }

    void saveState() {
        System.arraycopy(this.mPageLoaded, 0, this.mPageLoadedTmp, 0, this.mPageLoadedTmp.length);
        System.arraycopy(this.mSpreadZoomedIn, 0, this.mSpreadZoomedInTmp, 0, this.mSpreadZoomedInTmp.length);
    }

    void applyState(int spread, int[] pages) {
        for (int page : pages) {
            this.mPageLoaded[page] = this.mPageLoaded[page] | this.mPageLoadedTmp[page];
        }
        this.mSpreadZoomedIn[spread] = this.mSpreadZoomedIn[spread] | this.mSpreadZoomedInTmp[spread];
    }

    void pageLoaded(int page) {
        if (this.isReady()) {
            this.mPageLoaded[page] = true;
            if (this.mPageAppeared[page]) {
                PagedPublicationEvent.pageLoaded(this.mConfig, page).track();
            }
        }
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        dest.writeByte(this.mOpened ? (byte)1 : 0);
        dest.writeByte(this.mAppeared ? (byte)1 : 0);
        dest.writeByte(this.mResumed ? (byte)1 : 0);
        dest.writeBooleanArray(this.mPageAppeared);
        dest.writeBooleanArray(this.mPageLoaded);
        dest.writeBooleanArray(this.mPageLoadedTmp);
        dest.writeBooleanArray(this.mSpreadAppeared);
        dest.writeBooleanArray(this.mSpreadZoomedIn);
        dest.writeBooleanArray(this.mSpreadZoomedInTmp);
    }

    protected PagedPublicationLifecycle(Parcel in) {
        this.mOpened = in.readByte() != 0;
        this.mAppeared = in.readByte() != 0;
        this.mResumed = in.readByte() != 0;
        this.mPageAppeared = in.createBooleanArray();
        this.mPageLoaded = in.createBooleanArray();
        this.mPageLoadedTmp = in.createBooleanArray();
        this.mSpreadAppeared = in.createBooleanArray();
        this.mSpreadZoomedIn = in.createBooleanArray();
        this.mSpreadZoomedInTmp = in.createBooleanArray();
    }
}

