/*
 * Decompiled with CFR 0.152.
 */
package com.shopgun.android.sdk.pagedpublicationkit;

import android.content.Context;
import android.content.res.Configuration;
import android.graphics.PorterDuff;
import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.os.Parcel;
import android.os.Parcelable;
import android.support.annotation.Nullable;
import android.support.v4.view.CenteredViewPager;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.ProgressBar;
import android.widget.TextView;
import com.shopgun.android.materialcolorcreator.MaterialColorImpl;
import com.shopgun.android.sdk.R;
import com.shopgun.android.sdk.pagedpublicationkit.PagedPublication;
import com.shopgun.android.sdk.pagedpublicationkit.PagedPublicationConfiguration;
import com.shopgun.android.sdk.pagedpublicationkit.PagedPublicationEvent;
import com.shopgun.android.sdk.pagedpublicationkit.PagedPublicationHotspot;
import com.shopgun.android.sdk.pagedpublicationkit.PagedPublicationHotspotCollection;
import com.shopgun.android.sdk.pagedpublicationkit.PagedPublicationLifecycle;
import com.shopgun.android.sdk.pagedpublicationkit.PagedPublicationOverlay;
import com.shopgun.android.sdk.pagedpublicationkit.PagedPublicationPage;
import com.shopgun.android.sdk.pagedpublicationkit.PublicationException;
import com.shopgun.android.sdk.utils.SgnUtils;
import com.shopgun.android.verso.VersoFragment;
import com.shopgun.android.verso.VersoPageView;
import com.shopgun.android.verso.VersoPageViewFragment;
import com.shopgun.android.verso.VersoTapInfo;
import com.shopgun.android.verso.VersoViewPager;
import com.shopgun.android.verso.VersoZoomPanInfo;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class PagedPublicationFragment
extends VersoFragment {
    public static final String TAG = PagedPublicationFragment.class.getSimpleName();
    public static final String ARG_CONFIGURATION = "arg_config";
    public static final String ARG_PAGE = "arg_page";
    public static final String SAVED_STATE = "saved_state";
    PagedPublicationConfiguration mConfig;
    FrameLayout mFrame;
    FrameLayout mFrameVerso;
    FrameLayout mFrameLoader;
    FrameLayout mFrameError;
    VersoViewPager mVersoViewPager;
    boolean mDisplayHotspotsOnTouch = true;
    OnTouchWrapper mOnTouchWrapper;
    PageChangeListener mPageChangeLisetner = new PageChangeListener();
    PagedPublicationLifecycle mLifecycle;
    String mViewSessionUuid;

    public static PagedPublicationFragment newInstance() {
        return new PagedPublicationFragment();
    }

    public static PagedPublicationFragment newInstance(PagedPublicationConfiguration config) {
        return PagedPublicationFragment.newInstance(config, 0);
    }

    public static PagedPublicationFragment newInstance(PagedPublicationConfiguration config, int page) {
        Bundle args = new Bundle();
        args.putParcelable(ARG_CONFIGURATION, (Parcelable)config);
        args.putInt(ARG_PAGE, page);
        PagedPublicationFragment f = PagedPublicationFragment.newInstance();
        f.setArguments(args);
        return f;
    }

    public PagedPublicationFragment() {
        this.mOnTouchWrapper = new OnTouchWrapper();
        super.setOnTouchListener((VersoPageViewFragment.OnTouchListener)this.mOnTouchWrapper);
        super.setOnTapListener((VersoPageViewFragment.OnTapListener)this.mOnTouchWrapper);
        super.setOnDoubleTapListener((VersoPageViewFragment.OnDoubleTapListener)this.mOnTouchWrapper);
        super.setOnLongTapListener((VersoPageViewFragment.OnLongTapListener)this.mOnTouchWrapper);
        super.setOnZoomListener((VersoPageViewFragment.OnZoomListener)this.mOnTouchWrapper);
        super.addOnPageChangeListener((VersoFragment.OnPageChangeListener)this.mPageChangeLisetner);
        super.setOnLoadCompleteListener((VersoPageViewFragment.OnLoadCompleteListener)this.mOnTouchWrapper);
    }

    public void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.mLifecycle = new PagedPublicationLifecycle();
        this.mViewSessionUuid = SgnUtils.createUUID();
        if (savedInstanceState != null && savedInstanceState.containsKey(SAVED_STATE)) {
            SavedState savedState = (SavedState)savedInstanceState.getParcelable(SAVED_STATE);
            if (savedState != null) {
                this.mConfig = savedState.config;
                this.mDisplayHotspotsOnTouch = savedState.displayHotspotOnTouch;
                this.mViewSessionUuid = savedState.viewSessionUuid;
                this.setupConfigAndTrackers();
            }
        } else if (this.getArguments() != null) {
            this.mConfig = (PagedPublicationConfiguration)this.getArguments().getParcelable(ARG_CONFIGURATION);
            if (this.getArguments().containsKey(ARG_PAGE)) {
                int page = this.getArguments().getInt(ARG_PAGE);
                this.setPage(page);
            }
        }
    }

    @Nullable
    public View onCreateView(LayoutInflater inflater, @Nullable ViewGroup container, @Nullable Bundle savedInstanceState) {
        this.mVersoViewPager = (VersoViewPager)super.onCreateView(inflater, container, savedInstanceState);
        this.mFrame = (FrameLayout)inflater.inflate(R.layout.shopgun_sdk_pagedpublication, container, false);
        this.mFrameVerso = (FrameLayout)this.mFrame.findViewById(R.id.verso);
        this.mFrameError = (FrameLayout)this.mFrame.findViewById(R.id.error);
        this.mFrameLoader = (FrameLayout)this.mFrame.findViewById(R.id.loader);
        this.setVisible(false, false, false);
        if (this.getVersoSpreadConfiguration() == null) {
            this.setPublicationConfiguration(this.mConfig);
        }
        return this.mFrame;
    }

    public void onViewStateRestored(@Nullable Bundle savedInstanceState) {
        this.setupConfigAndTrackers();
        super.onViewStateRestored(savedInstanceState);
    }

    private void setupConfigAndTrackers() {
        Configuration config = this.getResources().getConfiguration();
        this.mConfig.onConfigurationChanged(config);
        this.mLifecycle.setConfig(this.mConfig);
        this.mLifecycle.resetSpreadsPagesLoadedAndZoom();
    }

    public PagedPublicationConfiguration getPublicationConfiguration() {
        return this.mConfig;
    }

    public void setPublicationConfiguration(PagedPublicationConfiguration configuration) {
        if (configuration != null) {
            this.mConfig = configuration;
            this.mLifecycle.setConfig(this.mConfig);
            this.setVersoSpreadConfiguration(this.mConfig);
            this.loadPagedPublication();
        }
    }

    protected void onInternalPause() {
        if (this.isCurrentSpreadScaled()) {
            this.resetCurrentSpreadScale(false);
        }
        this.mLifecycle.spreadDisappeared(this.getPosition(), this.getCurrentPages());
        this.mLifecycle.resetSpreadsPagesLoadedAndZoom();
        super.onInternalPause();
    }

    protected void onInternalResume(Configuration config) {
        this.mLifecycle.resumed();
        super.onInternalResume(config);
    }

    public void onResume() {
        super.onResume();
        this.loadPagedPublication();
    }

    public void onPause() {
        super.onPause();
        this.mLifecycle.paused();
        if (this.mConfig != null) {
            this.mConfig.cancel();
        }
    }

    public void onSaveInstanceState(Bundle outState) {
        if (this.mConfig != null) {
            this.mConfig.cancel();
        }
        outState.putParcelable(SAVED_STATE, (Parcelable)new SavedState(this));
        super.onSaveInstanceState(outState);
    }

    private void loadPagedPublication() {
        if (this.mConfig != null) {
            if (this.mConfig.isLoading()) {
                return;
            }
            if (this.mConfig.getPublication() != null && this.mConfig.hasPages() && this.mConfig.hasHotspotCollection()) {
                this.notifyVersoConfigurationChanged();
                return;
            }
            this.showLoaderView();
            this.mConfig.load(new PagedPublicationOnLoadComplete());
        }
    }

    private void ensurePublicationBranding() {
        PagedPublication pub;
        PagedPublication pagedPublication = pub = this.mConfig == null ? null : this.mConfig.getPublication();
        if (pub != null && this.mFrame != null) {
            int bgColor = pub.getBackgroundColor();
            this.mFrame.setBackgroundColor(bgColor);
            ProgressBar bar = (ProgressBar)this.mFrameLoader.findViewById(R.id.circulareProgressBar);
            if (bar != null && bar.getIndeterminateDrawable() != null) {
                bar.setIndeterminate(true);
                MaterialColorImpl c = new MaterialColorImpl(bgColor);
                bar.getIndeterminateDrawable().setColorFilter(c.getSecondaryText(), PorterDuff.Mode.MULTIPLY);
            }
        }
    }

    private void showVersoView() {
        if (this.mFrameVerso != null && this.mFrameVerso.getVisibility() != 0) {
            this.ensurePublicationBranding();
            this.mFrameVerso.removeAllViews();
            this.mFrameVerso.addView((View)this.mVersoViewPager);
            this.mVersoViewPager.addOnPageChangeListener((CenteredViewPager.OnPageChangeListener)new PageScrolledListener());
            this.setVisible(true, false, false);
        }
        this.mLifecycle.appeared();
    }

    private void showLoaderView() {
        if (this.mFrameLoader != null && this.mFrameLoader.getVisibility() != 0) {
            this.ensurePublicationBranding();
            this.setVisible(false, true, false);
        }
    }

    private void showErrorView(PublicationException ex) {
        if (this.mFrameError != null && this.mFrameError.getVisibility() != 0) {
            this.ensurePublicationBranding();
            this.mFrameError.removeAllViews();
            View errorView = this.getErrorView((ViewGroup)this.mFrame, ex);
            this.mFrameError.addView(errorView);
            this.setVisible(false, false, true);
        }
    }

    private void setVisible(boolean verso, boolean loader, boolean error) {
        if (this.mFrame != null) {
            this.mFrameVerso.setVisibility(verso ? 0 : 8);
            this.mFrameLoader.setVisibility(loader ? 0 : 8);
            this.mFrameError.setVisibility(error ? 0 : 8);
        }
    }

    public View getErrorView(ViewGroup container, PublicationException ex) {
        LayoutInflater i = LayoutInflater.from((Context)container.getContext());
        View v = i.inflate(R.layout.shopgun_sdk_pagedpublication_error, container, false);
        TextView msg = (TextView)v.findViewById(R.id.message);
        msg.setText((CharSequence)ex.getMessage());
        return v;
    }

    public void notifyVersoConfigurationChanged() {
        if (this.mConfig.hasData()) {
            this.mLifecycle.opened();
            this.showVersoView();
            super.notifyVersoConfigurationChanged();
        }
    }

    public boolean isDisplayHotspotsOnTouch() {
        return this.mDisplayHotspotsOnTouch;
    }

    public void setDisplayHotspotsOnTouch(boolean displayHotspotsOnTouch) {
        this.mDisplayHotspotsOnTouch = displayHotspotsOnTouch;
    }

    public void setOnTapListener(VersoPageViewFragment.OnTapListener tapListener) {
        this.mOnTouchWrapper.mTapListener = tapListener;
    }

    public void setOnDoubleTapListener(VersoPageViewFragment.OnDoubleTapListener doubleTapListener) {
        this.mOnTouchWrapper.mDoubleTapListener = doubleTapListener;
    }

    public void setOnHotspotTapListener(OnHotspotTapListener tapListener) {
        this.mOnTouchWrapper.mHotspotTapListener = tapListener;
    }

    public void setOnLongTapListener(VersoPageViewFragment.OnLongTapListener longTapListener) {
        this.mOnTouchWrapper.mLongTapListener = longTapListener;
    }

    public void setOnHotspotLongTapListener(OnHotspotLongTapListener longTapListener) {
        this.mOnTouchWrapper.mHotspotLongTapListener = longTapListener;
    }

    public void setOnZoomListener(VersoPageViewFragment.OnZoomListener zoomListener) {
        this.mOnTouchWrapper.mZoomListener = zoomListener;
    }

    public void onPublicationDisappeared() {
        this.mLifecycle.saveState();
        this.mLifecycle.disappeared();
    }

    public void onPublicationAppeared() {
        int spread = this.getPosition();
        int[] pages = this.mConfig.getPagesFromSpreadPosition(spread);
        this.mLifecycle.applyState(spread, pages);
        this.mLifecycle.appeared();
        this.mLifecycle.spreadAppeared(spread, pages, true);
    }

    private static class SavedState
    implements Parcelable {
        PagedPublicationConfiguration config;
        boolean displayHotspotOnTouch;
        String viewSessionUuid;
        public static final Parcelable.Creator<SavedState> CREATOR = new Parcelable.Creator<SavedState>(){

            public SavedState createFromParcel(Parcel source) {
                return new SavedState(source);
            }

            public SavedState[] newArray(int size) {
                return new SavedState[size];
            }
        };

        private SavedState(PagedPublicationFragment f) {
            this.config = f.mConfig;
            this.displayHotspotOnTouch = f.mDisplayHotspotsOnTouch;
            this.viewSessionUuid = f.mViewSessionUuid;
        }

        public int describeContents() {
            return 0;
        }

        public void writeToParcel(Parcel dest, int flags) {
            dest.writeParcelable((Parcelable)this.config, flags);
            dest.writeByte(this.displayHotspotOnTouch ? (byte)1 : 0);
            dest.writeString(this.viewSessionUuid);
        }

        protected SavedState(Parcel in) {
            this.config = (PagedPublicationConfiguration)in.readParcelable(PagedPublicationConfiguration.class.getClassLoader());
            this.displayHotspotOnTouch = in.readByte() != 0;
            this.viewSessionUuid = in.readString();
        }
    }

    private class PageChangeListener
    implements VersoFragment.OnPageChangeListener {
        boolean mDisappearPreviousSpread = false;

        private PageChangeListener() {
        }

        public void onPagesScrolled(int currentPosition, int[] currentPages, int previousPosition, int[] previousPages) {
        }

        public void onPagesChanged(int currentPosition, int[] currentPages, int previousPosition, int[] previousPages) {
            if (this.mDisappearPreviousSpread) {
                PagedPublicationFragment.this.mLifecycle.spreadDisappeared(previousPosition, previousPages);
            }
            this.mDisappearPreviousSpread = false;
            PagedPublicationFragment.this.mLifecycle.spreadAppeared(currentPosition, currentPages, true);
        }

        public void onVisiblePageIndexesChanged(int[] pages, int[] added, int[] removed) {
        }
    }

    private class PageScrolledListener
    implements CenteredViewPager.OnPageChangeListener {
        int mLastState = 0;
        int mDragFromSpread;
        int[] mDragFromPages;

        private PageScrolledListener() {
        }

        public void onPageScrolled(int position, float positionOffset, int positionOffsetPixels) {
        }

        public void onPageSelected(int position) {
        }

        public void onPageScrollStateChanged(int state) {
            switch (state) {
                case 1: {
                    this.mDragFromSpread = PagedPublicationFragment.this.getPosition();
                    this.mDragFromPages = PagedPublicationFragment.this.mConfig.getPagesFromSpreadPosition(this.mDragFromSpread);
                    PagedPublicationFragment.this.mLifecycle.saveState();
                    PagedPublicationFragment.this.mLifecycle.spreadDisappeared(this.mDragFromSpread, this.mDragFromPages);
                    break;
                }
                case 0: {
                    if (this.mDragFromSpread != PagedPublicationFragment.this.getPosition() || this.mDragFromPages == null) break;
                    PagedPublicationFragment.this.mLifecycle.applyState(this.mDragFromSpread, this.mDragFromPages);
                    PagedPublicationFragment.this.mLifecycle.spreadAppeared(this.mDragFromSpread, this.mDragFromPages, true);
                    break;
                }
                case 2: {
                    if (this.mLastState == 1) break;
                    PagedPublicationFragment.this.mPageChangeLisetner.mDisappearPreviousSpread = true;
                }
            }
            this.mLastState = state;
        }
    }

    public class PublicationTapInfo
    extends VersoTapInfo {
        private final List<PagedPublicationHotspot> mHotspots;

        public PublicationTapInfo(VersoTapInfo info) {
            super(info);
            this.mHotspots = this.findHotspots(info);
        }

        public PublicationTapInfo(PublicationTapInfo info) {
            super((VersoTapInfo)info);
            this.mHotspots = info.mHotspots;
        }

        public List<PagedPublicationHotspot> getHotspots() {
            return this.mHotspots;
        }

        public boolean hasHotspots() {
            return this.mHotspots != null && !this.mHotspots.isEmpty();
        }

        private List<PagedPublicationHotspot> findHotspots(VersoTapInfo info) {
            PagedPublicationHotspotCollection collection = PagedPublicationFragment.this.mConfig.getHotspotCollection();
            if (collection != null && info.isContentClicked()) {
                int[] pages = Arrays.copyOf(info.getPages(), info.getPages().length);
                int introOffset = PagedPublicationFragment.this.mConfig.hasIntro() ? -1 : 0;
                for (int i = 0; i < pages.length; ++i) {
                    pages[i] = pages[i] + introOffset;
                }
                int pageTapped = info.getPageTapped() + introOffset;
                return collection.getPagedPublicationHotspots(pages, pageTapped, info.getPercentX(), info.getPercentY());
            }
            return new ArrayList<PagedPublicationHotspot>();
        }
    }

    private class OnTouchWrapper
    implements VersoPageViewFragment.OnTapListener,
    VersoPageViewFragment.OnLongTapListener,
    VersoPageViewFragment.OnTouchListener,
    VersoPageViewFragment.OnDoubleTapListener,
    VersoPageViewFragment.OnZoomListener,
    VersoPageViewFragment.OnLoadCompleteListener,
    Handler.Callback {
        private static final int DELAY = 100;
        private static final int WHAT_TAP = 1;
        private static final int WHAT_LONG_TAP = 2;
        OnHotspotTapListener mHotspotTapListener;
        VersoPageViewFragment.OnTapListener mTapListener;
        VersoPageViewFragment.OnDoubleTapListener mDoubleTapListener;
        OnHotspotLongTapListener mHotspotLongTapListener;
        VersoPageViewFragment.OnLongTapListener mLongTapListener;
        VersoPageViewFragment.OnZoomListener mZoomListener;
        VersoPageViewFragment.OnLoadCompleteListener mLoadCompleteListener;
        Handler mHandler = new Handler(Looper.getMainLooper(), (Handler.Callback)this);
        boolean zoomBegin = false;

        private OnTouchWrapper() {
        }

        public boolean onTap(VersoTapInfo info) {
            if (this.mTapListener != null) {
                this.mTapListener.onTap(info);
            }
            PagedPublicationEvent.pageClicked(PagedPublicationFragment.this.mConfig, info).track();
            PublicationTapInfo pti = new PublicationTapInfo(info);
            if (pti.hasHotspots()) {
                this.post(1, pti);
                this.showHotspots(pti);
                PagedPublicationEvent.pageHotspotClicked(PagedPublicationFragment.this.mConfig, info).track();
            }
            return true;
        }

        public boolean onDoubleTap(VersoTapInfo info) {
            PagedPublicationEvent.pageDoubleClicked(PagedPublicationFragment.this.mConfig, info).track();
            return this.mDoubleTapListener != null && this.mDoubleTapListener.onDoubleTap(info);
        }

        public void onLongTap(VersoTapInfo info) {
            if (this.mLongTapListener != null) {
                this.mLongTapListener.onLongTap(info);
            }
            PagedPublicationEvent.pageLongClicked(PagedPublicationFragment.this.mConfig, info).track();
            PublicationTapInfo pti = new PublicationTapInfo(info);
            if (pti.hasHotspots()) {
                this.post(2, pti);
                this.showHotspots(pti);
                PagedPublicationEvent.pageHotspotClicked(PagedPublicationFragment.this.mConfig, info).track();
            }
        }

        public void onZoom(VersoZoomPanInfo info) {
            if (this.mZoomListener != null) {
                this.mZoomListener.onZoom(info);
            }
            if (this.zoomBegin && info.getScale() > 1.0f) {
                this.zoomBegin = false;
                PagedPublicationFragment.this.mLifecycle.spreadZoomedIn(info);
            }
        }

        public void onZoomBegin(VersoZoomPanInfo info) {
            PagedPublicationFragment.this.mVersoViewPager.setPagingEnabled(false);
            if (this.mZoomListener != null) {
                this.mZoomListener.onZoomBegin(info);
            }
            this.zoomBegin = true;
        }

        public void onZoomEnd(VersoZoomPanInfo info) {
            PagedPublicationFragment.this.mVersoViewPager.setPagingEnabled(!PagedPublicationFragment.this.isCurrentSpreadScaled());
            if (this.mZoomListener != null) {
                this.mZoomListener.onZoomEnd(info);
            }
            this.zoomBegin = false;
            PagedPublicationFragment.this.mLifecycle.spreadZoomedOut(info);
        }

        public void onPageLoadComplete(boolean success, VersoPageView versoPageView) {
            if (this.mLoadCompleteListener != null) {
                this.mLoadCompleteListener.onPageLoadComplete(success, versoPageView);
            }
            if (success) {
                PagedPublicationFragment.this.mLifecycle.pageLoaded(versoPageView.getPage());
            }
        }

        public boolean onTouch(int action, VersoTapInfo info) {
            switch (action) {
                case 1: 
                case 3: {
                    this.dismissHotspots(new PublicationTapInfo(info));
                }
            }
            return false;
        }

        private void showHotspots(PublicationTapInfo info) {
            if (!PagedPublicationFragment.this.mDisplayHotspotsOnTouch) {
                return;
            }
            PagedPublicationOverlay o = this.getSpreadOverlay(info);
            if (o != null) {
                o.showHotspots(info);
            }
        }

        private void dismissHotspots(PublicationTapInfo info) {
            PagedPublicationOverlay o = this.getSpreadOverlay(info);
            if (o != null) {
                o.hideHotspots(info);
            }
        }

        private PagedPublicationOverlay getSpreadOverlay(PublicationTapInfo info) {
            View v;
            if (info != null && info.getFragment() != null && (v = info.getFragment().getSpreadOverlay()) instanceof PagedPublicationOverlay) {
                return (PagedPublicationOverlay)v;
            }
            return null;
        }

        private void post(int what, PublicationTapInfo info) {
            Message msg = Message.obtain((Handler)this.mHandler, (int)what, (Object)((Object)info));
            this.mHandler.sendMessageDelayed(msg, 100L);
        }

        public boolean handleMessage(Message msg) {
            switch (msg.what) {
                case 1: {
                    if (this.mHotspotTapListener == null) break;
                    PublicationTapInfo info = (PublicationTapInfo)((Object)msg.obj);
                    this.mHotspotTapListener.onHotspotsTap(info.getHotspots());
                    break;
                }
                case 2: {
                    if (this.mHotspotLongTapListener == null) break;
                    PublicationTapInfo info = (PublicationTapInfo)((Object)msg.obj);
                    this.mHotspotLongTapListener.onHotspotsLongTap(info.getHotspots());
                }
            }
            return false;
        }
    }

    public static interface OnHotspotLongTapListener {
        public void onHotspotsLongTap(List<PagedPublicationHotspot> var1);
    }

    public static interface OnHotspotTapListener {
        public void onHotspotsTap(List<PagedPublicationHotspot> var1);
    }

    private class PagedPublicationOnLoadComplete
    implements PagedPublicationConfiguration.OnLoadComplete {
        private PagedPublicationOnLoadComplete() {
        }

        @Override
        public void onPublicationLoaded(PagedPublication publication) {
            PagedPublicationFragment.this.notifyVersoConfigurationChanged();
        }

        @Override
        public void onPagesLoaded(List<? extends PagedPublicationPage> pages) {
            PagedPublicationFragment.this.notifyVersoConfigurationChanged();
        }

        @Override
        public void onHotspotsLoaded(PagedPublicationHotspotCollection hotspots) {
            PagedPublicationFragment.this.notifyVersoConfigurationChanged();
        }

        @Override
        public void onError(List<PublicationException> ex) {
            if (!PagedPublicationFragment.this.mConfig.hasData()) {
                PagedPublicationFragment.this.showErrorView(ex != null && !ex.isEmpty() ? ex.get(0) : new PublicationException("Unknown error occurred"));
            }
        }
    }
}

