/*
 * Decompiled with CFR 0.152.
 */
package com.shopgun.android.sdk.pagedpublicationkit;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.shopgun.android.sdk.eventskit.EzEvent;
import com.shopgun.android.sdk.pagedpublicationkit.PagedPublicationConfiguration;
import com.shopgun.android.verso.VersoTapInfo;

public class PagedPublicationEvent
extends EzEvent {
    public static final String TAG = PagedPublicationEvent.class.getSimpleName();

    PagedPublicationEvent(String type, JsonObject properties) {
        super(type, properties);
    }

    private static JsonArray idField(String id) {
        return PagedPublicationEvent.idField(true, id);
    }

    private static JsonArray idField(boolean legacy, String id) {
        JsonArray array = new JsonArray();
        array.add(legacy ? "legacy" : "graph");
        array.add(id);
        return array;
    }

    private static JsonObject publication(String publicationId, String ownedBy) {
        JsonObject pagedPublication = new JsonObject();
        pagedPublication.add("id", (JsonElement)PagedPublicationEvent.idField(publicationId));
        pagedPublication.add("ownedBy", (JsonElement)PagedPublicationEvent.idField(ownedBy));
        JsonObject properties = new JsonObject();
        properties.add("pagedPublication", (JsonElement)pagedPublication);
        return properties;
    }

    private static PagedPublicationEvent publication(String type, String publicationId, String ownedBy) {
        return new PagedPublicationEvent(type, PagedPublicationEvent.publication(publicationId, ownedBy));
    }

    private static JsonObject page(String publicationId, String ownedBy, int pageNumber) {
        JsonObject props = PagedPublicationEvent.publication(publicationId, ownedBy);
        JsonObject pagedPublicationPage = new JsonObject();
        pagedPublicationPage.addProperty("pageNumber", (Number)pageNumber);
        props.add("pagedPublicationPage", (JsonElement)pagedPublicationPage);
        return props;
    }

    private static PagedPublicationEvent page(String type, String publicationId, String ownedBy, int pageNumber) {
        return new PagedPublicationEvent(type, PagedPublicationEvent.page(publicationId, ownedBy, pageNumber + 1));
    }

    private static JsonObject getPageClickProperties(String publicationId, String ownedBy, int pageNumber, float x, float y) {
        JsonObject props = PagedPublicationEvent.publication(publicationId, ownedBy);
        JsonObject pagedPublicationPage = new JsonObject();
        pagedPublicationPage.addProperty("pageNumber", (Number)(pageNumber + 1));
        pagedPublicationPage.addProperty("x", (Number)Float.valueOf(x));
        pagedPublicationPage.addProperty("y", (Number)Float.valueOf(y));
        props.add("pagedPublicationPage", (JsonElement)pagedPublicationPage);
        return props;
    }

    private static PagedPublicationEvent getPageClickProperties(String type, String publicationId, String ownedBy, int pageNumber, float x, float y) {
        return new PagedPublicationEvent(type, PagedPublicationEvent.getPageClickProperties(publicationId, ownedBy, pageNumber, x, y));
    }

    private static JsonObject getPageSpreadProperties(String publicationId, String ownedBy, int[] pages) {
        JsonObject props = PagedPublicationEvent.publication(publicationId, ownedBy);
        JsonObject pagedPublicationPageSpread = new JsonObject();
        JsonArray pageNumbers = new JsonArray();
        for (int page : pages) {
            pageNumbers.add((Number)(page + 1));
        }
        pagedPublicationPageSpread.add("pageNumbers", (JsonElement)pageNumbers);
        props.add("pagedPublicationPageSpread", (JsonElement)pagedPublicationPageSpread);
        return props;
    }

    private static PagedPublicationEvent getPageSpreadProperties(String type, String publicationId, String ownedBy, int[] pageNumbers) {
        return new PagedPublicationEvent(type, PagedPublicationEvent.getPageSpreadProperties(publicationId, ownedBy, pageNumbers));
    }

    public static PagedPublicationEvent opened(PagedPublicationConfiguration config) {
        return PagedPublicationEvent.publication("paged-publication-opened", config.getPublication().getId(), config.getPublication().getOwnerId());
    }

    public static PagedPublicationEvent disappeared(PagedPublicationConfiguration config) {
        return PagedPublicationEvent.publication("paged-publication-disappeared", config.getPublication().getId(), config.getPublication().getOwnerId());
    }

    public static PagedPublicationEvent appeared(PagedPublicationConfiguration config) {
        return PagedPublicationEvent.publication("paged-publication-appeared", config.getPublication().getId(), config.getPublication().getOwnerId());
    }

    public static PagedPublicationEvent pageAppeared(PagedPublicationConfiguration config, int pageNumber) {
        return PagedPublicationEvent.page("paged-publication-page-appeared", config.getPublication().getId(), config.getPublication().getOwnerId(), pageNumber);
    }

    public static PagedPublicationEvent pageDisappeared(PagedPublicationConfiguration config, int pageNumber) {
        return PagedPublicationEvent.page("paged-publication-page-disappeared", config.getPublication().getId(), config.getPublication().getOwnerId(), pageNumber);
    }

    public static PagedPublicationEvent pageLoaded(PagedPublicationConfiguration config, int pageNumber) {
        return PagedPublicationEvent.page("paged-publication-page-loaded", config.getPublication().getId(), config.getPublication().getOwnerId(), pageNumber);
    }

    public static PagedPublicationEvent outroAppeared(PagedPublicationConfiguration config) {
        return PagedPublicationEvent.publication("x-paged-publication-outro-appeared", config.getPublication().getId(), config.getPublication().getOwnerId());
    }

    public static PagedPublicationEvent pageClicked(PagedPublicationConfiguration config, VersoTapInfo i) {
        return PagedPublicationEvent.getPageClickProperties("paged-publication-page-clicked", config.getPublication().getId(), config.getPublication().getOwnerId(), i.getPageTapped(), i.getPercentX(), i.getPercentY());
    }

    public static PagedPublicationEvent pageDoubleClicked(PagedPublicationConfiguration config, VersoTapInfo i) {
        return PagedPublicationEvent.getPageClickProperties("paged-publication-page-double-clicked", config.getPublication().getId(), config.getPublication().getOwnerId(), i.getPageTapped(), i.getPercentX(), i.getPercentY());
    }

    public static PagedPublicationEvent pageHotspotClicked(PagedPublicationConfiguration config, VersoTapInfo i) {
        return PagedPublicationEvent.getPageClickProperties("paged-publication-page-hotspots-clicked", config.getPublication().getId(), config.getPublication().getOwnerId(), i.getPageTapped(), i.getPercentX(), i.getPercentY());
    }

    public static PagedPublicationEvent pageLongClicked(PagedPublicationConfiguration config, VersoTapInfo i) {
        return PagedPublicationEvent.getPageClickProperties("paged-publication-page-long-pressed", config.getPublication().getId(), config.getPublication().getOwnerId(), i.getPageTapped(), i.getPercentX(), i.getPercentY());
    }

    public static PagedPublicationEvent pageSpreadAppeared(PagedPublicationConfiguration config, int[] pageNumbers) {
        return PagedPublicationEvent.getPageSpreadProperties("paged-publication-page-spread-appeared", config.getPublication().getId(), config.getPublication().getOwnerId(), pageNumbers);
    }

    public static PagedPublicationEvent pageSpreadDisappeared(PagedPublicationConfiguration config, int[] pageNumbers) {
        return PagedPublicationEvent.getPageSpreadProperties("paged-publication-page-spread-disappeared", config.getPublication().getId(), config.getPublication().getOwnerId(), pageNumbers);
    }

    public static PagedPublicationEvent pageSpreadZoomedIn(PagedPublicationConfiguration config, int[] pageNumbers) {
        return PagedPublicationEvent.getPageSpreadProperties("paged-publication-page-spread-zoomed-in", config.getPublication().getId(), config.getPublication().getOwnerId(), pageNumbers);
    }

    public static PagedPublicationEvent pageSpreadZoomedOut(PagedPublicationConfiguration config, int[] pageNumbers) {
        return PagedPublicationEvent.getPageSpreadProperties("paged-publication-page-spread-zoomed-out", config.getPublication().getId(), config.getPublication().getOwnerId(), pageNumbers);
    }
}

