/*
 * Decompiled with CFR 0.152.
 */
package com.shopgun.android.sdk.network.impl;

import com.shopgun.android.sdk.log.SgnLog;
import com.shopgun.android.sdk.network.Cache;
import com.shopgun.android.sdk.network.NetworkResponse;
import com.shopgun.android.sdk.network.Request;
import com.shopgun.android.sdk.network.Response;
import com.shopgun.android.sdk.utils.Constants;
import com.shopgun.android.sdk.utils.SgnUtils;
import java.io.UnsupportedEncodingException;

public class StringRequest
extends Request<String> {
    public static final String TAG = Constants.getTag(StringRequest.class);
    private static final String PROTOCOL_CONTENT_TYPE = String.format("text/plain; charset=%s", "utf-8");
    private String mRequestBody;
    private Request.Priority mPriority = Request.Priority.MEDIUM;

    public StringRequest(String url, Response.Listener<String> listener) {
        super(Request.Method.GET, url, listener);
    }

    public StringRequest(Request.Method method, String url, String requestBody, Response.Listener<String> listener) {
        super(method, url, listener);
        boolean nonBodyRequest;
        boolean bl = nonBodyRequest = method == Request.Method.GET || method == Request.Method.DELETE;
        if (nonBodyRequest && requestBody != null) {
            SgnLog.i(TAG, "GET and DELETE requests doesn't take a body, and will be ignored.\nPlease append any parameters to Request.putQueryParameters()");
        }
        this.mRequestBody = requestBody;
    }

    @Override
    public String getBodyContentType() {
        return PROTOCOL_CONTENT_TYPE;
    }

    @Override
    public byte[] getBody() {
        try {
            return this.mRequestBody == null ? null : this.mRequestBody.getBytes("utf-8");
        }
        catch (UnsupportedEncodingException uee) {
            return null;
        }
    }

    @Override
    public Request.Priority getPriority() {
        return this.mPriority;
    }

    public StringRequest setPriority(Request.Priority p) {
        this.mPriority = p;
        return this;
    }

    @Override
    protected Response<String> parseNetworkResponse(NetworkResponse response) {
        String string;
        try {
            string = new String(response.data, this.getParamsEncoding());
        }
        catch (UnsupportedEncodingException e) {
            string = new String(response.data);
        }
        String url = SgnUtils.requestToUrlAndQueryString(this);
        Cache.Item c = new Cache.Item(string, this.getCacheTTL());
        this.getCache().put(url, c);
        Response<String> r = Response.fromSuccess(string, this.getCache());
        return r;
    }

    @Override
    protected Response<String> parseCache(Cache c) {
        String url = SgnUtils.requestToUrlAndQueryString(this);
        Cache.Item ci = c.get(url);
        if (ci != null && ci.object instanceof String) {
            return Response.fromSuccess((String)ci.object, null);
        }
        return null;
    }
}

