/*
 * Decompiled with CFR 0.152.
 */
package com.shopgun.android.sdk.network.impl;

import com.shopgun.android.sdk.log.SgnLog;
import com.shopgun.android.sdk.network.Request;
import com.shopgun.android.sdk.network.RequestDebugger;
import com.shopgun.android.sdk.network.ShopGunError;
import com.shopgun.android.sdk.utils.Constants;
import com.shopgun.android.utils.log.Logger;

public class NetworkDebugger
implements RequestDebugger {
    public static final String TAG = Constants.getTag(NetworkDebugger.class);
    private final String mTag;
    private final Logger mLogger;

    public NetworkDebugger() {
        this(SgnLog.getLogger(), TAG);
    }

    public NetworkDebugger(String tag) {
        this(SgnLog.getLogger(), tag);
    }

    public NetworkDebugger(Logger logger, String tag) {
        this.mLogger = logger;
        this.mTag = tag;
    }

    @Override
    public void onFinish(Request<?> req) {
        this.mLogger.d(this.mTag, req.getNetworkLog().toString());
        this.mLogger.d(this.mTag, req.getLog().getString(this.getClass().getSimpleName()));
    }

    @Override
    public void onDelivery(Request<?> r, Object response, ShopGunError error) {
        this.mLogger.d(TAG, "TotalDuration: " + r.getLog().getTotalDuration());
    }
}

