/*
 * Decompiled with CFR 0.152.
 */
package com.shopgun.android.sdk.network;

import android.os.Parcel;
import android.os.Parcelable;
import com.shopgun.android.sdk.model.interfaces.IJson;
import com.shopgun.android.sdk.network.impl.ApiError;
import com.shopgun.android.sdk.utils.Constants;
import com.shopgun.android.sdk.utils.SgnJson;
import org.json.JSONObject;

public class ShopGunError
extends Exception
implements IJson<JSONObject>,
Parcelable {
    public static final String TAG = Constants.getTag(ShopGunError.class);
    private static final long serialVersionUID = 1L;
    private static final String DEF_MESSAGE = "Unknown error";
    private static final String DEF_DETAILS = "Unknown error. No information available. Please contact support.";
    private final String mId;
    private final int mCode;
    private final String mDetails;
    private final String mFailedOnField;
    public static final Parcelable.Creator<ShopGunError> CREATOR = new Parcelable.Creator<ShopGunError>(){

        public ShopGunError createFromParcel(Parcel source) {
            return new ShopGunError(source);
        }

        public ShopGunError[] newArray(int size) {
            return new ShopGunError[size];
        }
    };

    public ShopGunError(Throwable t, int code, String message, String id, String details, String failedOnField) {
        super(message, t);
        this.mCode = code;
        this.mId = id;
        this.mDetails = details;
        this.mFailedOnField = failedOnField;
    }

    public ShopGunError(int code, String message, String id, String details, String failedOnField) {
        this(null, code, message, id, details, failedOnField);
    }

    public ShopGunError() {
        this(null, 10000, DEF_MESSAGE, null, DEF_DETAILS, null);
    }

    public ShopGunError(int code, String message, String details) {
        this(null, code, message, null, details, null);
    }

    public ShopGunError(Throwable t, int code, String message, String details) {
        this(t, code, message, null, details, null);
    }

    public static ShopGunError fromJSON(JSONObject apiError) {
        SgnJson o = new SgnJson(apiError);
        String id = o.getId();
        int code = o.getInt("code", 10000);
        String message = o.getString("message", DEF_MESSAGE);
        String details = o.getString("details", DEF_DETAILS);
        String failedOnField = o.getString("failed_on_field");
        return new ApiError(code, message, id, details, failedOnField);
    }

    public String getId() {
        return this.mId;
    }

    public int getCode() {
        return this.mCode;
    }

    public String getDetails() {
        return this.mDetails;
    }

    public String getFailedOnField() {
        return this.mFailedOnField;
    }

    @Override
    public JSONObject toJSON() {
        return new SgnJson().put("id", this.getId()).put("code", this.getCode()).put("message", this.getMessage()).put("details", this.getDetails()).put("failed_on_field", this.getFailedOnField()).toJSON();
    }

    public boolean isSdk() {
        int code = this.getCode();
        return 10000 <= code && code < 11000;
    }

    public boolean isApi() {
        int code = this.getCode();
        return 1000 <= code && code < 10000;
    }

    @Override
    public String toString() {
        return this.toJSON().toString();
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        dest.writeString(this.mId);
        dest.writeInt(this.mCode);
        dest.writeString(this.mDetails);
        dest.writeString(this.mFailedOnField);
    }

    protected ShopGunError(Parcel in) {
        this.mId = in.readString();
        this.mCode = in.readInt();
        this.mDetails = in.readString();
        this.mFailedOnField = in.readString();
    }

    public class Code {
        public static final int UNKNOWN = 10000;
        public static final int PARSE_ERROR = 10100;
        public static final int NETWORK_ERROR = 10200;
        public static final int AUTO_LOAD_ERROR = 10300;
        public static final int PAGEFLIP = 10400;
        public static final int PAGEFLIP_CATALOG_LOADING_FAILED = 10401;
        public static final int PAGEFLIP_LOADING_PAGES_FAILED = 10402;
        public static final int OUT_OF_MEMORY = 10400;
        public static final int SESSION_ERROR = 1100;
        public static final int TOKEN_EXPIRED = 1101;
        public static final int INVALID_API_KEY = 1102;
        public static final int MISSING_SIGNATURE = 1103;
        public static final int INVALID_SIGNATURE = 1104;
        public static final int TOKEN_NOT_ALLOWED = 1105;
        public static final int MISSING_ORIGIN_HEADER = 1106;
        public static final int MISSING_TOKEN = 1107;
        public static final int INVALID_TOKEN = 1108;
        public static final int AUTENTICATION_ERROR = 1200;
        public static final int USER_AUTENTICATION_FAILED = 1201;
        public static final int USER_NOT_VERIFIED = 1202;
        public static final int AUTHORIZATION_ERROR = 1300;
        public static final int PERMISSION_ERROR = 1301;
        public static final int MISSING_INFORMATION = 1400;
        public static final int MISSING_LOCATION = 1401;
        public static final int MISSING_RADIUS = 1402;
        public static final int FACEBOOK_MISSING_EMAIL = 1431;
        public static final int FACEBOOK_MISSING_BIRTHDAY = 1432;
        public static final int FACEBOOK_MISSING_GENDER = 1433;
        public static final int FACEBOOK_MISSING_LOCALE = 1434;
        public static final int FACEBOOK_MISSING_NAME = 1435;
        public static final int RESOURCE_NOT_FOUND = 1440;
        public static final int RESOURCE_DELETED = 1441;
        public static final int INVALID_INFORMATION = 1500;
        public static final int INVALID_RESOURCE_ID = 1501;
        public static final int DUBLICATION_OF_RESOURCE = 1530;
        public static final int INVALID_BODY_DATA = 1566;
        public static final int INTERNAL_INTEGRITY_ERROR = 2000;
        public static final int INTERNAL_SEARCH_ERROR = 2010;
        public static final int NON_CRITICAL_INTERNAL_ERROR = 1201;
        public static final int ACTION_DOES_NOT_EXIST = 4000;
        public static final int SERVICE_UNAVAILABLE = 5000;
        public static final int SERVICE_DOWN_MAINTENANCE = 5010;
        public static final int FEATURE_DOWN_MAINTENANCE = 5020;
    }
}

