/*
 * Decompiled with CFR 0.152.
 */
package com.shopgun.android.sdk.network;

import com.shopgun.android.sdk.network.Cache;
import com.shopgun.android.sdk.network.ShopGunError;
import java.util.Map;

public class Response<T> {
    public final T result;
    public final ShopGunError error;
    public Map<String, Cache.Item> cache;

    private Response(T result, Map<String, Cache.Item> cache, ShopGunError error) {
        this.result = result;
        this.error = error;
        this.cache = cache;
    }

    public static <T> Response<T> fromSuccess(T result, Map<String, Cache.Item> cache) {
        return new Response<T>(result, cache, null);
    }

    public static <T> Response<T> fromError(ShopGunError error) {
        return new Response<Object>(null, null, error);
    }

    public boolean isSuccess() {
        return this.error == null;
    }

    public static interface Listener<T> {
        public void onComplete(T var1, ShopGunError var2);
    }
}

