/*
 * Decompiled with CFR 0.152.
 */
package com.shopgun.android.sdk.network;

import com.shopgun.android.sdk.log.EventLog;
import com.shopgun.android.sdk.log.SgnLog;
import com.shopgun.android.sdk.network.Cache;
import com.shopgun.android.sdk.network.Delivery;
import com.shopgun.android.sdk.network.NetworkResponse;
import com.shopgun.android.sdk.network.RequestDebugger;
import com.shopgun.android.sdk.network.RequestQueue;
import com.shopgun.android.sdk.network.Response;
import com.shopgun.android.sdk.network.ShopGunError;
import com.shopgun.android.sdk.utils.Constants;
import com.shopgun.android.sdk.utils.SgnUtils;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.json.JSONException;
import org.json.JSONObject;

public abstract class Request<T>
implements Comparable<Request<T>> {
    public static final String TAG = Constants.getTag(Request.class);
    protected static final String DEFAULT_PARAMS_ENCODING = "utf-8";
    protected static final long DEFAULT_CACHE_TTL = TimeUnit.MINUTES.toMillis(3L);
    private static final int CONNECTION_TIME_OUT = (int)TimeUnit.SECONDS.toMillis(20L);
    private final Response.Listener<T> mListener;
    private final Method mMethod;
    private final EventLog mEventLog;
    private final JSONObject mNetworkLog;
    private String mUrl;
    private Map<String, String> mHeaders = new HashMap<String, String>();
    private int mSequence = 0;
    private Map<String, Cache.Item> mCache = new HashMap<String, Cache.Item>();
    private Map<String, String> mParameters = new HashMap<String, String>();
    private boolean mUseLocation = true;
    private boolean mIgnoreCache = false;
    private boolean mIsCacheable = true;
    private boolean mCanceled = false;
    private boolean mFinished = false;
    private int mTimeout = CONNECTION_TIME_OUT;
    private boolean mCacheHit = false;
    private RequestDebugger mDebugger;
    private boolean mSaveNetworkLog = true;
    private RequestQueue mRequestQueue;
    private Object mTag;
    private Delivery mDelivery;

    public Request(Method method, String url, Response.Listener<T> listener) {
        this.mMethod = method;
        this.mUrl = url;
        this.mListener = listener;
        this.mEventLog = new EventLog();
        this.mNetworkLog = new JSONObject();
    }

    protected void resetstate() {
        this.mEventLog.add("request-state-reset");
        this.mFinished = false;
        this.mCanceled = false;
        this.mCacheHit = false;
    }

    public void addEvent(String event) {
        this.mEventLog.add(event);
    }

    public EventLog getLog() {
        return this.mEventLog;
    }

    public synchronized void cancel() {
        this.mCanceled = true;
    }

    public synchronized boolean isCanceled() {
        return this.mCanceled;
    }

    public synchronized boolean isFinished() {
        return this.mFinished;
    }

    public synchronized Request finish(String reason) {
        if (this.mFinished) {
            SgnLog.d(TAG, this.getClass().getSimpleName() + " - Request already finished, " + this.toString());
        }
        this.addEvent(reason);
        try {
            this.mNetworkLog.put("duration", this.mEventLog.getTotalDuration());
        }
        catch (JSONException e) {
            SgnLog.e(TAG, "", e);
        }
        if (this.mSaveNetworkLog) {
            // empty if block
        }
        this.mFinished = true;
        if (this.mRequestQueue != null) {
            this.mRequestQueue.finish(this);
        }
        if (this.mDebugger != null) {
            this.mDebugger.onFinish(this);
        }
        return this;
    }

    public JSONObject getNetworkLog() {
        return this.mNetworkLog;
    }

    public void stats(int in, int out) {
        this.mRequestQueue.dataIn += in;
        this.mRequestQueue.dataOut += out;
    }

    public int getTimeOut() {
        return this.mTimeout;
    }

    public Request setTimeOut(int timeout) {
        this.mTimeout = timeout;
        return this;
    }

    public Map<String, String> getHeaders() {
        return this.mHeaders;
    }

    public void setHeaders(Map<String, String> headers) {
        this.mHeaders.putAll(headers);
    }

    public Method getMethod() {
        return this.mMethod;
    }

    public boolean isCacheable() {
        return this.mIsCacheable;
    }

    protected void setCacheable(boolean cacheable) {
        this.mIsCacheable = cacheable;
    }

    public Object getTag() {
        return this.mTag;
    }

    public Request setTag(Object tag) {
        this.mTag = tag;
        return this;
    }

    protected RequestQueue getRequestQueue() {
        return this.mRequestQueue;
    }

    public synchronized Request setRequestQueue(RequestQueue requestQueue) {
        this.mRequestQueue = requestQueue;
        return this;
    }

    public boolean isCacheHit() {
        return this.mCacheHit;
    }

    public Request setCacheHit(boolean cacheHit) {
        this.mCacheHit = cacheHit;
        return this;
    }

    public long getCacheTTL() {
        return DEFAULT_CACHE_TTL;
    }

    public boolean ignoreCache() {
        return this.mIgnoreCache;
    }

    public Request setIgnoreCache(boolean skip) {
        this.mIgnoreCache = skip;
        return this;
    }

    public Delivery getDelivery() {
        return this.mDelivery;
    }

    public Request setDelivery(Delivery d) {
        this.mDelivery = d;
        return this;
    }

    public Map<String, Cache.Item> getCache() {
        return this.mCache;
    }

    public Request putCache(Map<String, Cache.Item> cache) {
        this.mCache.putAll(cache);
        return this;
    }

    public boolean useLocation() {
        return this.mUseLocation;
    }

    public Request setUseLocation(boolean useLocation) {
        this.mUseLocation = useLocation;
        return this;
    }

    public String getUrl() {
        return this.mUrl;
    }

    public Request setUrl(String url) {
        this.mUrl = url;
        return this;
    }

    public Map<String, String> getParameters() {
        return this.mParameters;
    }

    public Request putParameters(Map<String, String> query) {
        if (query != null) {
            this.mParameters.putAll(query);
        }
        return this;
    }

    protected Priority getPriority() {
        return Priority.MEDIUM;
    }

    protected int getSequence() {
        return this.mSequence;
    }

    protected void setSequence(int seq) {
        this.mSequence = seq;
    }

    public String getParamsEncoding() {
        return DEFAULT_PARAMS_ENCODING;
    }

    public String getBodyContentType() {
        return "application/x-www-form-urlencoded; charset=" + this.getParamsEncoding();
    }

    public byte[] getBody() {
        return null;
    }

    protected abstract Response<T> parseNetworkResponse(NetworkResponse var1);

    protected abstract Response<T> parseCache(Cache var1);

    public void deliverResponse(T response, ShopGunError error) {
        if (this.mDebugger != null) {
            this.mDebugger.onDelivery(this, response, error);
        }
        if (this.mListener != null) {
            this.mListener.onComplete(response, error);
        }
    }

    @Override
    public int compareTo(Request<T> other) {
        Priority right;
        Priority left = this.getPriority();
        return left == (right = other.getPriority()) ? this.mSequence - other.mSequence : right.ordinal() - left.ordinal();
    }

    public RequestDebugger getDebugger() {
        return this.mDebugger;
    }

    public Request setDebugger(RequestDebugger debugger) {
        this.mDebugger = debugger;
        return this;
    }

    public void setSaveNetworkLog(boolean saveNetworkLog) {
        this.mSaveNetworkLog = saveNetworkLog;
    }

    public String toString() {
        return this.mMethod.toString() + ": " + SgnUtils.requestToUrlAndQueryString(this);
    }

    public static enum Method {
        GET,
        POST,
        PUT,
        DELETE;

    }

    public static enum Priority {
        LOW,
        MEDIUM,
        HIGH;

    }
}

