/*
 * Decompiled with CFR 0.152.
 */
package com.shopgun.android.sdk.model;

import android.annotation.SuppressLint;
import android.os.Parcel;
import android.os.Parcelable;
import com.shopgun.android.sdk.model.interfaces.IJson;
import com.shopgun.android.sdk.model.interfaces.SyncState;
import com.shopgun.android.sdk.utils.Constants;
import com.shopgun.android.sdk.utils.SgnJson;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONObject;

public class Share
implements Comparable<Share>,
SyncState<Share>,
IJson<JSONObject>,
Parcelable {
    public static final String TAG = Constants.getTag(Share.class);
    public static final String ACCESS_OWNER = "owner";
    public static final String ACCESS_READWRITE = "rw";
    public static final String ACCESS_READONLY = "r";
    public static Parcelable.Creator<Share> CREATOR = new Parcelable.Creator<Share>(){

        public Share createFromParcel(Parcel source) {
            return new Share(source);
        }

        public Share[] newArray(int size) {
            return new Share[size];
        }
    };
    private String mName;
    private String mEmail;
    public static Comparator<Share> EMAIL_ASCENDING = new Comparator<Share>(){

        @Override
        @SuppressLint(value={"DefaultLocale"})
        public int compare(Share item1, Share item2) {
            String e1 = item1.getEmail().toLowerCase();
            String e2 = item2.getEmail().toLowerCase();
            return e1.compareTo(e2);
        }
    };
    private String mAccess;
    private String mShoppinglistId;
    private boolean mAccepted;
    private String mAcceptUrl;
    private int mSyncState = 0;

    public Share(String email, String access, String acceptUrl) {
        this.mName = email;
        this.mEmail = email;
        this.mAccess = access;
        this.mAcceptUrl = acceptUrl;
    }

    private Share() {
    }

    private Share(Parcel in) {
        this.mName = in.readString();
        this.mEmail = in.readString();
        this.mAccess = in.readString();
        this.mShoppinglistId = in.readString();
        this.mAccepted = in.readByte() != 0;
        this.mAcceptUrl = in.readString();
        this.mSyncState = in.readInt();
    }

    public static List<Share> fromJSON(JSONArray array) {
        ArrayList<Share> list = new ArrayList<Share>();
        for (int i = 0; i < array.length(); ++i) {
            JSONObject o = array.optJSONObject(i);
            if (o == null) continue;
            list.add(Share.fromJSON(o));
        }
        return list;
    }

    public static Share fromJSON(JSONObject object) {
        if (object == null) {
            return null;
        }
        SgnJson o = new SgnJson(object);
        Share s = new Share();
        SgnJson u = new SgnJson(o.getJSONObject("user"));
        s.setEmail(u.getEmail());
        s.setName(u.getName());
        s.setAccess(o.getAccess());
        s.setAccepted(o.getAccepted());
        if (o.has("accept_url")) {
            s.setAcceptUrl(o.getAcceptUrl());
        }
        o.getStats().log(TAG);
        return s;
    }

    @Override
    public JSONObject toJSON() {
        SgnJson u = new SgnJson().setEmail(this.getEmail()).setName(this.getName());
        SgnJson o = new SgnJson().put("user", u.toJSON()).setAccepted(this.getAccepted()).setAccess(this.getAccess());
        if (this.getAcceptUrl() != null) {
            o.setAcceptUrl(this.getAcceptUrl());
        }
        return o.toJSON();
    }

    public String getEmail() {
        return this.mEmail;
    }

    public Share setEmail(String email) {
        if (email != null) {
            this.mEmail = email;
        }
        return this;
    }

    public String getName() {
        return this.mName;
    }

    public Share setName(String name) {
        if (name != null) {
            this.mName = name;
        }
        return this;
    }

    public String getAccess() {
        return this.mAccess;
    }

    public Share setAccess(String permission2) {
        if (permission2 != null) {
            this.mAccess = permission2;
        }
        return this;
    }

    public boolean isAccessOwner() {
        return ACCESS_OWNER.equals(this.mAccess);
    }

    public boolean isAccessReadWrite() {
        return ACCESS_READWRITE.equals(this.mAccess);
    }

    public boolean isAccessReadOnly() {
        return ACCESS_READONLY.equals(this.mAccess);
    }

    public boolean haveAcceptedInvite() {
        return this.mEmail != null && this.mName != null && !this.mEmail.equals(this.mName);
    }

    public boolean getAccepted() {
        return this.mAccepted;
    }

    public Share setAccepted(boolean accepted) {
        this.mAccepted = accepted;
        return this;
    }

    public String getAcceptUrl() {
        return this.mAcceptUrl;
    }

    public Share setAcceptUrl(String url) {
        this.mAcceptUrl = url;
        return this;
    }

    public String getShoppinglistId() {
        return this.mShoppinglistId;
    }

    public Share setShoppinglistId(String id) {
        this.mShoppinglistId = id;
        return this;
    }

    @Override
    public int getState() {
        return this.mSyncState;
    }

    @Override
    public Share setState(int state) {
        this.mSyncState = state;
        return this;
    }

    public String toString() {
        return this.toJSON().toString();
    }

    @Override
    public int compareTo(Share another) {
        return 0;
    }

    public boolean same(Object obj) {
        return this.compare(obj, false);
    }

    public boolean compare(Object obj, boolean syncState) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Share other = (Share)obj;
        if (this.mAcceptUrl == null ? other.mAcceptUrl != null : !this.mAcceptUrl.equals(other.mAcceptUrl)) {
            return false;
        }
        if (this.mAccepted != other.mAccepted) {
            return false;
        }
        if (this.mAccess == null ? other.mAccess != null : !this.mAccess.equals(other.mAccess)) {
            return false;
        }
        if (this.mEmail == null ? other.mEmail != null : !this.mEmail.equals(other.mEmail)) {
            return false;
        }
        if (this.mName == null ? other.mName != null : !this.mName.equals(other.mName)) {
            return false;
        }
        if (this.mShoppinglistId == null ? other.mShoppinglistId != null : !this.mShoppinglistId.equals(other.mShoppinglistId)) {
            return false;
        }
        return !syncState || this.mSyncState == other.mSyncState;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.mAcceptUrl == null ? 0 : this.mAcceptUrl.hashCode());
        result = 31 * result + (this.mAccepted ? 1231 : 1237);
        result = 31 * result + (this.mAccess == null ? 0 : this.mAccess.hashCode());
        result = 31 * result + (this.mEmail == null ? 0 : this.mEmail.hashCode());
        result = 31 * result + (this.mName == null ? 0 : this.mName.hashCode());
        result = 31 * result + (this.mShoppinglistId == null ? 0 : this.mShoppinglistId.hashCode());
        result = 31 * result + this.mSyncState;
        return result;
    }

    public boolean equals(Object obj) {
        return this.compare(obj, true);
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        dest.writeString(this.mName);
        dest.writeString(this.mEmail);
        dest.writeString(this.mAccess);
        dest.writeString(this.mShoppinglistId);
        dest.writeByte(this.mAccepted ? (byte)1 : 0);
        dest.writeString(this.mAcceptUrl);
        dest.writeInt(this.mSyncState);
    }
}

