/*
 * Decompiled with CFR 0.152.
 */
package com.shopgun.android.sdk.model;

import android.graphics.Bitmap;
import android.os.Parcel;
import android.os.Parcelable;
import android.support.annotation.NonNull;
import com.shopgun.android.sdk.model.Dimension;
import com.shopgun.android.sdk.model.Hotspot;
import com.shopgun.android.sdk.model.interfaces.IJson;
import com.shopgun.android.sdk.pagedpublicationkit.PagedPublicationHotspot;
import com.shopgun.android.sdk.pagedpublicationkit.PagedPublicationHotspotCollection;
import com.shopgun.android.sdk.utils.Constants;
import java.util.ArrayList;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONObject;

public class HotspotMap
implements IJson<JSONArray>,
PagedPublicationHotspotCollection,
Parcelable {
    public static final String TAG = Constants.getTag(HotspotMap.class);
    private List<Hotspot> mHotspots = new ArrayList<Hotspot>();
    private boolean mNormalised;
    public static final Parcelable.Creator<HotspotMap> CREATOR = new Parcelable.Creator<HotspotMap>(){

        public HotspotMap createFromParcel(Parcel source) {
            return new HotspotMap(source);
        }

        public HotspotMap[] newArray(int size) {
            return new HotspotMap[size];
        }
    };

    public static HotspotMap fromJSON(Dimension dimension, JSONArray hotspots) {
        HotspotMap list = new HotspotMap();
        if (hotspots == null) {
            return list;
        }
        Object tmp = null;
        for (int i = 0; i < hotspots.length(); ++i) {
            JSONObject hotspot = hotspots.optJSONObject(i);
            String type = hotspot.optString("type", null);
            if (!"offer".equals(type)) continue;
            Hotspot h = Hotspot.fromJSON(hotspot);
            list.mHotspots.add(h);
        }
        list.normalize(dimension);
        return list;
    }

    public HotspotMap() {
    }

    public synchronized void normalize(Bitmap b) {
        this.normalize(Dimension.fromBitmap(b));
    }

    public synchronized void normalize(Dimension d) {
        if (d != null && d.isSet()) {
            this.normalize(d.getWidth(), d.getHeight());
        }
    }

    public void normalize(double width, double height) {
        if (!this.mNormalised) {
            for (Hotspot h : this.mHotspots) {
                h.normalize(width, height);
            }
        }
        this.mNormalised = true;
    }

    @Override
    public JSONArray toJSON() {
        return null;
    }

    @Override
    @NonNull
    public List<PagedPublicationHotspot> getPagedPublicationHotspots(int[] visiblePages, int clickedPage, float x, float y) {
        List<Hotspot> tmp = this.getHotspots(visiblePages, clickedPage, x, y);
        ArrayList<PagedPublicationHotspot> hotspots = new ArrayList<PagedPublicationHotspot>(tmp.size());
        for (Hotspot h : tmp) {
            hotspots.add(h);
        }
        return hotspots;
    }

    @Override
    @NonNull
    public List<PagedPublicationHotspot> getPagedPublicationHotspots(int[] visiblePages) {
        List<Hotspot> tmp = this.getHotspots(visiblePages);
        ArrayList<PagedPublicationHotspot> hotspots = new ArrayList<PagedPublicationHotspot>(tmp.size());
        for (Hotspot h : tmp) {
            hotspots.add(h);
        }
        return hotspots;
    }

    @NonNull
    public List<Hotspot> getHotspots(int[] visiblePages, int clickedPage, float x, float y) {
        ArrayList<Hotspot> list = new ArrayList<Hotspot>();
        float length = visiblePages.length;
        float xOnClickedPage = x % (1.0f / length) * length;
        for (Hotspot h : this.mHotspots) {
            if (!h.hasLocationAt(visiblePages, clickedPage, xOnClickedPage, y)) continue;
            list.add(h);
        }
        return list;
    }

    @NonNull
    public List<Hotspot> getHotspots(int[] pages) {
        ArrayList<Hotspot> list = new ArrayList<Hotspot>();
        for (Hotspot h : this.mHotspots) {
            if (!this.isMatch(h.getPages(), pages)) continue;
            list.add(h);
        }
        return list;
    }

    private boolean isMatch(int[] hotspotPages, int[] searchPages) {
        for (int hotspotPage : hotspotPages) {
            for (int page : searchPages) {
                if (hotspotPage != page) continue;
                return true;
            }
        }
        return false;
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        dest.writeTypedList(this.mHotspots);
        dest.writeByte(this.mNormalised ? (byte)1 : 0);
    }

    protected HotspotMap(Parcel in) {
        this.mHotspots = in.createTypedArrayList(Hotspot.CREATOR);
        this.mNormalised = in.readByte() != 0;
    }
}

