/*
 * Decompiled with CFR 0.152.
 */
package com.shopgun.android.sdk.model;

import android.os.Parcel;
import android.os.Parcelable;
import com.shopgun.android.materialcolorcreator.MaterialColor;
import com.shopgun.android.materialcolorcreator.MaterialColorImpl;
import com.shopgun.android.sdk.model.Country;
import com.shopgun.android.sdk.model.Pageflip;
import com.shopgun.android.sdk.model.interfaces.IErn;
import com.shopgun.android.sdk.model.interfaces.IJson;
import com.shopgun.android.sdk.utils.Constants;
import com.shopgun.android.sdk.utils.SgnJson;
import com.shopgun.android.utils.ParcelableUtils;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.json.JSONArray;
import org.json.JSONObject;

public class Dealer
implements IErn<Dealer>,
IJson<JSONObject>,
Parcelable {
    public static final String TAG = Constants.getTag(Dealer.class);
    public static Comparator<Dealer> NAME_COMPARATOR = new Comparator<Dealer>(){

        @Override
        public int compare(Dealer item1, Dealer item2) {
            if (item1 == null || item2 == null) {
                return item1 == null ? (item2 == null ? 0 : 1) : -1;
            }
            String t1 = item1.getName();
            String t2 = item2.getName();
            if (t1 == null || t2 == null) {
                return t1 == null ? (t2 == null ? 0 : 1) : -1;
            }
            return t1.compareToIgnoreCase(t2);
        }
    };
    private String mErn;
    private String mName;
    private String mWebsite;
    private String mLogo;
    private MaterialColor mColor;
    private Pageflip mPageflip;
    private Set<String> mCategoryIds;
    private Country mCountry;
    private String mDescription;
    private int mFavoriteCount = 0;
    public static final Parcelable.Creator<Dealer> CREATOR = new Parcelable.Creator<Dealer>(){

        public Dealer createFromParcel(Parcel source) {
            return new Dealer(source);
        }

        public Dealer[] newArray(int size) {
            return new Dealer[size];
        }
    };

    public Dealer() {
    }

    public Dealer(Dealer dealer) {
        Dealer tmp = (Dealer)ParcelableUtils.copyParcelable((Parcelable)dealer, CREATOR);
        this.mErn = tmp.mErn;
        this.mName = tmp.mName;
        this.mWebsite = tmp.mWebsite;
        this.mLogo = tmp.mLogo;
        this.mColor = tmp.mColor;
        this.mPageflip = tmp.mPageflip;
        this.mCategoryIds = tmp.mCategoryIds;
        this.mCountry = tmp.mCountry;
        this.mDescription = tmp.mDescription;
    }

    public static List<Dealer> fromJSON(JSONArray array) {
        ArrayList<Dealer> list = new ArrayList<Dealer>();
        for (int i = 0; i < array.length(); ++i) {
            JSONObject o = array.optJSONObject(i);
            if (o == null) continue;
            list.add(Dealer.fromJSON(o));
        }
        return list;
    }

    public static Dealer fromJSON(JSONObject object) {
        if (object == null) {
            return null;
        }
        SgnJson o = new SgnJson(object);
        Dealer d = new Dealer().setId(o.getId()).setErn(o.getErn()).setName(o.getName()).setWebsite(o.getWebsite()).setLogo(o.getLogo()).setColor(o.getColor()).setPageflip(o.getPageflip()).setCategoryIds(o.getCategoryIds()).setCountry(o.getCountry()).setDescription(o.getDescription()).setFavoriteCount(o.getFavoriteCount());
        o.getStats().ignoreForgottenKeys("youtube_user_id", "twitter_handle", "facebook_page_id").log(TAG);
        return d;
    }

    @Override
    public JSONObject toJSON() {
        return new SgnJson().setId(this.getId()).setErn(this.getErn()).setName(this.getName()).setWebsite(this.getWebsite()).setLogo(this.getLogo()).setColor(this.getColor()).setPageflip(this.getPageflip()).setCategoryIds(this.getCategoryIds()).setCountry(this.getCountry()).setDescription(this.getDescription()).setFavoriteCount(this.getFavoriteCount()).toJSON();
    }

    @Override
    public String getId() {
        if (this.mErn == null) {
            return null;
        }
        String[] parts = this.mErn.split(":");
        return parts[parts.length - 1];
    }

    @Override
    public Dealer setId(String id) {
        this.setErn(id == null ? null : String.format("ern:%s:%s", this.getErnType(), id));
        return this;
    }

    @Override
    public String getErn() {
        return this.mErn;
    }

    @Override
    public Dealer setErn(String ern) {
        if (ern == null || ern.startsWith("ern:") && ern.split(":").length == 3 && ern.contains(this.getErnType())) {
            this.mErn = ern;
        }
        return this;
    }

    @Override
    public String getErnType() {
        return "dealer";
    }

    public String getName() {
        return this.mName;
    }

    public Dealer setName(String name) {
        this.mName = name;
        return this;
    }

    public String getWebsite() {
        return this.mWebsite;
    }

    public Dealer setWebsite(String website) {
        this.mWebsite = website;
        return this;
    }

    public String getLogo() {
        return this.mLogo;
    }

    public Dealer setLogo(String logo) {
        this.mLogo = logo;
        return this;
    }

    public int getColor() {
        return this.getMaterialColor().getValue();
    }

    public MaterialColor getMaterialColor() {
        if (this.mColor == null) {
            this.mColor = new MaterialColorImpl();
        }
        return this.mColor;
    }

    public Dealer setColor(int color) {
        this.setColor((MaterialColor)new MaterialColorImpl(color));
        return this;
    }

    public Dealer setColor(MaterialColor color) {
        this.mColor = color;
        return this;
    }

    public Pageflip getPageflip() {
        return this.mPageflip;
    }

    public Dealer setPageflip(Pageflip pageflip) {
        this.mPageflip = pageflip;
        return this;
    }

    public Set<String> getCategoryIds() {
        return this.mCategoryIds;
    }

    public Dealer setCategoryIds(Set<String> categoryIds) {
        this.mCategoryIds = categoryIds;
        return this;
    }

    public Country getCountry() {
        return this.mCountry;
    }

    public Dealer setCountry(Country country) {
        this.mCountry = country;
        return this;
    }

    public String getDescription() {
        return this.mDescription;
    }

    public Dealer setDescription(String description) {
        this.mDescription = description;
        return this;
    }

    public int getFavoriteCount() {
        return this.mFavoriteCount;
    }

    public Dealer setFavoriteCount(int favCount) {
        if (favCount >= 0) {
            this.mFavoriteCount = favCount;
        }
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Dealer dealer = (Dealer)o;
        if (this.mFavoriteCount != dealer.mFavoriteCount) {
            return false;
        }
        if (this.mErn != null ? !this.mErn.equals(dealer.mErn) : dealer.mErn != null) {
            return false;
        }
        if (this.mName != null ? !this.mName.equals(dealer.mName) : dealer.mName != null) {
            return false;
        }
        if (this.mWebsite != null ? !this.mWebsite.equals(dealer.mWebsite) : dealer.mWebsite != null) {
            return false;
        }
        if (this.mLogo != null ? !this.mLogo.equals(dealer.mLogo) : dealer.mLogo != null) {
            return false;
        }
        if (this.mColor != null ? !this.mColor.equals(dealer.mColor) : dealer.mColor != null) {
            return false;
        }
        if (this.mPageflip != null ? !this.mPageflip.equals(dealer.mPageflip) : dealer.mPageflip != null) {
            return false;
        }
        if (this.mCategoryIds != null ? !this.mCategoryIds.equals(dealer.mCategoryIds) : dealer.mCategoryIds != null) {
            return false;
        }
        if (this.mCountry != null ? !this.mCountry.equals(dealer.mCountry) : dealer.mCountry != null) {
            return false;
        }
        return this.mDescription != null ? this.mDescription.equals(dealer.mDescription) : dealer.mDescription == null;
    }

    public int hashCode() {
        int result = this.mErn != null ? this.mErn.hashCode() : 0;
        result = 31 * result + (this.mName != null ? this.mName.hashCode() : 0);
        result = 31 * result + (this.mWebsite != null ? this.mWebsite.hashCode() : 0);
        result = 31 * result + (this.mLogo != null ? this.mLogo.hashCode() : 0);
        result = 31 * result + (this.mColor != null ? this.mColor.hashCode() : 0);
        result = 31 * result + (this.mPageflip != null ? this.mPageflip.hashCode() : 0);
        result = 31 * result + (this.mCategoryIds != null ? this.mCategoryIds.hashCode() : 0);
        result = 31 * result + (this.mCountry != null ? this.mCountry.hashCode() : 0);
        result = 31 * result + (this.mDescription != null ? this.mDescription.hashCode() : 0);
        result = 31 * result + this.mFavoriteCount;
        return result;
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        dest.writeString(this.mErn);
        dest.writeString(this.mName);
        dest.writeString(this.mWebsite);
        dest.writeString(this.mLogo);
        dest.writeParcelable((Parcelable)this.mColor, 0);
        dest.writeParcelable((Parcelable)this.mPageflip, 0);
        dest.writeStringList(new ArrayList<String>(this.mCategoryIds));
        dest.writeParcelable((Parcelable)this.mCountry, 0);
        dest.writeString(this.mDescription);
        dest.writeInt(this.mFavoriteCount);
    }

    protected Dealer(Parcel in) {
        this.mErn = in.readString();
        this.mName = in.readString();
        this.mWebsite = in.readString();
        this.mLogo = in.readString();
        this.mColor = (MaterialColor)in.readParcelable(MaterialColor.class.getClassLoader());
        this.mPageflip = (Pageflip)in.readParcelable(Pageflip.class.getClassLoader());
        ArrayList catIds = new ArrayList();
        in.readStringList(catIds);
        this.mCategoryIds = new HashSet<String>(catIds);
        this.mCountry = (Country)in.readParcelable(Country.class.getClassLoader());
        this.mDescription = in.readString();
        this.mFavoriteCount = in.readInt();
    }
}

