/*
 * Decompiled with CFR 0.152.
 */
package com.shopgun.android.sdk.log;

import android.content.Context;
import com.shopgun.android.sdk.ShopGun;
import com.shopgun.android.sdk.log.Event;
import com.shopgun.android.sdk.log.SgnLog;
import com.shopgun.android.sdk.network.Request;
import com.shopgun.android.sdk.network.impl.IgnoreResponseListener;
import com.shopgun.android.sdk.network.impl.JsonObjectRequest;
import com.shopgun.android.sdk.utils.Constants;
import com.shopgun.android.sdk.utils.Device;
import com.shopgun.android.utils.PackageUtils;
import java.util.ArrayList;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class AppLogEntry {
    public static final String TAG = Constants.getTag(AppLogEntry.class);
    public static boolean DEBUG = false;
    private final ShopGun mShopgun;
    private String mEmail;
    private List<Event> mEvents = new ArrayList<Event>();
    private boolean mSingleEntry = true;
    private String mEntryName;

    public AppLogEntry(ShopGun sgn, String entryName) {
        this(sgn, entryName, null);
    }

    public AppLogEntry(ShopGun sgn, String entryName, String email) {
        if (sgn == null) {
            throw new IllegalStateException("ShopGun cannot be null");
        }
        this.mShopgun = sgn;
        this.mEmail = email;
        this.mEntryName = entryName;
        if (this.mEmail == null) {
            this.mEmail = this.mShopgun.getSessionManager().getSession().getUser().getEmail();
        }
    }

    public String getEmail() {
        return this.mEmail;
    }

    public List<Event> getEvents() {
        return this.mEvents;
    }

    public AppLogEntry setEvents(List<Event> events) {
        this.mEvents = events;
        return this;
    }

    public AppLogEntry addEvent(String name, JSONObject data) {
        this.addEvent(new Event(this.mShopgun, name).setData(data));
        return this;
    }

    public AppLogEntry addEvent(Event event) {
        this.mEvents.add(event);
        return this;
    }

    public AppLogEntry addEvents(List<Event> events) {
        this.mEvents.addAll(events);
        return this;
    }

    private JSONObject toJSON(JSONArray events) {
        try {
            JSONObject device = new JSONObject();
            device.put("useragent", (Object)Device.getDeviceInfo());
            JSONObject app = new JSONObject();
            String appVersion = PackageUtils.getVersionName((Context)this.mShopgun.getContext());
            app.put("version", (Object)(appVersion == null ? "null" : appVersion));
            JSONObject eventLog = new JSONObject();
            eventLog.put("tag", (Object)this.mEmail);
            eventLog.put("device", (Object)device);
            eventLog.put("app", (Object)app);
            eventLog.put("events", (Object)events);
            return eventLog;
        }
        catch (JSONException jSONException) {
            return new JSONObject();
        }
    }

    private JSONObject createJSONArrayWrapper() {
        try {
            JSONObject o = new JSONObject();
            JSONArray a = new JSONArray();
            for (Event e : this.mEvents) {
                a.put((Object)e.toJSON(false));
            }
            o.put(this.mEntryName, (Object)a);
            return o;
        }
        catch (JSONException e) {
            SgnLog.e(TAG, "Creating JSON wrapper failed", e);
            return new JSONObject();
        }
    }

    public AppLogEntry setSingleEntry(boolean singleEntry) {
        this.mSingleEntry = singleEntry;
        return this;
    }

    public JsonObjectRequest post() {
        List<Event> list;
        if (this.mSingleEntry) {
            Event e = new Event(this.mShopgun, this.mEntryName);
            e.setData(this.createJSONArrayWrapper());
            list = new ArrayList<Event>();
            list.add(e);
        } else {
            list = this.mEvents;
        }
        JSONArray eventList = Event.toJSON(list, false);
        JSONObject appLogObject = this.toJSON(eventList);
        JsonObjectRequest r = new JsonObjectRequest(Request.Method.POST, "/v2/admin/utils/apps/log", appLogObject, new IgnoreResponseListener<JSONObject>());
        if (DEBUG) {
            this.mShopgun.add(r);
        }
        return r;
    }
}

